/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.ContextAwareFunction;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.util.SafeCloseable;
import java.util.Objects;
import java.util.function.Function;

final class DefaultContextAwareFunction<T, R>
implements ContextAwareFunction<T, R> {
    private final RequestContext context;
    private final Function<T, R> function;

    DefaultContextAwareFunction(RequestContext context, Function<T, R> function) {
        this.context = Objects.requireNonNull(context, "context");
        this.function = Objects.requireNonNull(function, "function");
    }

    @Override
    public RequestContext context() {
        return this.context;
    }

    @Override
    public Function<T, R> withoutContext() {
        return this.function;
    }

    @Override
    public R apply(T t) {
        try (SafeCloseable ignored = this.context.push();){
            R r = this.function.apply(t);
            return r;
        }
    }
}

