/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.fastutil.chars.Char2ObjectMap;
import com.linecorp.armeria.internal.shaded.fastutil.chars.Char2ObjectMaps;
import com.linecorp.armeria.internal.shaded.fastutil.chars.Char2ObjectOpenHashMap;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableCollection;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.RoutingTrie;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

final class RoutingTrieBuilder<V> {
    private static final char KEY_PARAMETER = '\u0001';
    private static final char KEY_CATCH_ALL = '\u0002';
    private final List<Entry<V>> routes = new ArrayList<Entry<V>>();
    @Nullable
    private Comparator<V> comparator;

    RoutingTrieBuilder() {
    }

    RoutingTrieBuilder<V> add(String path, V value) {
        return this.add(path, value, true);
    }

    RoutingTrieBuilder<V> add(String path, V value, boolean hasHighPrecedence) {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(value, "value");
        Preconditions.checkArgument(!path.isEmpty(), "A path should not be empty.");
        Preconditions.checkArgument(path.charAt(0) != '*' && path.charAt(0) != ':', "A path starting with '*' or ':' is not allowed.");
        Preconditions.checkArgument(path.indexOf(1) < 0, "A path should not contain %s: %s", (Object)Integer.toHexString(1), (Object)path);
        Preconditions.checkArgument(path.indexOf(2) < 0, "A path should not contain %s: %s", (Object)Integer.toHexString(2), (Object)path);
        this.routes.add(new Entry<V>(path, value, hasHighPrecedence));
        return this;
    }

    RoutingTrieBuilder<V> comparator(Comparator<V> comparator) {
        this.comparator = comparator;
        return this;
    }

    RoutingTrie<V> build() {
        Preconditions.checkState(!this.routes.isEmpty(), "No routes added");
        NodeBuilder<V> root = this.insertAndGetRoot(this.routes.get(0));
        for (int i = 1; i < this.routes.size(); ++i) {
            Entry<V> route = this.routes.get(i);
            this.addRoute(root, route);
        }
        return new RoutingTrie<V>(root.build());
    }

    private NodeBuilder<V> insertAndGetRoot(Entry<V> entry) {
        NodeBuilder node = this.insertChild(null, entry.path, entry.value, entry.hasHighPrecedence);
        NodeBuilder parent;
        while ((parent = node.parent) != null) {
            node = parent;
        }
        return node;
    }

    private void addRoute(NodeBuilder<V> node, Entry<V> entry) {
        String path = entry.path;
        NodeBuilder current = node;
        while (true) {
            int same;
            String p = current.path;
            int max = Math.min(p.length(), path.length());
            for (same = 0; same < max && p.charAt(same) == path.charAt(same); ++same) {
            }
            if (same < p.length()) {
                current.split(same);
            }
            if (same == path.length()) {
                current.addValue(entry.value, entry.hasHighPrecedence, this.comparator);
                return;
            }
            char nextChar = RoutingTrieBuilder.convertKey(path.charAt(same));
            NodeBuilder<V> next = current.child(nextChar);
            if (next == null) {
                this.insertChild(current, path.substring(same), entry.value, entry.hasHighPrecedence);
                return;
            }
            current = next;
            path = path.substring(same);
        }
    }

    static char convertKey(char key) {
        switch (key) {
            case ':': {
                return '\u0001';
            }
            case '*': {
                return '\u0002';
            }
        }
        return key;
    }

    private NodeBuilder<V> insertChild(@Nullable NodeBuilder<V> node, String path, V value, boolean highPrecedence) {
        int pathStart = 0;
        int max = path.length();
        for (int i = 0; i < max; ++i) {
            char c = path.charAt(i);
            if (c != '*' && c != ':') continue;
            if (c == '*' && i + 1 < max) {
                throw new IllegalStateException("Catch-all should be the last in the path: " + path);
            }
            if (i > pathStart) {
                node = this.asChild(new NodeBuilder<V>(RoutingTrie.NodeType.EXACT, node, path.substring(pathStart, i)));
            }
            pathStart = i + 1;
            node = c == '*' ? this.asChild(new NodeBuilder<V>(RoutingTrie.NodeType.CATCH_ALL, node, "*")) : this.asChild(new NodeBuilder<V>(RoutingTrie.NodeType.PARAMETER, node, ":"));
        }
        if (pathStart < max) {
            node = this.asChild(new NodeBuilder<V>(RoutingTrie.NodeType.EXACT, node, path.substring(pathStart)));
        }
        assert (node != null);
        node.addValue(value, highPrecedence, this.comparator);
        return node;
    }

    private NodeBuilder<V> asChild(NodeBuilder<V> child) {
        NodeBuilder<V> parent = child.parent;
        return parent == null ? child : parent.addChild(child);
    }

    private static final class Entry<V> {
        final String path;
        final V value;
        final boolean hasHighPrecedence;

        Entry(String path, V value, boolean hasHighPrecedence) {
            this.path = path;
            this.value = value;
            this.hasHighPrecedence = hasHighPrecedence;
        }
    }

    private static final class NodeBuilder<V> {
        private final RoutingTrie.NodeType type;
        @Nullable
        NodeBuilder<V> parent;
        String path;
        @Nullable
        private Char2ObjectMap<NodeBuilder<V>> children;
        @Nullable
        private List<V> valuesWithHighPrecedence;
        @Nullable
        private List<V> valuesWithLowPrecedence;

        NodeBuilder(RoutingTrie.NodeType type, @Nullable NodeBuilder<V> parent, String path) {
            this.type = Objects.requireNonNull(type, "type");
            this.parent = parent;
            this.path = Objects.requireNonNull(path, "path");
        }

        @Nullable
        NodeBuilder<V> child(char key) {
            return this.children == null ? null : (NodeBuilder)this.children.get(key);
        }

        void addValue(V value, boolean highPrecedence, @Nullable Comparator<V> comparator) {
            List<V> values;
            if (highPrecedence) {
                if (this.valuesWithHighPrecedence == null) {
                    this.valuesWithHighPrecedence = new ArrayList<V>(4);
                }
                values = this.valuesWithHighPrecedence;
            } else {
                if (this.valuesWithLowPrecedence == null) {
                    this.valuesWithLowPrecedence = new ArrayList<V>(4);
                }
                values = this.valuesWithLowPrecedence;
            }
            values.add(value);
            if (comparator != null && values.size() > 1) {
                values.sort(comparator);
            }
        }

        NodeBuilder<V> addChild(NodeBuilder<V> child) {
            Objects.requireNonNull(child, "child");
            char key = RoutingTrieBuilder.convertKey(child.path.charAt(0));
            if (this.children == null) {
                this.children = new Char2ObjectOpenHashMap<NodeBuilder<V>>();
            }
            if (this.children.containsKey(key)) {
                throw new IllegalStateException("Path starting with '" + key + "' already exist:" + child);
            }
            this.children.put(key, (NodeBuilder<NodeBuilder<V>>)child);
            return child;
        }

        void split(int pathSplitPos) {
            Preconditions.checkArgument(pathSplitPos > 0 && pathSplitPos < this.path.length(), "Invalid split index of the path: %s", pathSplitPos);
            String parentPath = this.path.substring(0, pathSplitPos);
            String childPath = this.path.substring(pathSplitPos);
            NodeBuilder child = new NodeBuilder(this.type, this, childPath);
            child.valuesWithHighPrecedence = this.valuesWithHighPrecedence;
            child.valuesWithLowPrecedence = this.valuesWithLowPrecedence;
            child.children = this.children;
            if (child.children != null) {
                child.children.values().forEach(c -> {
                    c.parent = child;
                });
            }
            this.children = null;
            this.valuesWithHighPrecedence = null;
            this.valuesWithLowPrecedence = null;
            this.updatePath(parentPath);
            this.addChild(child);
        }

        private void updatePath(String path) {
            Objects.requireNonNull(path, "path");
            Preconditions.checkArgument(this.path.charAt(0) == path.charAt(0), "Not acceptable path for update: %s", (Object)path);
            this.path = path;
        }

        RoutingTrie.Node<V> build() {
            ImmutableCollection values;
            Char2ObjectMap children;
            RoutingTrie.Node<V> parameterChild = null;
            RoutingTrie.Node<V> catchAllChild = null;
            if (this.children == null || this.children.isEmpty()) {
                children = Char2ObjectMaps.emptyMap();
            } else {
                Char2ObjectOpenHashMap<RoutingTrie.Node<V>> newChildren = new Char2ObjectOpenHashMap<RoutingTrie.Node<V>>(this.children.size());
                for (Char2ObjectMap.Entry entry : this.children.char2ObjectEntrySet()) {
                    RoutingTrie.Node<V> newChild = ((NodeBuilder)entry.getValue()).build();
                    switch (newChild.type) {
                        case PARAMETER: {
                            if (parameterChild != null) break;
                            parameterChild = newChild;
                            break;
                        }
                        case CATCH_ALL: {
                            if (catchAllChild != null) break;
                            catchAllChild = newChild;
                        }
                    }
                    newChildren.put(entry.getCharKey(), newChild);
                }
                children = Char2ObjectMaps.unmodifiable(newChildren);
            }
            if (this.valuesWithHighPrecedence == null) {
                values = this.valuesWithLowPrecedence == null ? ImmutableList.of() : ImmutableList.copyOf(this.valuesWithLowPrecedence);
            } else if (this.valuesWithLowPrecedence == null) {
                values = ImmutableList.copyOf(this.valuesWithHighPrecedence);
            } else {
                ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize(this.valuesWithHighPrecedence.size() + this.valuesWithLowPrecedence.size());
                values = ((ImmutableList.Builder)((ImmutableList.Builder)builder.addAll(this.valuesWithHighPrecedence)).addAll(this.valuesWithLowPrecedence)).build();
            }
            return new RoutingTrie.Node(this.type, this.path, children, parameterChild, catchAllChild, values);
        }
    }
}

