/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.type.geometry;

import java.nio.ByteBuffer;
import org.apache.baremaps.database.type.DataType;
import org.apache.baremaps.database.type.geometry.CoordinateArrayDataType;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPoint;

public class MultiPointDataType
implements DataType<MultiPoint> {
    private final CoordinateArrayDataType coordinateArrayDataType = new CoordinateArrayDataType();
    private final GeometryFactory geometryFactory;

    public MultiPointDataType() {
        this(new GeometryFactory());
    }

    public MultiPointDataType(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
    }

    @Override
    public int size(MultiPoint value) {
        return this.coordinateArrayDataType.size(value.getCoordinates());
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return this.coordinateArrayDataType.size(buffer, position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, MultiPoint value) {
        this.coordinateArrayDataType.write(buffer, position, value.getCoordinates());
    }

    @Override
    public MultiPoint read(ByteBuffer buffer, int position) {
        Coordinate[] coordinates = this.coordinateArrayDataType.read(buffer, position);
        return this.geometryFactory.createMultiPoint(coordinates);
    }
}

