/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.xml;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.baremaps.openstreetmap.model.Bound;
import org.apache.baremaps.openstreetmap.model.Entity;
import org.apache.baremaps.openstreetmap.model.Header;
import org.apache.baremaps.openstreetmap.model.Info;
import org.apache.baremaps.openstreetmap.model.Member;
import org.apache.baremaps.openstreetmap.model.Node;
import org.apache.baremaps.openstreetmap.model.Relation;
import org.apache.baremaps.openstreetmap.model.Way;
import org.apache.baremaps.stream.StreamException;

public class XmlEntitySpliterator
implements Spliterator<Entity> {
    private static final String ELEMENT_NAME_OSM = "osm";
    private static final String ELEMENT_NAME_BOUND = "bound";
    private static final String ELEMENT_NAME_BOUNDS = "bounds";
    private static final String ELEMENT_NAME_NODE = "node";
    private static final String ELEMENT_NAME_WAY = "way";
    private static final String ELEMENT_NAME_RELATION = "relation";
    private static final String ELEMENT_NAME_TAG = "tag";
    private static final String ELEMENT_NAME_NODE_REFERENCE = "nd";
    private static final String ELEMENT_NAME_MEMBER = "member";
    private static final String ATTRIBUTE_NAME_ID = "id";
    private static final String ATTRIBUTE_NAME_VERSION = "version";
    private static final String ATTRIBUTE_NAME_GENERATOR = "generator";
    private static final String ATTRIBUTE_NAME_SOURCE = "source";
    private static final String ATTRIBUTE_NAME_TIMESTAMP = "timestamp";
    private static final String ATTRIBUTE_NAME_OSMOSIS_REPLICATION_URL = "osmosis_replication_url";
    private static final String ATTRIBUTE_NAME_OSMOSIS_REPLICATION_TIMESTAMP = "osmosis_replication_timestamp";
    private static final String ATTRIBUTE_NAME_OSMOSIS_REPLICATION_SEQUENCE_NUMBER = "osmosis_replication_sequence_number";
    private static final String ATTRIBUTE_NAME_USER_ID = "uid";
    private static final String ATTRIBUTE_NAME_CHANGESET_ID = "changeset";
    private static final String ATTRIBUTE_NAME_LATITUDE = "lat";
    private static final String ATTRIBUTE_NAME_LONGITUDE = "lon";
    private static final String ATTRIBUTE_NAME_KEY = "k";
    private static final String ATTRIBUTE_NAME_VALUE = "v";
    private static final String ATTRIBUTE_NAME_REF = "ref";
    private static final String ATTRIBUTE_NAME_TYPE = "type";
    private static final String ATTRIBUTE_NAME_ROLE = "role";
    private static final String ATTRIBUTE_NAME_MAXLON = "maxlon";
    private static final String ATTRIBUTE_NAME_MAXLAT = "maxlat";
    private static final String ATTRIBUTE_NAME_MINLON = "minlon";
    private static final String ATTRIBUTE_NAME_MINLAT = "minlat";
    public static final DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final XMLStreamReader reader;

    public XmlEntitySpliterator(InputStream input) {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.supportDTD", false);
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        factory.setProperty("javax.xml.stream.isNamespaceAware", false);
        factory.setProperty("javax.xml.stream.isValidating", false);
        factory.setProperty("javax.xml.stream.isCoalescing", false);
        try {
            this.reader = factory.createXMLStreamReader(input);
        }
        catch (XMLStreamException e) {
            throw new StreamException(e);
        }
    }

    @Override
    public boolean tryAdvance(Consumer<? super Entity> consumer) {
        try {
            if (this.reader.hasNext()) {
                int event = this.reader.next();
                switch (event) {
                    case 1: {
                        this.readEntity(consumer);
                        return true;
                    }
                    case 8: {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        catch (XMLStreamException e) {
            throw new StreamException(e);
        }
    }

    private void readEntity(Consumer<? super Entity> consumer) throws XMLStreamException {
        switch (this.reader.getLocalName()) {
            case "osm": {
                consumer.accept(this.readHeader());
                return;
            }
            case "bound": 
            case "bounds": {
                consumer.accept(this.readBounds());
                return;
            }
            case "node": {
                consumer.accept(this.readNode());
                return;
            }
            case "way": {
                consumer.accept(this.readWay());
                return;
            }
            case "relation": {
                consumer.accept(this.readRelation());
                return;
            }
        }
        this.readUnknownElement();
    }

    private Header readHeader() {
        String generator = this.reader.getAttributeValue(null, ATTRIBUTE_NAME_GENERATOR);
        String source = this.reader.getAttributeValue(null, ATTRIBUTE_NAME_SOURCE);
        String replicationUrl = this.reader.getAttributeValue(null, ATTRIBUTE_NAME_OSMOSIS_REPLICATION_URL);
        String replicationSequenceNumberValue = this.reader.getAttributeValue(null, ATTRIBUTE_NAME_OSMOSIS_REPLICATION_SEQUENCE_NUMBER);
        Long replicationSequenceNumber = replicationSequenceNumberValue != null ? Long.valueOf(Long.parseLong(replicationSequenceNumberValue)) : null;
        String timestampValue = this.reader.getAttributeValue(null, ATTRIBUTE_NAME_TIMESTAMP);
        LocalDateTime timestamp = timestampValue != null ? LocalDateTime.parse(timestampValue, format) : null;
        String osmosisReplicationTimestampValue = this.reader.getAttributeValue(null, ATTRIBUTE_NAME_OSMOSIS_REPLICATION_TIMESTAMP);
        timestamp = osmosisReplicationTimestampValue != null ? LocalDateTime.parse(osmosisReplicationTimestampValue, format) : timestamp;
        return new Header(replicationSequenceNumber, timestamp, replicationUrl, source, generator);
    }

    private Bound readBounds() {
        double maxLon = Double.parseDouble(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_MAXLON));
        double maxLat = Double.parseDouble(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_MAXLAT));
        double minLon = Double.parseDouble(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_MINLON));
        double minLat = Double.parseDouble(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_MINLAT));
        return new Bound(maxLat, maxLon, minLat, minLon);
    }

    private Node readNode() throws XMLStreamException {
        long id = Long.parseLong(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_ID));
        Info info = this.readInfo();
        double latitude = Double.parseDouble(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_LATITUDE));
        double longitude = Double.parseDouble(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_LONGITUDE));
        HashMap<String, Object> tags = new HashMap<String, Object>();
        this.reader.nextTag();
        block6: while (this.reader.getEventType() == 1) {
            switch (this.reader.getLocalName()) {
                case "tag": {
                    this.readTag(tags);
                    continue block6;
                }
            }
            this.readUnknownElement();
        }
        return new Node(id, info, tags, longitude, latitude);
    }

    private Way readWay() throws XMLStreamException {
        long id = Long.parseLong(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_ID));
        Info info = this.readInfo();
        HashMap<String, Object> tags = new HashMap<String, Object>();
        ArrayList<Long> members = new ArrayList<Long>();
        this.reader.nextTag();
        block8: while (this.reader.getEventType() == 1) {
            switch (this.reader.getLocalName()) {
                case "tag": {
                    this.readTag(tags);
                    continue block8;
                }
                case "nd": {
                    this.readWayMember(members);
                    continue block8;
                }
            }
            this.readUnknownElement();
        }
        return new Way((Long)id, info, tags, members);
    }

    private void readWayMember(List<Long> members) throws XMLStreamException {
        Long member = Long.parseLong(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_REF));
        members.add(member);
        this.reader.nextTag();
        this.reader.nextTag();
    }

    private Relation readRelation() throws XMLStreamException {
        long id = Long.parseLong(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_ID));
        Info info = this.readInfo();
        HashMap<String, Object> tags = new HashMap<String, Object>();
        ArrayList<Member> members = new ArrayList<Member>();
        this.reader.nextTag();
        block8: while (this.reader.getEventType() == 1) {
            switch (this.reader.getLocalName()) {
                case "tag": {
                    this.readTag(tags);
                    continue block8;
                }
                case "member": {
                    this.readRelationMember(members);
                    continue block8;
                }
            }
            this.readUnknownElement();
        }
        return new Relation((Long)id, info, tags, members);
    }

    private void readRelationMember(List<Member> members) throws XMLStreamException {
        long id = Long.parseLong(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_REF));
        Member.MemberType type = Member.MemberType.valueOf(this.reader.getAttributeValue(null, ATTRIBUTE_NAME_TYPE).toUpperCase());
        String role = this.reader.getAttributeValue(null, ATTRIBUTE_NAME_ROLE);
        members.add(new Member(id, type, role));
        this.reader.nextTag();
        this.reader.nextTag();
    }

    private Info readInfo() {
        String versionValue = this.reader.getAttributeValue(null, ATTRIBUTE_NAME_VERSION);
        int version = versionValue != null ? Ints.tryParse((String)versionValue) : 0;
        String timestampValue = this.reader.getAttributeValue(null, ATTRIBUTE_NAME_TIMESTAMP);
        LocalDateTime timestamp = timestampValue != null ? LocalDateTime.parse(timestampValue, format) : null;
        String changesetValue = this.reader.getAttributeValue(null, ATTRIBUTE_NAME_CHANGESET_ID);
        long changeset = changesetValue != null ? Longs.tryParse((String)changesetValue) : -1L;
        String uidValue = this.reader.getAttributeValue(null, ATTRIBUTE_NAME_USER_ID);
        int uid = uidValue != null && Ints.tryParse((String)uidValue) != null ? Ints.tryParse((String)uidValue) : -1;
        return new Info(version, timestamp, changeset, uid);
    }

    private void readTag(Map<String, Object> tags) throws XMLStreamException {
        String name = this.reader.getAttributeValue(null, ATTRIBUTE_NAME_KEY);
        String value = this.reader.getAttributeValue(null, ATTRIBUTE_NAME_VALUE);
        tags.put(name, value);
        this.reader.nextTag();
        this.reader.nextTag();
    }

    private void readUnknownElement() throws XMLStreamException {
        int level = 0;
        do {
            if (this.reader.getEventType() == 1) {
                ++level;
            } else if (this.reader.getEventType() == 2) {
                --level;
            }
            this.reader.next();
        } while (level > 0);
    }

    @Override
    public Spliterator<Entity> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return 4368;
    }
}

