/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.postgres.copy;

import de.bytefish.pgbulkinsert.pgsql.handlers.BaseValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.BooleanValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.ByteArrayValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.ByteValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.CollectionValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.DoubleValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.FloatValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.HstoreValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.IValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.Inet4AddressValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.Inet6AddressValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.IntegerValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.JsonbValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LocalDateTimeValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LocalDateValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LongValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.ShortValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.StringValueHandler;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.baremaps.postgres.copy.GeometryValueHandler;
import org.locationtech.jts.geom.Geometry;
import org.postgresql.copy.PGCopyOutputStream;

public class CopyWriter
implements AutoCloseable {
    public static final StringValueHandler STRING_HANDLER = new StringValueHandler();
    public static final CollectionValueHandler<String, Collection<String>> STRING_COLLECTION_HANDLER = new CollectionValueHandler(25, (IValueHandler)new StringValueHandler());
    public static final BooleanValueHandler BOOLEAN_HANDLER = new BooleanValueHandler();
    public static final CollectionValueHandler<Boolean, Collection<Boolean>> BOOLEAN_COLLECTION_HANDLER = new CollectionValueHandler(16, (IValueHandler)new BooleanValueHandler());
    public static final ByteValueHandler<Number> BYTE_HANDLER = new ByteValueHandler();
    public static final ByteArrayValueHandler BYTE_ARRAY_HANDLER = new ByteArrayValueHandler();
    public static final ShortValueHandler<Number> SHORT_HANDLER = new ShortValueHandler();
    public static final CollectionValueHandler<Short, Collection<Short>> SHORT_COLLECTION_HANDLER = new CollectionValueHandler(21, (IValueHandler)new ShortValueHandler());
    public static final IntegerValueHandler<Number> INTEGER_HANDLER = new IntegerValueHandler();
    public static final CollectionValueHandler<Integer, Collection<Integer>> INTEGER_COLLECTION_HANDLER = new CollectionValueHandler(23, (IValueHandler)new IntegerValueHandler());
    public static final LongValueHandler<Number> LONG_HANDLER = new LongValueHandler();
    public static final CollectionValueHandler<Long, Collection<Long>> LONG_COLLECTION_HANDLER = new CollectionValueHandler(20, (IValueHandler)new LongValueHandler());
    public static final FloatValueHandler<Number> FLOAT_HANDLER = new FloatValueHandler();
    public static final CollectionValueHandler<Float, Collection<Float>> FLOAT_COLLECTION_HANDLER = new CollectionValueHandler(700, (IValueHandler)new FloatValueHandler());
    public static final DoubleValueHandler<Number> DOUBLE_HANDLER = new DoubleValueHandler();
    public static final CollectionValueHandler<Double, Collection<Double>> DOUBLE_COLLECTION_HANDLER = new CollectionValueHandler(701, (IValueHandler)new DoubleValueHandler());
    public static final LocalDateValueHandler LOCAL_DATE_HANDLER = new LocalDateValueHandler();
    public static final LocalDateTimeValueHandler LOCAL_DATE_TIME_HANDLER = new LocalDateTimeValueHandler();
    public static final Inet4AddressValueHandler INET_4_ADDRESS_HANDLER = new Inet4AddressValueHandler();
    public static final Inet6AddressValueHandler INET_6_ADDRESS_HANDLER = new Inet6AddressValueHandler();
    public static final HstoreValueHandler HSTORE_HANDLER = new HstoreValueHandler();
    public static final JsonbValueHandler JSONB_HANDLER = new JsonbValueHandler();
    public static final GeometryValueHandler GEOMETRY_HANDLER = new GeometryValueHandler();
    private final DataOutputStream data;

    public CopyWriter(PGCopyOutputStream data) {
        this.data = new DataOutputStream(new BufferedOutputStream((OutputStream)data, 65536));
    }

    public void writeHeader() throws IOException {
        this.data.writeBytes("PGCOPY\n\u00ff\r\n\u0000");
        this.data.writeInt(0);
        this.data.writeInt(0);
    }

    public void writeNull() throws IOException {
        this.data.writeInt(-1);
    }

    public <T> void write(BaseValueHandler<T> handler, T value) throws IOException {
        handler.handle(this.data, value);
    }

    public void startRow(int columns) throws IOException {
        this.data.writeShort(columns);
    }

    public void write(String value) throws IOException {
        STRING_HANDLER.handle(this.data, (Object)value);
    }

    public void write(List<String> value) throws IOException {
        STRING_COLLECTION_HANDLER.handle(this.data, value);
    }

    public void writeBoolean(Boolean value) throws IOException {
        BOOLEAN_HANDLER.handle(this.data, (Object)value);
    }

    public void writeBooleanList(List<Boolean> value) throws IOException {
        BOOLEAN_COLLECTION_HANDLER.handle(this.data, value);
    }

    public void writeByte(Byte value) throws IOException {
        BYTE_HANDLER.handle(this.data, (Object)value);
    }

    public void writeByteArray(byte[] value) throws IOException {
        BYTE_ARRAY_HANDLER.handle(this.data, (Object)value);
    }

    public void writeShort(Short value) throws IOException {
        SHORT_HANDLER.handle(this.data, (Object)value);
    }

    public void writeShortList(List<Short> value) throws IOException {
        SHORT_COLLECTION_HANDLER.handle(this.data, value);
    }

    public void writeInteger(Integer value) throws IOException {
        INTEGER_HANDLER.handle(this.data, (Object)value);
    }

    public void writeIntegerList(List<Integer> value) throws IOException {
        INTEGER_COLLECTION_HANDLER.handle(this.data, value);
    }

    public void writeLong(Long value) throws IOException {
        LONG_HANDLER.handle(this.data, (Object)value);
    }

    public void writeLongList(List<Long> value) throws IOException {
        LONG_COLLECTION_HANDLER.handle(this.data, value);
    }

    public void writeFloat(Float value) throws IOException {
        FLOAT_HANDLER.handle(this.data, (Object)value);
    }

    public void writeFloatList(List<Float> value) throws IOException {
        FLOAT_COLLECTION_HANDLER.handle(this.data, value);
    }

    public void writeDouble(Double value) throws IOException {
        DOUBLE_HANDLER.handle(this.data, (Object)value);
    }

    public void writeDoubleArray(List<Double> value) throws IOException {
        DOUBLE_COLLECTION_HANDLER.handle(this.data, value);
    }

    public void writeLocalDate(LocalDate value) throws IOException {
        LOCAL_DATE_HANDLER.handle(this.data, (Object)value);
    }

    public void writeLocalDateTime(LocalDateTime value) throws IOException {
        LOCAL_DATE_TIME_HANDLER.handle(this.data, (Object)value);
    }

    public void writeInet4Adress(Inet4Address value) throws IOException {
        INET_4_ADDRESS_HANDLER.handle(this.data, (Object)value);
    }

    public void writeInet6Adress(Inet6Address value) throws IOException {
        INET_6_ADDRESS_HANDLER.handle(this.data, (Object)value);
    }

    public void writeHstore(Map<String, String> value) throws IOException {
        HSTORE_HANDLER.handle(this.data, value);
    }

    public void writeJsonb(String value) throws IOException {
        JSONB_HANDLER.handle(this.data, (Object)value);
    }

    public void writeGeometry(Geometry value) throws IOException {
        GEOMETRY_HANDLER.handle(this.data, value);
    }

    @Override
    public void close() throws IOException {
        this.data.writeShort(-1);
        this.data.flush();
        this.data.close();
    }
}

