/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.storage.flatgeobuf;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.apache.baremaps.database.schema.DataSchema;
import org.apache.baremaps.database.schema.DataTable;
import org.apache.baremaps.database.schema.DataTableException;
import org.apache.baremaps.storage.flatgeobuf.FlatGeoBufDataTable;

public class FlatGeoBufDataSchema
implements DataSchema {
    private final Path directory;

    public FlatGeoBufDataSchema(Path directory) {
        this.directory = directory;
    }

    @Override
    public Collection<String> list() throws DataTableException {
        List<String> list;
        block8: {
            Stream<Path> files = Files.list(this.directory);
            try {
                list = files.filter(file -> file.toString().toLowerCase().endsWith(".fgb")).map(file -> file.getFileName().toString()).toList();
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DataTableException(e);
                }
            }
            files.close();
        }
        return list;
    }

    @Override
    public DataTable get(String name) throws DataTableException {
        Path path = this.directory.resolve(name);
        return new FlatGeoBufDataTable(path);
    }

    @Override
    public void add(DataTable table) throws DataTableException {
        Object filename = table.rowType().name();
        filename = ((String)filename).endsWith(".fgb") ? filename : (String)filename + ".fgb";
        Path path = this.directory.resolve((String)filename);
        try {
            Files.deleteIfExists(path);
            Files.createFile(path, new FileAttribute[0]);
            FlatGeoBufDataTable flatGeoBufTable = new FlatGeoBufDataTable(path, table.rowType());
            flatGeoBufTable.write(table);
        }
        catch (IOException e) {
            throw new DataTableException(e);
        }
    }

    @Override
    public void remove(String name) throws DataTableException {
        Path path = this.directory.resolve(name);
        if (name.equals(path.getFileName().toString())) {
            try {
                Files.delete(path);
            }
            catch (IOException e) {
                throw new DataTableException(e);
            }
        } else {
            throw new DataTableException("Table not found");
        }
    }
}

