/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tilestore.pmtiles;

import java.util.Objects;
import org.apache.baremaps.tilestore.pmtiles.Compression;
import org.apache.baremaps.tilestore.pmtiles.TileType;

class Header {
    private int specVersion;
    private long rootDirectoryOffset;
    private long rootDirectoryLength;
    private long jsonMetadataOffset;
    private long jsonMetadataLength;
    private long leafDirectoryOffset;
    private long leafDirectoryLength;
    private long tileDataOffset;
    private long tileDataLength;
    private long numAddressedTiles;
    private long numTileEntries;
    private long numTileContents;
    private boolean clustered;
    private Compression internalCompression;
    private Compression tileCompression;
    private TileType tileType;
    private int minZoom;
    private int maxZoom;
    private double minLon;
    private double minLat;
    private double maxLon;
    private double maxLat;
    private int centerZoom;
    private double centerLon;
    private double centerLat;

    public Header() {
        this.specVersion = 3;
    }

    public Header(int specVersion, long rootDirectoryOffset, long rootDirectoryLength, long jsonMetadataOffset, long jsonMetadataLength, long leafDirectoryOffset, long leafDirectoryLength, long tileDataOffset, long tileDataLength, long numAddressedTiles, long numTileEntries, long numTileContents, boolean clustered, Compression internalCompression, Compression tileCompression, TileType tileType, int minZoom, int maxZoom, double minLon, double minLat, double maxLon, double maxLat, int centerZoom, double centerLon, double centerLat) {
        this.specVersion = specVersion;
        this.rootDirectoryOffset = rootDirectoryOffset;
        this.rootDirectoryLength = rootDirectoryLength;
        this.jsonMetadataOffset = jsonMetadataOffset;
        this.jsonMetadataLength = jsonMetadataLength;
        this.leafDirectoryOffset = leafDirectoryOffset;
        this.leafDirectoryLength = leafDirectoryLength;
        this.tileDataOffset = tileDataOffset;
        this.tileDataLength = tileDataLength;
        this.numAddressedTiles = numAddressedTiles;
        this.numTileEntries = numTileEntries;
        this.numTileContents = numTileContents;
        this.clustered = clustered;
        this.internalCompression = internalCompression;
        this.tileCompression = tileCompression;
        this.tileType = tileType;
        this.minZoom = minZoom;
        this.maxZoom = maxZoom;
        this.minLon = minLon;
        this.minLat = minLat;
        this.maxLon = maxLon;
        this.maxLat = maxLat;
        this.centerZoom = centerZoom;
        this.centerLon = centerLon;
        this.centerLat = centerLat;
    }

    public int getSpecVersion() {
        return this.specVersion;
    }

    public void setSpecVersion(int specVersion) {
        this.specVersion = specVersion;
    }

    public long getRootDirectoryOffset() {
        return this.rootDirectoryOffset;
    }

    public void setRootOffset(long rootDirectoryOffset) {
        this.rootDirectoryOffset = rootDirectoryOffset;
    }

    public long getRootDirectoryLength() {
        return this.rootDirectoryLength;
    }

    public void setRootLength(long rootDirectoryLength) {
        this.rootDirectoryLength = rootDirectoryLength;
    }

    public long getJsonMetadataOffset() {
        return this.jsonMetadataOffset;
    }

    public void setMetadataOffset(long jsonMetadataOffset) {
        this.jsonMetadataOffset = jsonMetadataOffset;
    }

    public long getJsonMetadataLength() {
        return this.jsonMetadataLength;
    }

    public void setMetadataLength(long jsonMetadataLength) {
        this.jsonMetadataLength = jsonMetadataLength;
    }

    public long getLeafDirectoryOffset() {
        return this.leafDirectoryOffset;
    }

    public void setLeavesOffset(long leafDirectoryOffset) {
        this.leafDirectoryOffset = leafDirectoryOffset;
    }

    public long getLeafDirectoryLength() {
        return this.leafDirectoryLength;
    }

    public void setLeavesLength(long leafDirectoryLength) {
        this.leafDirectoryLength = leafDirectoryLength;
    }

    public long getTileDataOffset() {
        return this.tileDataOffset;
    }

    public void setTilesOffset(long tileDataOffset) {
        this.tileDataOffset = tileDataOffset;
    }

    public long getTileDataLength() {
        return this.tileDataLength;
    }

    public void setTilesLength(long tileDataLength) {
        this.tileDataLength = tileDataLength;
    }

    public long getNumAddressedTiles() {
        return this.numAddressedTiles;
    }

    public void setNumAddressedTiles(long numAddressedTiles) {
        this.numAddressedTiles = numAddressedTiles;
    }

    public long getNumTileEntries() {
        return this.numTileEntries;
    }

    public void setNumTileEntries(long numTileEntries) {
        this.numTileEntries = numTileEntries;
    }

    public long getNumTileContents() {
        return this.numTileContents;
    }

    public void setNumTileContents(long numTileContents) {
        this.numTileContents = numTileContents;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public void setClustered(boolean clustered) {
        this.clustered = clustered;
    }

    public Compression getInternalCompression() {
        return this.internalCompression;
    }

    public void setInternalCompression(Compression internalCompression) {
        this.internalCompression = internalCompression;
    }

    public Compression getTileCompression() {
        return this.tileCompression;
    }

    public void setTileCompression(Compression tileCompression) {
        this.tileCompression = tileCompression;
    }

    public TileType getTileType() {
        return this.tileType;
    }

    public void setTileType(TileType tileType) {
        this.tileType = tileType;
    }

    public int getMinZoom() {
        return this.minZoom;
    }

    public void setMinZoom(int minZoom) {
        this.minZoom = minZoom;
    }

    public int getMaxZoom() {
        return this.maxZoom;
    }

    public void setMaxZoom(int maxZoom) {
        this.maxZoom = maxZoom;
    }

    public double getMinLon() {
        return this.minLon;
    }

    public void setMinLon(double minLon) {
        this.minLon = minLon;
    }

    public double getMinLat() {
        return this.minLat;
    }

    public void setMinLat(double minLat) {
        this.minLat = minLat;
    }

    public double getMaxLon() {
        return this.maxLon;
    }

    public void setMaxLon(double maxLon) {
        this.maxLon = maxLon;
    }

    public double getMaxLat() {
        return this.maxLat;
    }

    public void setMaxLat(double maxLat) {
        this.maxLat = maxLat;
    }

    public int getCenterZoom() {
        return this.centerZoom;
    }

    public void setCenterZoom(int centerZoom) {
        this.centerZoom = centerZoom;
    }

    public double getCenterLon() {
        return this.centerLon;
    }

    public void setCenterLon(double centerLon) {
        this.centerLon = centerLon;
    }

    public double getCenterLat() {
        return this.centerLat;
    }

    public void setCenterLat(double centerLat) {
        this.centerLat = centerLat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Header header = (Header)o;
        return this.specVersion == header.specVersion && this.rootDirectoryOffset == header.rootDirectoryOffset && this.rootDirectoryLength == header.rootDirectoryLength && this.jsonMetadataOffset == header.jsonMetadataOffset && this.jsonMetadataLength == header.jsonMetadataLength && this.leafDirectoryOffset == header.leafDirectoryOffset && this.leafDirectoryLength == header.leafDirectoryLength && this.tileDataOffset == header.tileDataOffset && this.tileDataLength == header.tileDataLength && this.numAddressedTiles == header.numAddressedTiles && this.numTileEntries == header.numTileEntries && this.numTileContents == header.numTileContents && this.clustered == header.clustered && this.minZoom == header.minZoom && this.maxZoom == header.maxZoom && Double.compare(header.minLon, this.minLon) == 0 && Double.compare(header.minLat, this.minLat) == 0 && Double.compare(header.maxLon, this.maxLon) == 0 && Double.compare(header.maxLat, this.maxLat) == 0 && this.centerZoom == header.centerZoom && Double.compare(header.centerLon, this.centerLon) == 0 && Double.compare(header.centerLat, this.centerLat) == 0 && this.internalCompression == header.internalCompression && this.tileCompression == header.tileCompression && this.tileType == header.tileType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.specVersion, this.rootDirectoryOffset, this.rootDirectoryLength, this.jsonMetadataOffset, this.jsonMetadataLength, this.leafDirectoryOffset, this.leafDirectoryLength, this.tileDataOffset, this.tileDataLength, this.numAddressedTiles, this.numTileEntries, this.numTileContents, this.clustered, this.internalCompression, this.tileCompression, this.tileType, this.minZoom, this.maxZoom, this.minLon, this.minLat, this.maxLon, this.maxLat, this.centerZoom, this.centerLon, this.centerLat});
    }
}

