/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert;

import de.bytefish.pgbulkinsert.IPgBulkInsert;
import de.bytefish.pgbulkinsert.configuration.Configuration;
import de.bytefish.pgbulkinsert.configuration.IConfiguration;
import de.bytefish.pgbulkinsert.exceptions.SaveEntityFailedException;
import de.bytefish.pgbulkinsert.mapping.AbstractMapping;
import de.bytefish.pgbulkinsert.pgsql.PgBinaryWriter;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import org.postgresql.PGConnection;
import org.postgresql.copy.PGCopyOutputStream;

public class PgBulkInsert<TEntity>
implements IPgBulkInsert<TEntity> {
    private final IConfiguration configuration;
    private final AbstractMapping<TEntity> mapping;

    public PgBulkInsert(AbstractMapping<TEntity> mapping) {
        this(new Configuration(), mapping);
    }

    public PgBulkInsert(IConfiguration configuration, AbstractMapping<TEntity> mapping) {
        Objects.requireNonNull(configuration, "'configuration' has to be set");
        Objects.requireNonNull(mapping, "'mapping' has to be set");
        this.configuration = configuration;
        this.mapping = mapping;
    }

    @Override
    public void saveAll(PGConnection connection, Stream<TEntity> entities) throws SQLException {
        try (PgBinaryWriter bw = new PgBinaryWriter((OutputStream)new PGCopyOutputStream(connection, this.mapping.getCopyCommand(), 1), this.configuration.getBufferSize());){
            entities.forEach(entity -> this.saveEntitySynchonized(bw, entity));
        }
    }

    @Override
    public void saveAll(PGConnection connection, Collection<TEntity> entities) throws SQLException {
        this.saveAll(connection, entities.stream());
    }

    private void saveEntity(PgBinaryWriter bw, TEntity entity) throws SaveEntityFailedException {
        bw.startRow(this.mapping.getColumns().size());
        try {
            this.mapping.getColumns().forEach(column -> column.getWrite().accept(bw, entity));
        }
        catch (Exception e) {
            throw new SaveEntityFailedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveEntitySynchonized(PgBinaryWriter bw, TEntity entity) throws SaveEntityFailedException {
        PgBinaryWriter pgBinaryWriter = bw;
        synchronized (pgBinaryWriter) {
            this.saveEntity(bw, entity);
        }
    }
}

