/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.pgsql.handlers;

import de.bytefish.pgbulkinsert.pgsql.handlers.BaseValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.IValueHandler;
import de.bytefish.pgbulkinsert.pgsql.model.range.Range;
import java.io.DataOutputStream;

public class RangeValueHandler<TElementType>
extends BaseValueHandler<Range<TElementType>> {
    private final IValueHandler<TElementType> valueHandler;

    public RangeValueHandler(IValueHandler<TElementType> valueHandler) {
        this.valueHandler = valueHandler;
    }

    @Override
    protected void internalHandle(DataOutputStream buffer, Range<TElementType> value) throws Exception {
        buffer.writeInt(this.getLength(value));
        buffer.writeByte(value.getFlags());
        if (value.isEmpty()) {
            return;
        }
        if (!value.isLowerBoundInfinite()) {
            this.valueHandler.handle(buffer, value.getLowerBound());
        }
        if (!value.isUpperBoundInfinite()) {
            this.valueHandler.handle(buffer, value.getUpperBound());
        }
    }

    @Override
    public int getLength(Range<TElementType> value) {
        int totalLen = 1;
        if (!value.isEmpty()) {
            if (!value.isLowerBoundInfinite()) {
                totalLen += 4 + this.valueHandler.getLength(value.getLowerBound());
            }
            if (!value.isUpperBoundInfinite()) {
                totalLen += 4 + this.valueHandler.getLength(value.getUpperBound());
            }
        }
        return totalLen;
    }
}

