/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.util.sweep;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import mil.nga.sf.LineString;
import mil.nga.sf.Point;
import mil.nga.sf.util.sweep.Event;
import mil.nga.sf.util.sweep.Segment;

public class SweepLine {
    private List<LineString> rings;
    private SegmentComparator comparator = new SegmentComparator();
    private TreeSet<Segment> tree = new TreeSet<Segment>(this.comparator);
    private Map<Integer, Map<Integer, Segment>> segments = new HashMap<Integer, Map<Integer, Segment>>();

    public SweepLine(List<LineString> rings) {
        this.rings = rings;
    }

    public Segment add(Event event) {
        Map<Integer, Segment> edgeMap;
        Segment segment = this.createSegment(event);
        this.tree.add(segment);
        Segment next = this.tree.higher(segment);
        Segment previous = this.tree.lower(segment);
        if (next != null) {
            segment.setAbove(next);
            next.setBelow(segment);
        }
        if (previous != null) {
            segment.setBelow(previous);
            previous.setAbove(segment);
        }
        if ((edgeMap = this.segments.get(segment.getRing())) == null) {
            edgeMap = new HashMap<Integer, Segment>();
            this.segments.put(segment.getRing(), edgeMap);
        }
        edgeMap.put(segment.getEdge(), segment);
        return segment;
    }

    private Segment createSegment(Event event) {
        int edgeNumber = event.getEdge();
        int ringNumber = event.getRing();
        LineString ring = this.rings.get(ringNumber);
        List<Point> points = ring.getPoints();
        Point point1 = points.get(edgeNumber);
        Point point2 = points.get((edgeNumber + 1) % points.size());
        Point left = null;
        Point right = null;
        if (SweepLine.xyOrder(point1, point2) < 0) {
            left = point1;
            right = point2;
        } else {
            right = point1;
            left = point2;
        }
        Segment segment = new Segment(edgeNumber, ringNumber, left, right);
        return segment;
    }

    public Segment find(Event event) {
        return this.segments.get(event.getRing()).get(event.getEdge());
    }

    public boolean intersect(Segment segment1, Segment segment2) {
        boolean intersect = false;
        if (segment1 != null && segment2 != null) {
            double right;
            double left;
            int ring2;
            boolean consecutive;
            int ring1 = segment1.getRing();
            boolean bl = consecutive = ring1 == (ring2 = segment2.getRing());
            if (consecutive) {
                int edge1 = segment1.getEdge();
                int edge2 = segment2.getEdge();
                int ringPoints = this.rings.get(ring1).numPoints();
                boolean bl2 = consecutive = (edge1 + 1) % ringPoints == edge2 || edge1 == (edge2 + 1) % ringPoints;
            }
            if (!consecutive && (left = SweepLine.isLeft(segment1, segment2.getLeftPoint())) * (right = SweepLine.isLeft(segment1, segment2.getRightPoint())) <= 0.0 && (left = SweepLine.isLeft(segment2, segment1.getLeftPoint())) * (right = SweepLine.isLeft(segment2, segment1.getRightPoint())) <= 0.0) {
                intersect = true;
            }
        }
        return intersect;
    }

    public void remove(Segment segment) {
        boolean removed = this.tree.remove(segment);
        if (!removed) {
            removed = this.tree.remove(segment);
        }
        if (removed) {
            Segment above = segment.getAbove();
            Segment below = segment.getBelow();
            if (above != null) {
                above.setBelow(below);
            }
            if (below != null) {
                below.setAbove(above);
            }
            this.segments.get(segment.getRing()).remove(segment.getEdge());
        }
    }

    public static int xyOrder(Point point1, Point point2) {
        int value = 0;
        if (point1.getX() > point2.getX()) {
            value = 1;
        } else if (point1.getX() < point2.getX()) {
            value = -1;
        } else if (point1.getY() > point2.getY()) {
            value = 1;
        } else if (point1.getY() < point2.getY()) {
            value = -1;
        }
        return value;
    }

    private static double isLeft(Segment segment, Point point) {
        return SweepLine.isLeft(segment.getLeftPoint(), segment.getRightPoint(), point);
    }

    private static double isLeft(Point point0, Point point1, Point point2) {
        return (point1.getX() - point0.getX()) * (point2.getY() - point0.getY()) - (point2.getX() - point0.getX()) * (point1.getY() - point0.getY());
    }

    private class SegmentComparator
    implements Comparator<Segment> {
        private SegmentComparator() {
        }

        @Override
        public int compare(Segment segment1, Segment segment2) {
            int compare = 0;
            if (segment1 != segment2) {
                double s;
                Point lp1 = segment1.getLeftPoint();
                Point rp1 = segment1.getRightPoint();
                Point lp2 = segment2.getLeftPoint();
                Point rp2 = segment2.getRightPoint();
                compare = lp1.getX() <= lp2.getX() ? ((s = SweepLine.isLeft(segment1, lp2)) != 0.0 ? this.comparison(s > 0.0) : (lp1.equalsX(rp1) ? this.comparison(lp1.getY() < lp2.getY()) : this.comparison(SweepLine.isLeft(segment1, rp2) > 0.0))) : ((s = SweepLine.isLeft(segment2, lp1)) != 0.0 ? this.comparison(s < 0.0) : this.comparison(SweepLine.isLeft(segment2, rp1) < 0.0));
            }
            return compare;
        }

        private int comparison(boolean left) {
            return left ? -1 : 1;
        }
    }
}

