/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.gravitino.dto.VersionDTO;
import org.apache.gravitino.exceptions.GravitinoRuntimeException;
import org.apache.gravitino.shaded.com.google.common.annotations.VisibleForTesting;

public class GravitinoVersion
extends VersionDTO
implements Comparable {
    private static final int VERSION_PART_NUMBER = 3;

    @VisibleForTesting
    GravitinoVersion(String version, String compileDate, String gitCommit) {
        super(version, compileDate, gitCommit);
    }

    GravitinoVersion(VersionDTO versionDTO) {
        super(versionDTO.version(), versionDTO.compileDate(), versionDTO.gitCommit());
    }

    @VisibleForTesting
    int[] getVersionNumber() {
        Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)([-\\w]+)?");
        Matcher matcher = pattern.matcher(this.version());
        if (matcher.matches()) {
            int[] versionNumbers = new int[3];
            for (int i = 0; i < 3; ++i) {
                versionNumbers[i] = Integer.parseInt(matcher.group(i + 1));
            }
            return versionNumbers;
        }
        throw new GravitinoRuntimeException("Invalid version string " + this.version());
    }

    public int compareTo(Object o) {
        if (!(o instanceof GravitinoVersion)) {
            return 1;
        }
        GravitinoVersion other = (GravitinoVersion)o;
        int[] left = this.getVersionNumber();
        int[] right = other.getVersionNumber();
        for (int i = 0; i < 3; ++i) {
            int v = left[i] - right[i];
            if (v == 0) continue;
            return v;
        }
        return 0;
    }
}

