/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service.provider;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.catalog.lakehouse.iceberg.IcebergPropertiesUtils;
import org.apache.gravitino.client.GravitinoAdminClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.iceberg.common.IcebergConfig;
import org.apache.gravitino.iceberg.service.provider.IcebergConfigProvider;

public class DynamicIcebergConfigProvider
implements IcebergConfigProvider {
    private String gravitinoMetalake;
    private GravitinoAdminClient client;

    @Override
    public void initialize(Map<String, String> properties) {
        String uri = properties.get("gravitino-uri");
        String metalake = properties.get("gravitino-metalake");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)uri), (Object)"gravitino-uri is blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)metalake), (Object)"gravitino-metalake is blank");
        this.gravitinoMetalake = metalake;
        this.client = GravitinoAdminClient.builder((String)uri).build();
    }

    @Override
    public Optional<IcebergConfig> getIcebergCatalogConfig(String catalogName) {
        Catalog catalog;
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)catalogName), (Object)"blank catalogName is illegal");
        Preconditions.checkArgument((!"default_catalog".equals(catalogName) ? 1 : 0) != 0, (Object)"default_catalog is illegal in gravitino-based-provider");
        try {
            catalog = this.client.loadMetalake(this.gravitinoMetalake).loadCatalog(catalogName);
        }
        catch (NoSuchCatalogException e) {
            return Optional.empty();
        }
        Preconditions.checkArgument((boolean)"lakehouse-iceberg".equals(catalog.provider()), (Object)String.format("%s.%s is not iceberg catalog", this.gravitinoMetalake, catalogName));
        Map properties = IcebergPropertiesUtils.toIcebergCatalogProperties((Map)catalog.properties());
        return Optional.of(new IcebergConfig(properties));
    }

    @VisibleForTesting
    void setClient(GravitinoAdminClient client) {
        this.client = client;
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    @Override
    public String getMetalakeName() {
        return this.gravitinoMetalake;
    }
}

