/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.meta;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.gravitino.Auditable;
import org.apache.gravitino.Entity;
import org.apache.gravitino.Field;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.authorization.Role;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.utils.CollectionUtils;

public class RoleEntity
implements Role,
Entity,
Auditable,
HasIdentifier {
    public static final Field ID = Field.required("id", Long.class, " The unique id of the role entity.");
    public static final Field NAME = Field.required("name", String.class, "The name of the role entity.");
    public static final Field PROPERTIES = Field.optional("properties", Map.class, "The properties of the role entity.");
    public static final Field AUDIT_INFO = Field.required("audit_info", AuditInfo.class, "The audit details of the role entity.");
    public static final Field SECURABLE_OBJECTS = Field.optional("securable_objects", List.class, "The securable objects of the role entity.");
    private Long id;
    private String name;
    private Map<String, String> properties;
    private AuditInfo auditInfo;
    private Namespace namespace;
    private List<SecurableObject> securableObjects;

    @Override
    public String name() {
        return this.name;
    }

    public AuditInfo auditInfo() {
        return this.auditInfo;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public List<SecurableObject> securableObjects() {
        return this.securableObjects;
    }

    @Override
    public Map<Field, Object> fields() {
        HashMap fields = Maps.newHashMap();
        fields.put(ID, this.id);
        fields.put(NAME, this.name);
        fields.put(AUDIT_INFO, this.auditInfo);
        fields.put(PROPERTIES, this.properties);
        fields.put(SECURABLE_OBJECTS, this.securableObjects);
        return Collections.unmodifiableMap(fields);
    }

    @Override
    public Entity.EntityType type() {
        return Entity.EntityType.ROLE;
    }

    @Override
    public Long id() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RoleEntity)) {
            return false;
        }
        RoleEntity that = (RoleEntity)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.auditInfo, that.auditInfo) && Objects.equals(this.properties, that.properties) && CollectionUtils.isEqualCollection(this.securableObjects, that.securableObjects);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.properties, this.auditInfo, this.securableObjects, this.namespace);
    }

    @Override
    public Namespace namespace() {
        return this.namespace;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final RoleEntity roleEntity = new RoleEntity();

        private Builder() {
        }

        public Builder withId(Long id) {
            this.roleEntity.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.roleEntity.name = name;
            return this;
        }

        public Builder withProperties(Map<String, String> properties) {
            this.roleEntity.properties = properties;
            return this;
        }

        public Builder withAuditInfo(AuditInfo auditInfo) {
            this.roleEntity.auditInfo = auditInfo;
            return this;
        }

        public Builder withSecurableObjects(List<SecurableObject> securableObjects) {
            this.roleEntity.securableObjects = (List)ImmutableList.copyOf(securableObjects);
            return this;
        }

        public Builder withNamespace(Namespace namespace) {
            this.roleEntity.namespace = namespace;
            return this;
        }

        public RoleEntity build() {
            this.roleEntity.validate();
            return this.roleEntity;
        }
    }
}

