/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.iceberg.BaseMetastoreOperations;
import org.apache.iceberg.ClientPool;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.exceptions.NoSuchIcebergTableException;
import org.apache.iceberg.hive.HiveLock;
import org.apache.iceberg.hive.HiveSchemaUtil;
import org.apache.iceberg.hive.MetastoreUtil;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

interface HiveOperationsBase {
    public static final Logger LOG = LoggerFactory.getLogger(HiveOperationsBase.class);
    public static final String HIVE_TABLE_PROPERTY_MAX_SIZE = "iceberg.hive.table-property-max-size";
    public static final long HIVE_TABLE_PROPERTY_MAX_SIZE_DEFAULT = 32672L;
    public static final String NO_LOCK_EXPECTED_KEY = "expected_parameter_key";
    public static final String NO_LOCK_EXPECTED_VALUE = "expected_parameter_value";

    public TableType tableType();

    public ClientPool<IMetaStoreClient, TException> metaClients();

    public long maxHiveTablePropertySize();

    public String database();

    public String table();

    default public Table loadHmsTable() throws TException, InterruptedException {
        try {
            return (Table)this.metaClients().run(client -> client.getTable(this.database(), this.table()));
        }
        catch (NoSuchObjectException nte) {
            LOG.trace("Table not found {}", (Object)(this.database() + "." + this.table()), (Object)nte);
            return null;
        }
    }

    default public Map<String, String> hmsEnvContext(String metadataLocation) {
        return metadataLocation == null ? ImmutableMap.of() : ImmutableMap.of((Object)NO_LOCK_EXPECTED_KEY, (Object)"metadata_location", (Object)NO_LOCK_EXPECTED_VALUE, (Object)metadataLocation);
    }

    default public boolean exposeInHmsProperties() {
        return this.maxHiveTablePropertySize() > 0L;
    }

    default public void setSchema(Schema schema, Map<String, String> parameters) {
        parameters.remove("current-schema");
        if (this.exposeInHmsProperties() && schema != null) {
            String jsonSchema = SchemaParser.toJson((Schema)schema);
            this.setField(parameters, "current-schema", jsonSchema);
        }
    }

    default public void setField(Map<String, String> parameters, String key, String value) {
        if ((long)value.length() <= this.maxHiveTablePropertySize()) {
            parameters.put(key, value);
        } else {
            LOG.warn("Not exposing {} in HMS since it exceeds {} characters", (Object)key, (Object)this.maxHiveTablePropertySize());
        }
    }

    public static void validateTableIsIceberg(Table table, String fullName) {
        String tableType = (String)table.getParameters().get("table_type");
        NoSuchIcebergTableException.check((tableType != null && tableType.equalsIgnoreCase("iceberg") ? 1 : 0) != 0, (String)"Not an iceberg table: %s (type=%s)", (Object[])new Object[]{fullName, tableType});
    }

    default public void persistTable(Table hmsTable, boolean updateHiveTable, String metadataLocation) throws TException, InterruptedException {
        if (updateHiveTable) {
            this.metaClients().run(client -> {
                MetastoreUtil.alterTable(client, this.database(), this.table(), hmsTable, this.hmsEnvContext(metadataLocation));
                return null;
            });
        } else {
            this.metaClients().run(client -> {
                client.createTable(hmsTable);
                return null;
            });
        }
    }

    @Deprecated
    public static StorageDescriptor storageDescriptor(TableMetadata metadata, boolean hiveEngineEnabled) {
        return HiveOperationsBase.storageDescriptor(metadata.schema(), metadata.location(), hiveEngineEnabled);
    }

    public static StorageDescriptor storageDescriptor(Schema schema, String location, boolean hiveEngineEnabled) {
        StorageDescriptor storageDescriptor = new StorageDescriptor();
        storageDescriptor.setCols(HiveSchemaUtil.convert(schema));
        storageDescriptor.setLocation(location);
        SerDeInfo serDeInfo = new SerDeInfo();
        serDeInfo.setParameters((Map)Maps.newHashMap());
        if (hiveEngineEnabled) {
            storageDescriptor.setInputFormat("org.apache.iceberg.mr.hive.HiveIcebergInputFormat");
            storageDescriptor.setOutputFormat("org.apache.iceberg.mr.hive.HiveIcebergOutputFormat");
            serDeInfo.setSerializationLib("org.apache.iceberg.mr.hive.HiveIcebergSerDe");
        } else {
            storageDescriptor.setOutputFormat("org.apache.hadoop.mapred.FileOutputFormat");
            storageDescriptor.setInputFormat("org.apache.hadoop.mapred.FileInputFormat");
            serDeInfo.setSerializationLib("org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe");
        }
        storageDescriptor.setSerdeInfo(serDeInfo);
        return storageDescriptor;
    }

    public static void cleanupMetadata(FileIO io, String commitStatus, String metadataLocation) {
        try {
            if (commitStatus.equalsIgnoreCase("FAILURE")) {
                io.deleteFile(metadataLocation);
            }
        }
        catch (RuntimeException e) {
            LOG.error("Failed to cleanup metadata file at {}", (Object)metadataLocation, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanupMetadataAndUnlock(FileIO io, BaseMetastoreOperations.CommitStatus commitStatus, String metadataLocation, HiveLock lock) {
        try {
            HiveOperationsBase.cleanupMetadata(io, commitStatus.name(), metadataLocation);
        }
        finally {
            lock.unlock();
        }
    }

    default public Table newHmsTable(String hmsTableOwner) {
        Preconditions.checkNotNull((Object)hmsTableOwner, (Object)"'hmsOwner' parameter can't be null");
        long currentTimeMillis = System.currentTimeMillis();
        Table newTable = new Table(this.table(), this.database(), hmsTableOwner, (int)currentTimeMillis / 1000, (int)currentTimeMillis / 1000, Integer.MAX_VALUE, null, Collections.emptyList(), (Map)Maps.newHashMap(), null, null, this.tableType().name());
        if (this.tableType().equals((Object)TableType.EXTERNAL_TABLE)) {
            newTable.getParameters().put("EXTERNAL", "TRUE");
        }
        return newTable;
    }

    public static enum ContentType {
        TABLE("Table"),
        VIEW("View");

        private final String value;

        private ContentType(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

