/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.processor;

import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.filter.log.ILogger;
import dm.jdbc.filter.log.LogFactory;
import dm.jdbc.processor.BaseThread;
import dm.jdbc.processor.DBAliveCheckThread$1;
import dm.jdbc.processor.DBAliveCheckThread$DBAliveCheckThreadHolder;
import dm.jdbc.util.CacheQueue;
import dm.jdbc.util.MiscUtil;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;

public class DBAliveCheckThread
extends BaseThread {
    private static ILogger log = LogFactory.getLog(DBAliveCheckThread.class);
    private CacheQueue connList = new DBAliveCheckThread$1(this, Integer.MAX_VALUE, false);

    private DBAliveCheckThread() {
        super("DB-ALIVE-CHECK-THREAD");
        this.start();
    }

    public static DBAliveCheckThread getInstance() {
        return DBAliveCheckThread$DBAliveCheckThreadHolder.access$0();
    }

    public static void addConnection(DmdbConnection dmdbConnection) {
        if (DmSvcConf.GLOBAL.dbAliveCheckFreq <= 0) {
            return;
        }
        DBAliveCheckThread.getInstance().connList.put(dmdbConnection);
    }

    @Override
    public void run() {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        while (true) {
            block7: {
                try {
                    hashMap.clear();
                    DmdbConnection dmdbConnection = null;
                    int n2 = this.connList.size();
                    int n3 = 0;
                    while (n3 < n2) {
                        block8: {
                            dmdbConnection = (DmdbConnection)this.connList.get();
                            if (dmdbConnection == null) break block7;
                            try {
                                String string = String.valueOf(dmdbConnection.host) + ":" + dmdbConnection.port;
                                Boolean bl = (Boolean)hashMap.get(string);
                                if (bl == null) {
                                    bl = this.checkDbAlive(dmdbConnection.host, dmdbConnection.port);
                                    hashMap.put(string, bl);
                                }
                                if (bl.booleanValue()) break block8;
                                dmdbConnection.abort(null);
                            }
                            catch (Exception exception) {}
                        }
                        this.connList.put(dmdbConnection);
                        ++n3;
                    }
                }
                catch (Exception exception) {}
            }
            MiscUtil.sleep(DmSvcConf.GLOBAL.dbAliveCheckFreq);
        }
    }

    private boolean checkDbAlive(String string, int n2) {
        boolean bl;
        block5: {
            bl = false;
            Socket socket = null;
            try {
                try {
                    socket = new Socket();
                    InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n2);
                    socket.connect(inetSocketAddress, DmSvcConf.GLOBAL.dbAliveCheckTimeout);
                    bl = true;
                }
                catch (Exception exception) {
                    log.warn("checkDbAlive failed: " + exception.getMessage());
                    MiscUtil.close(socket);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                MiscUtil.close(socket);
                throw throwable;
            }
            MiscUtil.close(socket);
        }
        return bl;
    }

    /* synthetic */ DBAliveCheckThread(DBAliveCheckThread dBAliveCheckThread) {
        this();
    }
}

