/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util;

import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.InsertionOrderUtil;

public final class CollectionUtil {
    public static <T> Set<T> toSet(Object object) {
        E.checkNotNull(object, "object");
        Set set = InsertionOrderUtil.newSet();
        CollectionUtil.fillCollection(set, object);
        return set;
    }

    public static <T> List<T> toList(Object object) {
        E.checkNotNull(object, "object");
        ArrayList list = new ArrayList();
        CollectionUtil.fillCollection(list, object);
        return list;
    }

    private static <T> void fillCollection(Collection<T> collection, Object object) {
        if (object.getClass().isArray()) {
            int length = Array.getLength(object);
            for (int i = 0; i < length; ++i) {
                collection.add(Array.get(object, i));
            }
        } else if (object instanceof Collection) {
            collection.addAll((Collection)object);
        } else {
            collection.add(object);
        }
    }

    public static <T> boolean prefixOf(List<T> prefix, List<T> all) {
        E.checkNotNull(prefix, "prefix");
        E.checkNotNull(all, "all");
        if (prefix.size() > all.size()) {
            return false;
        }
        for (int i = 0; i < prefix.size(); ++i) {
            T second;
            T first = prefix.get(i);
            if (first == (second = all.get(i)) || first != null && first.equals(second)) continue;
            return false;
        }
        return true;
    }

    public static Set<Integer> randomSet(int min, int max, int count) {
        E.checkArgument(max > min, "Invalid min/max: %s/%s", min, max);
        E.checkArgument(0 < count && count <= max - min, "Invalid count %s", count);
        HashSet<Integer> randoms = new HashSet<Integer>();
        while (randoms.size() < count) {
            randoms.add(ThreadLocalRandom.current().nextInt(min, max));
        }
        return randoms;
    }

    public static boolean allUnique(Collection<?> collection) {
        HashSet set = new HashSet(collection.size());
        for (Object elem : collection) {
            if (set.add(elem)) continue;
            return false;
        }
        return true;
    }

    public static <T> Set<T> subSet(Set<T> original, int from, int to) {
        E.checkArgument(from >= 0, "Invalid from parameter of subSet(): %s", from);
        if (to < 0) {
            to = original.size();
        } else {
            E.checkArgument(to >= from, "Invalid to parameter of subSet(): %s", to);
        }
        ArrayList<T> list = new ArrayList<T>(original);
        return new LinkedHashSet(list.subList(from, to));
    }

    public static <T> Set<T> union(Collection<T> first, Collection<T> second) {
        E.checkNotNull(first, "first");
        E.checkNotNull(second, "second");
        HashSet<T> results = new HashSet<T>(first);
        results.addAll(second);
        return results;
    }

    public static <T> Collection<T> intersect(Collection<T> first, Collection<T> second) {
        HashSet clone;
        E.checkNotNull(first, "first");
        E.checkNotNull(second, "second");
        HashSet results = first instanceof HashSet ? (clone = (HashSet)((HashSet)first).clone()) : new HashSet(first);
        results.retainAll(second);
        return results;
    }

    public static <T> Collection<T> intersectWithModify(Collection<T> first, Collection<T> second) {
        E.checkNotNull(first, "first");
        E.checkNotNull(second, "second");
        first.retainAll(second);
        return first;
    }

    public static <T> boolean hasIntersection(List<T> first, Set<T> second) {
        E.checkNotNull(first, "first");
        E.checkNotNull(second, "second");
        for (T firstElem : first) {
            if (!second.contains(firstElem)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean hasIntersection(Set<T> first, Set<T> second) {
        E.checkNotNull(first, "first");
        E.checkNotNull(second, "second");
        if (first.size() <= second.size()) {
            for (T firstElem : first) {
                if (!second.contains(firstElem)) continue;
                return true;
            }
        } else {
            for (T secondElem : second) {
                if (!first.contains(secondElem)) continue;
                return true;
            }
        }
        return false;
    }

    public static <K extends Comparable<? super K>, V> Map<K, V> sortByKey(Map<K, V> map, boolean incr) {
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        if (incr) {
            list.sort(Map.Entry.comparingByKey());
        } else {
            list.sort(Collections.reverseOrder(Map.Entry.comparingByKey()));
        }
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map, boolean incr) {
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        if (incr) {
            list.sort(Map.Entry.comparingByValue());
        } else {
            list.sort(Collections.reverseOrder(Map.Entry.comparingByValue()));
        }
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <T> List<List<T>> crossCombineParts(List<List<T>> parts) {
        ArrayList<List<T>> results = new ArrayList<List<T>>();
        ArrayDeque<List<T>> selected = new ArrayDeque<List<T>>();
        CollectionUtil.crossCombineParts(parts, 0, selected, results);
        return results;
    }

    private static <T> void crossCombineParts(List<List<T>> parts, int level, Deque<List<T>> selected, List<List<T>> results) {
        assert (level < parts.size());
        List<T> part = parts.get(level);
        for (List<T> combination : CollectionUtil.anm(part)) {
            selected.addLast(combination);
            if (level < parts.size() - 1) {
                CollectionUtil.crossCombineParts(parts, level + 1, selected, results);
            } else if (level == parts.size() - 1) {
                results.add(CollectionUtil.flatToList(selected));
            }
            selected.removeLast();
        }
    }

    private static <T> List<T> flatToList(Deque<List<T>> parts) {
        ArrayList<T> list = new ArrayList<T>();
        for (List<T> part : parts) {
            list.addAll(part);
        }
        return list;
    }

    public static <T> List<List<T>> cnm(List<T> all, int n, int m) {
        ArrayList combs = new ArrayList();
        CollectionUtil.cnm(all, n, m, comb -> {
            combs.add((List)comb);
            return false;
        });
        return combs;
    }

    public static <T> boolean cnm(List<T> all, int n, int m, Function<List<T>, Boolean> callback) {
        return CollectionUtil.cnm(all, n, m, 0, null, callback);
    }

    private static <T> boolean cnm(List<T> all, int n, int m, int current, List<T> selected, Function<List<T>, Boolean> callback) {
        assert (n <= all.size());
        assert (m <= n);
        assert (current <= all.size());
        if (selected == null) {
            selected = new ArrayList<T>(m);
        }
        if (m == 0) {
            assert (selected.size() > 0) : selected;
            List<T> tmpResult = Collections.unmodifiableList(selected);
            return callback.apply(tmpResult);
        }
        if (n == m) {
            ArrayList<T> tmpResult = new ArrayList<T>(selected);
            tmpResult.addAll(all.subList(current, all.size()));
            return callback.apply(tmpResult);
        }
        if (current >= all.size()) {
            return false;
        }
        int index = selected.size();
        selected.add(all.get(current));
        if (CollectionUtil.cnm(all, n - 1, m - 1, ++current, selected, callback)) {
            return true;
        }
        selected.remove(index);
        assert (selected.size() == index) : selected;
        return CollectionUtil.cnm(all, n - 1, m, current, selected, callback);
    }

    public static <T> List<List<T>> anm(List<T> all) {
        return CollectionUtil.anm(all, all.size(), all.size());
    }

    public static <T> List<List<T>> anm(List<T> all, int n, int m) {
        ArrayList combs = new ArrayList();
        CollectionUtil.anm(all, n, m, comb -> {
            combs.add((List)comb);
            return false;
        });
        return combs;
    }

    public static <T> boolean anm(List<T> all, int n, int m, Function<List<T>, Boolean> callback) {
        return CollectionUtil.anm(all, n, m, null, callback);
    }

    private static <T> boolean anm(List<T> all, int n, int m, List<Integer> selected, Function<List<T>, Boolean> callback) {
        assert (n <= all.size());
        assert (m <= n);
        if (selected == null) {
            selected = new ArrayList<Integer>(m);
        }
        if (m == 0) {
            ArrayList<T> tmpResult = new ArrayList<T>();
            for (int i : selected) {
                tmpResult.add(all.get(i));
            }
            return callback.apply(tmpResult);
        }
        for (int i = 0; i < all.size(); ++i) {
            if (selected.contains(i)) continue;
            int index = selected.size();
            selected.add(i);
            if (CollectionUtil.anm(all, n - 1, m - 1, selected, callback)) {
                return true;
            }
            selected.remove(index);
            assert (selected.size() == index) : selected;
        }
        return false;
    }
}

