/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalInterruptedException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TraversalInterruptionTest
extends AbstractGremlinProcessTest {
    private static final Logger logger = LoggerFactory.getLogger(TraversalInterruptionTest.class);
    @Parameterized.Parameter(value=0)
    public String name;
    @Parameterized.Parameter(value=1)
    public Function<GraphTraversalSource, GraphTraversal<?, ?>> traversalBeforePause;
    @Parameterized.Parameter(value=2)
    public UnaryOperator<GraphTraversal<?, ?>> traversalAfterPause;

    @Parameterized.Parameters(name="expectInterruption({0})")
    public static Iterable<Object[]> data() {
        return Arrays.asList({"g_V", g -> g.V(new Object[0]), t -> t}, {"g_V_out", g -> g.V(new Object[0]), t -> t.out(new String[0])}, {"g_V_outE", g -> g.V(new Object[0]), t -> t.outE(new String[0])}, {"g_V_in", g -> g.V(new Object[0]), t -> t.in(new String[0])}, {"g_V_inE", g -> g.V(new Object[0]), t -> t.inE(new String[0])}, {"g_V_properties", g -> g.V(new Object[0]), t -> t.properties(new String[0])}, {"g_E", g -> g.E(new Object[0]), t -> t}, {"g_E_outV", g -> g.E(new Object[0]), t -> t.outV()}, {"g_E_inV", g -> g.E(new Object[0]), t -> t.inV()}, {"g_E_properties", g -> g.E(new Object[0]), t -> t.properties(new String[0])});
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.GRATEFUL)
    public void shouldRespectThreadInterruptionInVertexStep() throws Exception {
        AtomicBoolean exceptionThrown = new AtomicBoolean(false);
        CountDownLatch startedIterating = new CountDownLatch(1);
        Thread t = new Thread(() -> {
            Traversal traversal = (Traversal)this.traversalAfterPause.apply(this.traversalBeforePause.apply(this.g).sideEffect(traverser -> {
                if (startedIterating.getCount() == 0L) {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (Exception ignored) {
                        Thread.currentThread().interrupt();
                    }
                } else {
                    startedIterating.countDown();
                }
            }));
            try {
                traversal.iterate();
            }
            catch (Exception ex) {
                exceptionThrown.set(ex instanceof TraversalInterruptedException);
                try {
                    traversal.close();
                }
                catch (Exception iex) {
                    logger.error("Error closing traversal after interruption", (Throwable)iex);
                }
            }
        }, this.name);
        t.start();
        MatcherAssert.assertThat((Object)startedIterating.await(5000L, TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Object)true));
        t.interrupt();
        t.join();
        MatcherAssert.assertThat((Object)exceptionThrown.get(), (Matcher)CoreMatchers.is((Object)true));
    }
}

