/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.builder.fluent.Configurations;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnection;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

@Graph.OptIns(value={@Graph.OptIn(value="org.apache.tinkerpop.gremlin.process.ProcessStandardSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.process.ProcessComputerSuite")})
@Graph.OptOuts(value={@Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.ShortestPathTest", method="*", reason="https://issues.apache.org/jira/browse/TINKERPOP-1976"), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.ConnectedComponentTest", method="*", reason="https://issues.apache.org/jira/browse/TINKERPOP-1976"), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.CoreTraversalTest", method="*", reason="The test suite does not support profiling or lambdas and for groovy tests: 'Could not locate method: GraphTraversalSource.withStrategies([{traversalCategory=interface org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy$DecorationStrategy}])'"), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.map.ProgramTest", method="*", reason="RemoteGraph retrieves detached vertices that can't be attached to a remote OLAP graph"), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.ElementIdStrategyProcessTest", method="*", reason="RemoteGraph does not support ElementIdStrategy at this time - it requires a lambda in construction which is not serializable"), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.EventStrategyProcessTest", method="*", reason="RemoteGraph does not support EventStrategy at this time - some of its members are not serializable"), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.PartitionStrategyProcessTest", method="*", reason="RemoteGraph does not support PartitionStrategy at this time"), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.computer.ranking.pagerank.PageRankVertexProgramTest", method="*", reason="RemoteGraph does not support direct Graph.compute() access"), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.computer.search.path.ShortestPathVertexProgramTest", method="*", reason="RemoteGraph does not support direct Graph.compute() access"), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.computer.clone.CloneVertexProgramTest", method="*", reason="RemoteGraph does not support direct Graph.compute() access"), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.computer.GraphComputerTest", method="*", reason="RemoteGraph does not support direct Graph.compute() access"), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.TraversalInterruptionTest", method="*", reason="The interruption model in the test can't guarantee interruption at the right time with RemoteGraph."), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.TraversalInterruptionComputerTest", method="*", reason="The interruption model in the test can't guarantee interruption at the right time with RemoteGraph."), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.ComplexTest", method="classicRecommendation", reason="Test asserts traversal side-effects which are not supported by remote traversals."), @Graph.OptOut(test="org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.GroupTest", method="g_V_group_byXlabelX_byXbothE_groupXaX_byXlabelX_byXweight_sumX_weight_sumX", reason="Test asserts traversal side-effects which are not supported by remote traversals.")})
public class RemoteGraph
implements Graph {
    private final RemoteConnection connection;
    private final Configuration conf;

    private RemoteGraph(RemoteConnection connection, Configuration conf) {
        this.connection = connection;
        this.conf = conf;
    }

    public static RemoteGraph open(Configuration conf) {
        RemoteConnection remoteConnection;
        if (!conf.containsKey("gremlin.remote.remoteConnectionClass")) {
            throw new IllegalArgumentException("Configuration must contain the 'gremlin.remote.remoteConnectionClass' key");
        }
        try {
            Class<RemoteConnection> clazz = Class.forName(conf.getString("gremlin.remote.remoteConnectionClass")).asSubclass(RemoteConnection.class);
            Constructor<RemoteConnection> ctor = clazz.getConstructor(Configuration.class);
            remoteConnection = ctor.newInstance(conf);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        return new RemoteGraph(remoteConnection, conf);
    }

    public static RemoteGraph open(String configFile) throws Exception {
        Configurations configs = new Configurations();
        return RemoteGraph.open((Configuration)configs.properties(configFile));
    }

    public static RemoteGraph open(RemoteConnection connection, Configuration conf) {
        return new RemoteGraph(connection, conf);
    }

    public RemoteConnection getConnection() {
        return this.connection;
    }

    public void close() throws Exception {
        this.connection.close();
    }

    public Vertex addVertex(Object ... keyValues) {
        throw new UnsupportedOperationException(String.format("RemoteGraph is a proxy to %s - this method is not supported", this.connection));
    }

    public <C extends GraphComputer> C compute(Class<C> graphComputerClass) throws IllegalArgumentException {
        throw new UnsupportedOperationException(String.format("RemoteGraph is a proxy to %s - this method is not supported", this.connection));
    }

    public GraphComputer compute() throws IllegalArgumentException {
        throw new UnsupportedOperationException(String.format("RemoteGraph is a proxy to %s - this method is not supported", this.connection));
    }

    public Iterator<Vertex> vertices(Object ... vertexIds) {
        return Collections.emptyIterator();
    }

    public Iterator<Edge> edges(Object ... edgeIds) {
        return Collections.emptyIterator();
    }

    public Transaction tx() {
        throw new UnsupportedOperationException(String.format("RemoteGraph is a proxy to %s - this method is not supported", this.connection));
    }

    public Graph.Variables variables() {
        throw new UnsupportedOperationException(String.format("RemoteGraph is a proxy to %s - this method is not supported", this.connection));
    }

    public Configuration configuration() {
        return this.conf;
    }

    public Graph.Features features() {
        return RemoteFeatures.INSTANCE;
    }

    public String toString() {
        return StringFactory.graphString((Graph)this, (String)this.connection.toString());
    }

    public static class RemoteGraphFeatures
    implements Graph.Features.GraphFeatures {
        static RemoteGraphFeatures INSTANCE = new RemoteGraphFeatures();

        private RemoteGraphFeatures() {
        }

        public boolean supportsTransactions() {
            return false;
        }

        public boolean supportsThreadedTransactions() {
            return false;
        }
    }

    public static class RemoteFeatures
    implements Graph.Features {
        static RemoteFeatures INSTANCE = new RemoteFeatures();

        private RemoteFeatures() {
        }

        public Graph.Features.GraphFeatures graph() {
            return RemoteGraphFeatures.INSTANCE;
        }
    }
}

