/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util.reference;

import java.util.HashSet;
import java.util.Iterator;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirementSet;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.Host;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceEdge;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.junit.Assert;
import org.junit.Test;

public class ReferenceEdgeTest
extends AbstractGremlinTest {
    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldHashAndEqualCorrectly() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e = v.addEdge("test", v, new Object[0]);
        HashSet<Object> set = new HashSet<Object>();
        for (int i = 0; i < 100; ++i) {
            set.add(ReferenceFactory.detach((Edge)e));
            set.add(e);
        }
        Assert.assertEquals((long)1L, (long)set.size());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldNotConstructNewWithSomethingAlreadyReferenced() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e = v.addEdge("test", v, new Object[0]);
        ReferenceEdge re = ReferenceFactory.detach((Edge)e);
        Assert.assertEquals((Object)"test", (Object)re.label());
        Assert.assertSame((Object)re, (Object)ReferenceFactory.detach((Edge)re));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")
    public void shouldConstructReferenceEdge() {
        ((Edge)this.g.E(new Object[]{this.convertToEdgeId("marko", "knows", "vadas")}).next()).property("year", (Object)2002);
        ReferenceEdge referenceEdge = ReferenceFactory.detach((Edge)((Edge)this.g.E(new Object[]{this.convertToEdgeId("marko", "knows", "vadas")}).next()));
        Assert.assertEquals((Object)this.convertToEdgeId("marko", "knows", "vadas"), (Object)referenceEdge.id());
        Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)referenceEdge.properties(new String[0])));
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)referenceEdge.vertices(Direction.BOTH)));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldEvaluateToEqual() {
        Assert.assertTrue((boolean)ReferenceFactory.detach((Edge)((Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next())).equals((Object)ReferenceFactory.detach((Edge)((Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next()))));
        Assert.assertTrue((boolean)ReferenceFactory.detach((Edge)((Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next())).equals(this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next()));
        Assert.assertTrue((boolean)ReferenceFactory.detach((Edge)((Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next())).equals((Object)DetachedFactory.detach((Edge)((Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next()), (boolean)true)));
        Assert.assertTrue((boolean)ReferenceFactory.detach((Edge)((Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next())).equals((Object)ReferenceFactory.detach((Edge)((Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next()))));
        Assert.assertTrue((boolean)((Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next()).equals(ReferenceFactory.detach((Edge)((Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next()))));
        Assert.assertTrue((boolean)DetachedFactory.detach((Edge)((Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next()), (boolean)true).equals((Object)ReferenceFactory.detach((Edge)((Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next()))));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldHaveSameHashCode() {
        Assert.assertEquals((long)ReferenceFactory.detach((Edge)((Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next())).hashCode(), (long)ReferenceFactory.detach((Edge)((Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next())).hashCode());
        Assert.assertEquals((long)ReferenceFactory.detach((Edge)((Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next())).hashCode(), (long)((Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next()).hashCode());
        Assert.assertEquals((long)ReferenceFactory.detach((Edge)((Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next())).hashCode(), (long)DetachedFactory.detach((Edge)((Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next()), (boolean)false).hashCode());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldAttachToGraph() {
        Edge toReference = (Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next();
        ReferenceEdge referenceEdge = ReferenceFactory.detach((Edge)toReference);
        Edge referenced = (Edge)referenceEdge.attach(Attachable.Method.get((Host)this.graph));
        Assert.assertEquals((Object)toReference, (Object)referenced);
        Assert.assertFalse((boolean)(referenced instanceof ReferenceEdge));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldAttachToVertex() {
        Edge toReference = (Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next();
        Vertex outV = (Vertex)toReference.vertices(Direction.OUT).next();
        ReferenceEdge referenceEdge = ReferenceFactory.detach((Edge)toReference);
        Edge attached = (Edge)referenceEdge.attach(Attachable.Method.get((Host)outV));
        Assert.assertEquals((Object)toReference, (Object)attached);
        Assert.assertFalse((boolean)(attached instanceof ReferenceEdge));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")
    public void shouldNotEvaluateToEqualDifferentId() {
        Object joshCreatedLopEdgeId = this.convertToEdgeId("josh", "created", "lop");
        Vertex vOut = (Vertex)this.g.V(new Object[]{this.convertToVertexId("josh")}).next();
        Vertex vIn = (Vertex)this.g.V(new Object[]{this.convertToVertexId("lop")}).next();
        Edge e = vOut.addEdge("created", vIn, new Object[]{"weight", 0.4});
        Assert.assertFalse((boolean)ReferenceFactory.detach((Edge)((Edge)this.g.E(new Object[]{joshCreatedLopEdgeId}).next())).equals((Object)ReferenceFactory.detach((Edge)e)));
    }

    @Test(expected=IllegalStateException.class)
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldNotAllowSetProperty() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e = v.addEdge("test", v, new Object[0]);
        ReferenceEdge re = ReferenceFactory.detach((Edge)e);
        re.property("test", (Object)"test");
    }

    @Test(expected=IllegalStateException.class)
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldNotAllowRemove() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e = v.addEdge("test", v, new Object[0]);
        ReferenceEdge re = ReferenceFactory.detach((Edge)e);
        re.remove();
    }
}

