/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.app.extracting;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.ansj.app.extracting.domain.ExtractingResult;
import org.ansj.app.extracting.domain.Rule;
import org.ansj.app.extracting.domain.Token;
import org.ansj.domain.Result;
import org.ansj.domain.Term;

public class ExtractingTask
implements Runnable {
    private ExtractingResult result;
    private Rule rule;
    private int index;
    private Result terms;
    private int step;
    private List[] list;

    public ExtractingTask(ExtractingResult result, Rule rule, int index, Result terms) {
        this.result = result;
        this.rule = rule;
        this.index = index;
        this.terms = terms;
        this.list = new ArrayList[rule.getTokens().size()];
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void run() {
        List<Token> tokens = this.rule.getTokens();
        Token token = tokens.get(0);
        block7: for (int i = this.index; i < this.terms.size(); ++i) {
            Term term = this.terms.get(i);
            switch (this.validate(token, term)) {
                case STOP: {
                    return;
                }
                case OVER: {
                    this.result.add(this);
                    return;
                }
                case NEXT_TERM: {
                    break;
                }
                case NEXT_TOKEN: {
                    --i;
                    token = token.getNext();
                    if (token != null) break;
                    break block7;
                }
                case NEXT_TERM_TOKEN: {
                    token = token.getNext();
                }
            }
        }
        boolean end = true;
        while (token != null && (token = token.getNext()) != null) {
            if (token.getRange() != null && token.getRange()[0] == 0) continue;
            end = false;
        }
        if (end) {
            this.result.add(this);
        }
    }

    private Action validate(Token token, Term term) {
        if (token == null) {
            return Action.OVER;
        }
        int[] range = token.getRange();
        if (this._validate(token, term)) {
            if (range != null && range[0] == 0) {
                return Action.NEXT_TOKEN;
            }
            if (range != null && this.step >= range[0] && this.step <= range[1]) {
                this.step = 0;
                return Action.NEXT_TOKEN;
            }
            return Action.STOP;
        }
        if (range == null) {
            this.insertInto(term, token.getIndex());
            if (token.getNext() == null) {
                return Action.OVER;
            }
            return Action.NEXT_TERM_TOKEN;
        }
        if (this.step < range[0]) {
            ++this.step;
            this.insertInto(term, token.getIndex());
            return Action.NEXT_TERM;
        }
        if (this.step > range[1]) {
            return Action.STOP;
        }
        ++this.step;
        if (this.step > range[0]) {
            if (this._validate(token.getNext(), term)) {
                this.insertInto(term, token.getIndex());
                if (token.getNext() == null) {
                    if (this.step >= range[1]) {
                        return Action.OVER;
                    }
                    return Action.NEXT_TERM;
                }
                return Action.NEXT_TERM;
            }
            this.step = 0;
            return Action.NEXT_TOKEN;
        }
        this.insertInto(term, token.getNext().getIndex());
        return Action.NEXT_TERM;
    }

    private void insertInto(Term term, int index) {
        ArrayList<Term> tempList = this.list[index];
        if (tempList == null) {
            this.list[index] = tempList = new ArrayList<Term>();
        }
        tempList.add(term);
    }

    private boolean _validate(Token token, Term term) {
        if (token == null) {
            return true;
        }
        Set<String> terms = token.getTerms();
        if (!(terms.contains(":*") || terms.contains(term.getName()) || terms.contains(":" + term.getNatureStr()))) {
            return true;
        }
        boolean flag = token.getRegexs().size() != 0;
        for (String regex : token.getRegexs()) {
            if (!term.getName().matches(regex)) continue;
            flag = false;
            break;
        }
        return flag;
    }

    public int getIndex() {
        return this.index;
    }

    public Rule getRule() {
        return this.rule;
    }

    public List[] getList() {
        return this.list;
    }

    private static enum Action {
        STOP,
        NEXT_TOKEN,
        NEXT_TERM,
        NEXT_TERM_TOKEN,
        OVER;

    }
}

