/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.app.extracting.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ansj.app.extracting.exception.RuleFormatException;

public class Token {
    public static final String ALL = ":*";
    private int index;
    private Set<String> terms = new HashSet<String>();
    private List<String> regexs;
    private int[] range;
    private Token prev;
    private Token next;

    public Token(int index, String termsStr) {
        String[] split;
        this.index = index;
        for (String str : split = termsStr.substring(1, termsStr.length() - 1).split("\\|")) {
            this.terms.add(str);
        }
    }

    public void addAttr(String str) throws RuleFormatException {
        char head = str.charAt(0);
        str = str.substring(1, str.length() - 1);
        if (head == '[') {
            if (this.regexs == null) {
                this.regexs = new ArrayList<String>();
            }
            this.regexs.add(str);
        } else if (head == '{') {
            String[] split = str.split(",");
            if (this.range == null) {
                this.range = new int[2];
            }
            if (split.length >= 2) {
                this.range[0] = Integer.parseInt(split[0].trim());
                this.range[1] = Integer.parseInt(split[1].trim());
            } else {
                this.range[0] = Integer.parseInt(split[0].trim());
                this.range[1] = Integer.parseInt(split[0].trim());
            }
        } else {
            throw new RuleFormatException("err format attr by " + str);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Set<String> getTerms() {
        return this.terms;
    }

    public void setTerms(Set<String> terms) {
        this.terms = terms;
    }

    public List<String> getRegexs() {
        if (this.regexs == null) {
            return Collections.emptyList();
        }
        return this.regexs;
    }

    public void setRegexs(List<String> regexs) {
        this.regexs = regexs;
    }

    public int[] getRange() {
        return this.range;
    }

    public void setRange(int[] range) {
        this.range = range;
    }

    public Token getPrev() {
        return this.prev;
    }

    public Token getNext() {
        return this.next;
    }

    public void setNext(Token next) {
        this.next = next;
        next.prev = this;
    }

    public String toString() {
        return "index=" + this.index + ",terms=" + this.terms + ",regexs=" + this.regexs + ",range=" + Arrays.toString(this.range);
    }
}

