/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.util;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ansj.domain.AnsjItem;
import org.ansj.domain.Result;
import org.ansj.domain.Term;
import org.ansj.domain.TermNatures;
import org.ansj.library.DATDictionary;
import org.ansj.splitWord.Analysis;
import org.ansj.util.TermUtil;
import org.nlpcn.commons.lang.util.WordAlert;

public class Graph {
    public char[] chars = null;
    public Term[] terms = null;
    protected Term end = null;
    protected Term root = null;
    protected static final String B = "BEGIN";
    protected static final String E = "END";
    public boolean hasPerson;
    public boolean hasNumQua;
    public String str;

    public Graph(String str) {
        this.str = str;
        this.chars = WordAlert.alertStr((String)str);
        this.terms = new Term[this.chars.length + 1];
        this.end = new Term(E, this.chars.length, AnsjItem.END);
        this.root = new Term(B, -1, AnsjItem.BEGIN);
        this.terms[this.chars.length] = this.end;
    }

    public Graph(Result result) {
        Term last = result.get(result.size() - 1);
        int beginOff = result.get(0).getOffe();
        int len = last.getOffe() - beginOff + last.getName().length();
        this.terms = new Term[len + 1];
        this.end = new Term(E, len, AnsjItem.END);
        this.root = new Term(B, -1, AnsjItem.BEGIN);
        this.terms[len] = this.end;
        Iterator<Term> iterator = result.iterator();
        while (iterator.hasNext()) {
            Term term;
            this.terms[term.getOffe() - beginOff] = term = iterator.next();
        }
    }

    public List<Term> getResult(Analysis.Merger merger) {
        return merger.merger();
    }

    public void addTerm(Term term) {
        if (!this.hasPerson && term.termNatures().personAttr.isActive()) {
            this.hasPerson = true;
        }
        if (!this.hasNumQua && term.termNatures().numAttr.isQua()) {
            this.hasNumQua = true;
        }
        TermUtil.insertTerm(this.terms, term, TermUtil.InsertTermType.REPLACE);
    }

    protected Term optimalRoot() {
        Term to = this.end;
        to.clearScore();
        Term from = null;
        while ((from = to.from()) != null) {
            for (int i = from.getOffe() + 1; i < to.getOffe(); ++i) {
                this.terms[i] = null;
            }
            if (from.getOffe() > -1) {
                this.terms[from.getOffe()] = from;
            }
            from.setNext(null);
            from.setTo(to);
            from.clearScore();
            to = from;
        }
        return this.root;
    }

    public void rmLittlePath() {
        int maxTo = -1;
        Term temp = null;
        Term maxTerm = null;
        boolean flag = false;
        int length = this.terms.length - 1;
        block4: for (int i = 0; i < length; ++i) {
            maxTerm = this.getMaxTerm(i);
            if (maxTerm == null) continue;
            maxTo = maxTerm.toValue();
            switch (maxTerm.getName().length()) {
                case 1: {
                    continue block4;
                }
                case 2: {
                    if (this.terms[i + 1] == null) {
                        ++i;
                        continue block4;
                    }
                }
                default: {
                    int j;
                    for (j = i + 1; j < maxTo; ++j) {
                        temp = this.getMaxTerm(j);
                        if (temp == null || maxTo >= temp.toValue()) continue;
                        maxTo = temp.toValue();
                        flag = true;
                    }
                    if (flag) {
                        i = maxTo - 1;
                        flag = false;
                        continue block4;
                    }
                    maxTerm.setNext(null);
                    this.terms[i] = maxTerm;
                    for (j = i + 1; j < maxTo; ++j) {
                        this.terms[j] = null;
                    }
                }
            }
        }
    }

    private Term getMaxTerm(int i) {
        Term maxTerm = this.terms[i];
        if (maxTerm == null) {
            return null;
        }
        Term term = maxTerm;
        while ((term = term.next()) != null) {
            maxTerm = term;
        }
        return maxTerm;
    }

    public void rmLittleSinglePath() {
        int maxTo = -1;
        Term temp = null;
        for (int i = 0; i < this.terms.length; ++i) {
            if (this.terms[i] == null || (maxTo = this.terms[i].toValue()) - i == 1 || i + 1 == this.terms.length) continue;
            for (int j = i; j < maxTo; ++j) {
                temp = this.terms[j];
                if (temp == null || temp.toValue() > maxTo || temp.getName().length() != 1) continue;
                this.terms[j] = null;
            }
        }
    }

    public void rmLittlePathByScore() {
        int maxTo = -1;
        Term temp = null;
        for (int i = 0; i < this.terms.length; ++i) {
            if (this.terms[i] == null) continue;
            Term maxTerm = null;
            double maxScore = 0.0;
            Term term = this.terms[i];
            do {
                if (maxTerm == null || maxScore > term.score()) {
                    maxTerm = term;
                    continue;
                }
                if (maxScore != term.score() || maxTerm.getName().length() >= term.getName().length()) continue;
                maxTerm = term;
            } while ((term = term.next()) != null);
            term = maxTerm;
            do {
                int j;
                maxTo = term.toValue();
                maxScore = term.score();
                if (maxTo - i == 1 || i + 1 == this.terms.length) continue;
                boolean flag = true;
                block3: for (j = i; j < maxTo; ++j) {
                    temp = this.terms[j];
                    if (temp == null) continue;
                    do {
                        if (temp.toValue() <= maxTo && !(temp.score() < maxScore)) continue;
                        flag = false;
                        break block3;
                    } while ((temp = temp.next()) != null);
                }
                if (!flag) continue;
                for (j = i + 1; j < maxTo; ++j) {
                    this.terms[j] = null;
                }
            } while ((term = term.next()) != null);
        }
    }

    public void walkPathByScore() {
        this.walkPathByScore(true);
    }

    public void walkPathByScore(boolean asc) {
        Term term = null;
        this.mergerByScore(this.root, 0, asc);
        for (int i = 0; i < this.terms.length; ++i) {
            for (term = this.terms[i]; term != null && term.from() != null && term != this.end; term = term.next()) {
                int to = term.toValue();
                this.mergerByScore(term, to, asc);
            }
        }
        this.optimalRoot();
    }

    public void walkPath() {
        this.walkPath(null);
    }

    public void walkPath(Map<String, Double> relationMap) {
        Term term = null;
        this.merger(this.root, 0, relationMap);
        for (int i = 0; i < this.terms.length; ++i) {
            for (term = this.terms[i]; term != null && term.from() != null && term != this.end; term = term.next()) {
                int to = term.toValue();
                this.merger(term, to, relationMap);
            }
        }
        this.optimalRoot();
    }

    private void merger(Term fromTerm, int to, Map<String, Double> relationMap) {
        Term term = null;
        if (this.terms[to] != null) {
            for (term = this.terms[to]; term != null; term = term.next()) {
                term.setPathScore(fromTerm, relationMap);
            }
        } else {
            char c = this.chars[to];
            TermNatures tn = DATDictionary.getItem((int)c).termNatures;
            if (tn == null || tn == TermNatures.NULL) {
                tn = TermNatures.NULL;
            }
            this.terms[to] = new Term(String.valueOf(c), to, tn);
            this.terms[to].setPathScore(fromTerm, relationMap);
        }
    }

    private void mergerByScore(Term fromTerm, int to, boolean asc) {
        Term term = null;
        if (this.terms[to] != null) {
            for (term = this.terms[to]; term != null; term = term.next()) {
                term.setPathSelfScore(fromTerm, asc);
            }
        }
    }

    public void printGraph() {
        for (Term term : this.terms) {
            if (term == null) continue;
            System.out.print(term.getName() + "\t" + term.score() + " ,");
            while ((term = term.next()) != null) {
                System.out.print(term + "\t" + term.score() + " ,");
            }
            System.out.println();
        }
    }
}

