/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.util;

import java.util.Map;
import org.ansj.domain.Term;
import org.ansj.library.NatureLibrary;
import org.ansj.library.NgramLibrary;
import org.ansj.recognition.impl.NatureRecognition;

public class MathUtil {
    private static final double dSmoothingPara = 0.1;
    private static final String TAB = "\t";
    private static final int MAX_FREQUENCE = 2079997;
    private static final double dTemp = 4.807699241873907E-7;

    public static double compuScore(Term from, Term to, Map<String, Double> relationMap) {
        double value;
        Double d;
        double frequency = from.termNatures().allFreq + 1;
        if (frequency < 0.0) {
            double score = from.score() + 2079997.0;
            from.score(score);
            return score;
        }
        double nTwoWordsFreq = NgramLibrary.getTwoWordFreq(from, to);
        if (relationMap != null && (d = relationMap.get(from.getName() + TAB + to.getName())) != null) {
            nTwoWordsFreq += d.doubleValue();
        }
        if ((value = -Math.log(0.1 * frequency / 2159997.0 + 0.9 * (0.9999995192300758 * nTwoWordsFreq / frequency + 4.807699241873907E-7))) < 0.0) {
            value += frequency;
        }
        return from.score() + value;
    }

    public static double compuScoreFreq(Term from, Term term) {
        return from.termNatures().allFreq + term.termNatures().allFreq;
    }

    public static double compuNatureFreq(NatureRecognition.NatureTerm from, NatureRecognition.NatureTerm to) {
        double twoWordFreq = NatureLibrary.getTwoNatureFreq(from.termNature.nature, to.termNature.nature);
        if (twoWordFreq == 0.0) {
            twoWordFreq = Math.log(from.selfScore + to.selfScore);
        }
        double score = from.score + Math.log((from.selfScore + to.selfScore) * twoWordFreq) + to.selfScore;
        return score;
    }

    public static double lnSum(float ... fs) {
        double result = 0.0;
        for (int i = 0; i < fs.length; ++i) {
            result += -Math.log(fs[i]);
        }
        return result;
    }
}

