/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.page;

import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.serializer.BytesBuffer;
import org.apache.hugegraph.util.Bytes;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.StringEncoding;

public class PageState {
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final PageState EMPTY = new PageState(EMPTY_BYTES, 0, 0);
    public static final char SPACE = ' ';
    public static final char PLUS = '+';
    private final byte[] position;
    private final int offset;
    private final int total;

    public PageState(byte[] position, int offset, int total) {
        E.checkNotNull((Object)position, (String)"position");
        this.position = position;
        this.offset = offset;
        this.total = total;
    }

    public byte[] position() {
        return this.position;
    }

    public int offset() {
        return this.offset;
    }

    public long total() {
        return this.total;
    }

    public String toString() {
        if (Bytes.equals((byte[])this.position(), (byte[])EMPTY_BYTES)) {
            return null;
        }
        return PageState.toString(this.toBytes());
    }

    private byte[] toBytes() {
        assert (this.position.length > 0);
        int length = 2 + this.position.length + 8;
        BytesBuffer buffer = BytesBuffer.allocate(length);
        buffer.writeBytes(this.position);
        buffer.writeInt(this.offset);
        buffer.writeInt(this.total);
        return buffer.bytes();
    }

    public static PageState fromString(String page) {
        E.checkNotNull((Object)page, (String)"page");
        page = page.replace(' ', '+');
        return PageState.fromBytes(PageState.toBytes(page));
    }

    public static PageState fromBytes(byte[] bytes) {
        if (bytes.length == 0) {
            return EMPTY;
        }
        try {
            BytesBuffer buffer = BytesBuffer.wrap(bytes);
            return new PageState(buffer.readBytes(), buffer.readInt(), buffer.readInt());
        }
        catch (Exception e) {
            throw new BackendException("Invalid page: '0x%s'", (Throwable)e, Bytes.toHex((byte[])bytes));
        }
    }

    public static String toString(byte[] bytes) {
        return StringEncoding.encodeBase64(bytes);
    }

    public static byte[] toBytes(String page) {
        try {
            return StringEncoding.decodeBase64(page);
        }
        catch (Exception e) {
            throw new BackendException("Invalid page: '%s'", (Throwable)e, page);
        }
    }
}

