/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.election;

import java.util.Objects;

public class RoleTypeData {
    private String node;
    private long clock;
    private int epoch;

    public RoleTypeData(String node, int epoch) {
        this(node, epoch, 1L);
    }

    public RoleTypeData(String node, int epoch, long clock) {
        this.node = node;
        this.epoch = epoch;
        this.clock = clock;
    }

    public void increaseClock() {
        ++this.clock;
    }

    public boolean isMaster(String node) {
        return Objects.equals(this.node, node);
    }

    public int epoch() {
        return this.epoch;
    }

    public long clock() {
        return this.clock;
    }

    public void clock(long clock) {
        this.clock = clock;
    }

    public String node() {
        return this.node;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RoleTypeData)) {
            return false;
        }
        RoleTypeData metaData = (RoleTypeData)obj;
        return this.clock == metaData.clock && this.epoch == metaData.epoch && Objects.equals(this.node, metaData.node);
    }

    public int hashCode() {
        return Objects.hash(this.node, this.clock, this.epoch);
    }

    public String toString() {
        return "RoleStateData{node='" + this.node + '\'' + ", clock=" + this.clock + ", epoch=" + this.epoch + '}';
    }
}

