/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.algorithm;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.job.UserJob;
import org.apache.hugegraph.job.algorithm.AbstractAlgorithm;
import org.apache.hugegraph.structure.HugeEdge;
import org.apache.hugegraph.type.define.Directions;
import org.apache.tinkerpop.gremlin.structure.Edge;

public abstract class BfsTraverser<T extends Node>
extends AbstractAlgorithm.AlgoTraverser
implements AutoCloseable {
    private final Stack<Id> traversedVertices = new Stack();

    public BfsTraverser(UserJob<Object> job) {
        super(job);
    }

    protected void compute(Id startVertex, Directions direction, Id edgeLabel, long degree, long depth) {
        Map<Id, T> localNodes = this.traverse(startVertex, direction, edgeLabel, degree, depth);
        this.backtrack(startVertex, localNodes);
    }

    protected Map<Id, T> traverse(Id startVertex, Directions direction, Id edgeLabel, long degree, long depth) {
        HashMap<Id, Object> localNodes = new HashMap<Id, Object>();
        localNodes.put(startVertex, this.createStartNode());
        LinkedList<Id> traversingVertices = new LinkedList<Id>();
        traversingVertices.add(startVertex);
        while (!traversingVertices.isEmpty()) {
            Id source = (Id)traversingVertices.removeFirst();
            this.traversedVertices.push(source);
            Node sourceNode = (Node)localNodes.get(source);
            if (depth != -1L && (long)sourceNode.distance() >= depth) continue;
            Iterator<Edge> edges = this.edgesOfVertex(source, direction, edgeLabel, degree);
            while (edges.hasNext()) {
                HugeEdge edge = (HugeEdge)edges.next();
                Id target = edge.otherVertex().id();
                Node targetNode = (Node)localNodes.get(target);
                boolean firstTime = false;
                if (targetNode == null) {
                    firstTime = true;
                    targetNode = this.createNode(sourceNode);
                    localNodes.put(target, targetNode);
                    traversingVertices.addLast(target);
                }
                if (targetNode.distance() != sourceNode.distance() + 1) continue;
                this.meetNode(target, targetNode, source, sourceNode, firstTime);
            }
        }
        return localNodes;
    }

    protected void backtrack(Id startVertex, Map<Id, T> localNodes) {
        while (!this.traversedVertices.empty()) {
            Id currentVertex = this.traversedVertices.pop();
            this.backtrack(startVertex, currentVertex, localNodes);
        }
    }

    protected abstract T createStartNode();

    protected abstract T createNode(T var1);

    protected abstract void meetNode(Id var1, T var2, Id var3, T var4, boolean var5);

    protected abstract void backtrack(Id var1, Id var2, Map<Id, T> var3);

    public static class Node {
        private Id[] parents;
        private int pathCount;
        private final int distance;

        public Node(Node parentNode) {
            this(0, parentNode.distance + 1);
        }

        public Node(int pathCount, int distance) {
            this.pathCount = pathCount;
            this.distance = distance;
            this.parents = new Id[0];
        }

        public int distance() {
            return this.distance;
        }

        public Id[] parents() {
            return this.parents;
        }

        public void addParent(Id parentId) {
            Id[] newParents = new Id[this.parents.length + 1];
            System.arraycopy(this.parents, 0, newParents, 0, this.parents.length);
            newParents[newParents.length - 1] = parentId;
            this.parents = newParents;
        }

        public void addParentNode(Node node, Id parentId) {
            this.pathCount += node.pathCount;
            this.addParent(parentId);
        }

        protected int pathCount() {
            return this.pathCount;
        }
    }
}

