/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.algorithm;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.hugegraph.job.UserJob;
import org.apache.hugegraph.job.algorithm.AbstractAlgorithm;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class CountVertexAlgorithm
extends AbstractAlgorithm {
    @Override
    public String name() {
        return "count_vertex";
    }

    @Override
    public String category() {
        return "aggregate";
    }

    @Override
    public Object call(UserJob<Object> job, Map<String, Object> parameters) {
        try (Traverser traverser = new Traverser(job);){
            Object object = traverser.count();
            return object;
        }
    }

    private static class Traverser
    extends AbstractAlgorithm.AlgoTraverser {
        public Traverser(UserJob<Object> job) {
            super(job);
        }

        public Object count() {
            Iterator<Vertex> vertices = this.vertices();
            HashMap<String, MutableLong> counts = new HashMap<String, MutableLong>();
            long total = 0L;
            while (vertices.hasNext()) {
                Vertex vertex = vertices.next();
                String label = vertex.label();
                MutableLong count = (MutableLong)counts.get(label);
                if (count != null) {
                    count.increment();
                } else {
                    counts.put(label, new MutableLong(1L));
                }
                this.updateProgress(++total);
            }
            counts.put("*", new MutableLong(total));
            return JsonUtil.asJson(counts);
        }
    }
}

