/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.algorithm.cent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.SplicingIdGenerator;
import org.apache.hugegraph.job.UserJob;
import org.apache.hugegraph.job.algorithm.cent.AbstractCentAlgorithm;
import org.apache.hugegraph.structure.HugeElement;
import org.apache.hugegraph.type.define.Directions;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class BetweennessCentralityAlgorithm
extends AbstractCentAlgorithm {
    @Override
    public String name() {
        return "betweenness_centrality";
    }

    @Override
    public void checkParameters(Map<String, Object> parameters) {
        super.checkParameters(parameters);
    }

    @Override
    public Object call(UserJob<Object> job, Map<String, Object> parameters) {
        try (Traverser traverser = new Traverser(job);){
            Object object = traverser.betweennessCentrality(BetweennessCentralityAlgorithm.direction(parameters), BetweennessCentralityAlgorithm.edgeLabel(parameters), BetweennessCentralityAlgorithm.depth(parameters), BetweennessCentralityAlgorithm.degree(parameters), BetweennessCentralityAlgorithm.sample(parameters), BetweennessCentralityAlgorithm.sourceLabel(parameters), BetweennessCentralityAlgorithm.sourceSample(parameters), BetweennessCentralityAlgorithm.sourceCLabel(parameters), BetweennessCentralityAlgorithm.top(parameters));
            return object;
        }
    }

    private static class Traverser
    extends AbstractCentAlgorithm.Traverser {
        public Traverser(UserJob<Object> job) {
            super(job);
        }

        public Object betweennessCentrality(Directions direction, String label, int depth, long degree, long sample, String sourceLabel, long sourceSample, String sourceCLabel, long topN) {
            assert (depth > 0);
            assert (degree > 0L || degree == -1L);
            assert (topN >= 0L || topN == -1L);
            GraphTraversal t = this.constructSource(sourceLabel, sourceSample, sourceCLabel);
            t = this.constructPath(t, direction, label, degree, sample, sourceLabel, sourceCLabel);
            t = t.emit().until((Traversal)__.loops().is(P.gte((Object)depth)));
            t = this.filterNonShortestPath(t, false);
            GraphTraversal<Vertex, ?> tg = this.groupPathByEndpoints(t);
            tg = this.computeBetweenness(tg);
            GraphTraversal<Vertex, ?> tLimit = this.topN(tg, topN);
            return this.execute(tLimit, () -> tLimit.next());
        }

        protected GraphTraversal<Vertex, ?> groupPathByEndpoints(GraphTraversal<Vertex, Vertex> t) {
            return t.map(it -> {
                List path = (List)it.path(Pop.all, "v");
                ArrayList<Id> pathById = new ArrayList<Id>(path.size());
                for (HugeElement v : path) {
                    pathById.add(v.id());
                }
                return pathById;
            }).group().by(it -> {
                List path = (List)it;
                assert (path.size() >= 2);
                String first = ((Id)path.get(0)).toString();
                String last = ((Id)path.get(path.size() - 1)).toString();
                return SplicingIdGenerator.concat(first, last);
            }).unfold();
        }

        protected GraphTraversal<Vertex, ?> computeBetweenness(GraphTraversal<Vertex, ?> t) {
            return t.fold(new HashMap(), (results, it) -> {
                Map.Entry entry = (Map.Entry)it;
                List paths = (List)entry.getValue();
                for (List path : paths) {
                    int len = path.size();
                    if (len <= 2) continue;
                    for (int i = 1; i < len - 1; ++i) {
                        Id vertex = (Id)path.get(i);
                        MutableFloat value = (MutableFloat)results.get(vertex);
                        if (value == null) {
                            value = new MutableFloat();
                            results.put(vertex, value);
                        }
                        value.add(1.0f / (float)paths.size());
                    }
                }
                return results;
            });
        }
    }
}

