/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.schema;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.schema.SchemaElement;
import org.apache.hugegraph.schema.SchemaLabel;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.schema.builder.SchemaBuilder;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.IndexType;
import org.apache.hugegraph.util.E;

public class IndexLabel
extends SchemaElement {
    private HugeType baseType = HugeType.SYS_SCHEMA;
    private Id baseValue = NONE_ID;
    private IndexType indexType = IndexType.SECONDARY;
    private List<Id> indexFields = new ArrayList<Id>();
    private static final IndexLabel VL_IL = new IndexLabel(-1L, "~vli");
    private static final IndexLabel EL_IL = new IndexLabel(-2L, "~eli");
    private static final IndexLabel PKN_IL = new IndexLabel(-3L, "~pkni");
    private static final IndexLabel VLN_IL = new IndexLabel(-4L, "~vlni");
    private static final IndexLabel ELN_IL = new IndexLabel(-5L, "~elni");
    private static final IndexLabel ILN_IL = new IndexLabel(-6L, "~ilni");

    public IndexLabel(HugeGraph graph, Id id, String name) {
        super(graph, id, name);
    }

    protected IndexLabel(long id, String name) {
        this(null, IdGenerator.of(id), name);
    }

    @Override
    public HugeType type() {
        return HugeType.INDEX_LABEL;
    }

    public HugeType baseType() {
        return this.baseType;
    }

    public void baseType(HugeType baseType) {
        this.baseType = baseType;
    }

    public Id baseValue() {
        return this.baseValue;
    }

    public void baseValue(Id id) {
        this.baseValue = id;
    }

    public IndexType indexType() {
        return this.indexType;
    }

    public void indexType(IndexType indexType) {
        this.indexType = indexType;
    }

    public HugeType queryType() {
        switch (this.baseType) {
            case VERTEX_LABEL: {
                return HugeType.VERTEX;
            }
            case EDGE_LABEL: {
                return HugeType.EDGE;
            }
            case SYS_SCHEMA: {
                return HugeType.SYS_SCHEMA;
            }
        }
        throw new AssertionError((Object)String.format("Query type of index label is either '%s' or '%s', but '%s' is used", HugeType.VERTEX_LABEL, HugeType.EDGE_LABEL, this.baseType));
    }

    public List<Id> indexFields() {
        return Collections.unmodifiableList(this.indexFields);
    }

    public void indexFields(Id ... ids) {
        this.indexFields.addAll(Arrays.asList(ids));
    }

    public void indexField(Id id) {
        this.indexFields.add(id);
    }

    public Id indexField() {
        E.checkState((this.indexFields.size() == 1 ? 1 : 0) != 0, (String)"There should be only one field in %s index label, but got: %s", (Object[])new Object[]{this.indexType.string(), this.indexFields});
        return this.indexFields.get(0);
    }

    public SchemaLabel baseLabel() {
        return IndexLabel.getBaseLabel(this.graph, this.baseType, this.baseValue);
    }

    public boolean hasSameContent(IndexLabel other) {
        return super.hasSameContent(other) && this.indexType == other.indexType && this.baseType == other.baseType && Objects.equal(this.graph.mapPkId2Name(this.indexFields), other.graph.mapPkId2Name(other.indexFields));
    }

    public boolean olap() {
        return VertexLabel.OLAP_VL.id().equals(this.baseValue);
    }

    public Object validValue(Object value) {
        if (!(value instanceof Number)) {
            return value;
        }
        Number number = (Number)value;
        switch (this.indexType()) {
            case RANGE_INT: {
                return number.intValue();
            }
            case RANGE_LONG: {
                return number.longValue();
            }
            case RANGE_FLOAT: {
                return Float.valueOf(number.floatValue());
            }
            case RANGE_DOUBLE: {
                return number.doubleValue();
            }
        }
        return value;
    }

    public static IndexLabel label(HugeType type) {
        switch (type) {
            case VERTEX: {
                return VL_IL;
            }
            case EDGE: 
            case EDGE_OUT: 
            case EDGE_IN: {
                return EL_IL;
            }
            case PROPERTY_KEY: {
                return PKN_IL;
            }
            case VERTEX_LABEL: {
                return VLN_IL;
            }
            case EDGE_LABEL: {
                return ELN_IL;
            }
            case INDEX_LABEL: {
                return ILN_IL;
            }
        }
        throw new AssertionError((Object)String.format("No primitive index label for '%s'", type));
    }

    public static IndexLabel label(HugeGraph graph, Id id) {
        if (id.asLong() < 0L && id.asLong() > -8L) {
            switch ((int)id.asLong()) {
                case -1: {
                    return VL_IL;
                }
                case -2: {
                    return EL_IL;
                }
                case -3: {
                    return PKN_IL;
                }
                case -4: {
                    return VLN_IL;
                }
                case -5: {
                    return ELN_IL;
                }
                case -6: {
                    return ILN_IL;
                }
            }
            throw new AssertionError((Object)String.format("No primitive index label for '%s'", id));
        }
        return graph.indexLabel(id);
    }

    public static SchemaLabel getBaseLabel(HugeGraph graph, HugeType baseType, Object baseValue) {
        SchemaLabel label;
        E.checkNotNull((Object)baseType, (String)"base type", (String)"index label");
        E.checkNotNull((Object)baseValue, (String)"base value", (String)"index label");
        E.checkArgument((baseValue instanceof String || baseValue instanceof Id ? 1 : 0) != 0, (String)"The base value must be instance of String or Id, but got %s(%s)", (Object[])new Object[]{baseValue, baseValue.getClass().getSimpleName()});
        switch (baseType) {
            case VERTEX_LABEL: {
                if (baseValue instanceof String) {
                    label = graph.vertexLabel((String)baseValue);
                    break;
                }
                assert (baseValue instanceof Id);
                label = graph.vertexLabel((Id)baseValue);
                break;
            }
            case EDGE_LABEL: {
                if (baseValue instanceof String) {
                    label = graph.edgeLabel((String)baseValue);
                    break;
                }
                assert (baseValue instanceof Id);
                label = graph.edgeLabel((Id)baseValue);
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unsupported base type '%s' of index label", baseType));
            }
        }
        E.checkArgumentNotNull((Object)label, (String)"Can't find the %s with name '%s'", (Object[])new Object[]{baseType.readableName(), baseValue});
        return label;
    }

    public static interface Builder
    extends SchemaBuilder<IndexLabel> {
        public SchemaElement.TaskWithSchema createWithTask();

        public Id rebuild();

        public Builder onV(String var1);

        public Builder onE(String var1);

        public Builder by(String ... var1);

        public Builder secondary();

        public Builder range();

        public Builder search();

        public Builder shard();

        public Builder unique();

        public Builder on(HugeType var1, String var2);

        public Builder indexType(IndexType var1);

        public Builder userdata(String var1, Object var2);

        public Builder userdata(Map<String, Object> var1);

        public Builder rebuild(boolean var1);
    }
}

