/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.schema;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.schema.SchemaLabel;
import org.apache.hugegraph.schema.builder.SchemaBuilder;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.IdStrategy;

public class VertexLabel
extends SchemaLabel {
    public static final VertexLabel NONE = new VertexLabel(null, NONE_ID, "~undefined");
    private static final Id OLAP_VL_ID = IdGenerator.of(-7L);
    private static final String OLAP_VL_NAME = "*olap";
    public static final VertexLabel OLAP_VL = new VertexLabel(null, OLAP_VL_ID, "*olap");
    private IdStrategy idStrategy = IdStrategy.DEFAULT;
    private List<Id> primaryKeys = new ArrayList<Id>();

    public VertexLabel(HugeGraph graph, Id id, String name) {
        super(graph, id, name);
    }

    @Override
    public HugeType type() {
        return HugeType.VERTEX_LABEL;
    }

    public boolean olap() {
        return OLAP_VL.id().equals(this.id());
    }

    public IdStrategy idStrategy() {
        return this.idStrategy;
    }

    public void idStrategy(IdStrategy idStrategy) {
        this.idStrategy = idStrategy;
    }

    public List<Id> primaryKeys() {
        return Collections.unmodifiableList(this.primaryKeys);
    }

    public void primaryKey(Id id) {
        this.primaryKeys.add(id);
    }

    public void primaryKeys(Id ... ids) {
        this.primaryKeys.addAll(Arrays.asList(ids));
    }

    public boolean existsLinkLabel() {
        return this.graph().existsLinkLabel(this.id());
    }

    public boolean hasSameContent(VertexLabel other) {
        return super.hasSameContent(other) && this.idStrategy == other.idStrategy && Objects.equal(this.graph.mapPkId2Name(this.primaryKeys), other.graph.mapPkId2Name(other.primaryKeys));
    }

    public static VertexLabel undefined(HugeGraph graph) {
        return new VertexLabel(graph, NONE_ID, "~undefined");
    }

    public static VertexLabel undefined(HugeGraph graph, Id id) {
        return new VertexLabel(graph, id, "~undefined");
    }

    public static interface Builder
    extends SchemaBuilder<VertexLabel> {
        public Id rebuildIndex();

        public Builder idStrategy(IdStrategy var1);

        public Builder useAutomaticId();

        public Builder usePrimaryKeyId();

        public Builder useCustomizeStringId();

        public Builder useCustomizeNumberId();

        public Builder useCustomizeUuidId();

        public Builder properties(String ... var1);

        public Builder primaryKeys(String ... var1);

        public Builder nullableKeys(String ... var1);

        public Builder ttl(long var1);

        public Builder ttlStartTime(String var1);

        public Builder enableLabelIndex(boolean var1);

        public Builder userdata(String var1, Object var2);

        public Builder userdata(Map<String, Object> var1);
    }
}

