/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.mutable.MutableLong;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.query.QueryResults;
import org.apache.hugegraph.iterator.FilterIterator;
import org.apache.hugegraph.iterator.FlatMapperIterator;
import org.apache.hugegraph.structure.HugeEdge;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.steps.EdgeStep;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.structure.Edge;

public class CountTraverser
extends HugeTraverser {
    private boolean containsTraversed = false;
    private long dedupSize = 1000000L;
    private final Set<Id> dedupSet = CountTraverser.newIdSet();
    private final MutableLong count = new MutableLong(0L);

    public CountTraverser(HugeGraph graph) {
        super(graph);
    }

    public long count(Id source, List<EdgeStep> steps, boolean containsTraversed, long dedupSize) {
        E.checkNotNull((Object)source, (String)"source vertex id");
        this.checkVertexExist(source, "source vertex");
        E.checkArgument((steps != null && !steps.isEmpty() ? 1 : 0) != 0, (String)"The steps can't be empty", (Object[])new Object[0]);
        this.checkDedupSize(dedupSize);
        this.containsTraversed = containsTraversed;
        this.dedupSize = dedupSize;
        if (this.containsTraversed) {
            this.count.increment();
        }
        int stepNum = steps.size();
        EdgeStep firstStep = steps.get(0);
        if (stepNum == 1) {
            long edgesCount = this.edgesCount(source, firstStep);
            this.count.add(edgesCount);
            return this.count.longValue();
        }
        FlatMapperIterator edges = this.edgesOfVertexWithCount(source, firstStep);
        for (int i = 1; i < stepNum - 1; ++i) {
            EdgeStep currentStep = steps.get(i);
            edges = new FlatMapperIterator(edges, edge -> {
                Id target = ((HugeEdge)edge).id().otherVertexId();
                return this.edgesOfVertexWithCount(target, currentStep);
            });
        }
        EdgeStep lastStep = steps.get(stepNum - 1);
        while (edges.hasNext()) {
            Id target = ((HugeEdge)edges.next()).id().otherVertexId();
            if (this.dedup(target)) continue;
            long edgesCount = this.edgesCount(target, lastStep);
            this.count.add(edgesCount);
        }
        return this.count.longValue();
    }

    private Iterator<Edge> edgesOfVertexWithCount(Id source, EdgeStep step) {
        if (this.dedup(source)) {
            return QueryResults.emptyIterator();
        }
        Iterator<Edge> flatten = this.edgesOfVertex(source, step);
        return new FilterIterator(flatten, e -> {
            if (this.containsTraversed) {
                this.count.increment();
            }
            return true;
        });
    }

    private void checkDedupSize(long dedup) {
        CountTraverser.checkNonNegativeOrNoLimit(dedup, "dedup size");
    }

    private boolean dedup(Id vertex) {
        if (!this.needDedup()) {
            return false;
        }
        if (this.dedupSet.contains(vertex)) {
            return true;
        }
        if (!this.reachDedup()) {
            this.dedupSet.add(vertex);
        }
        return false;
    }

    private boolean needDedup() {
        return this.dedupSize != 0L;
    }

    private boolean reachDedup() {
        return this.dedupSize != -1L && (long)this.dedupSet.size() >= this.dedupSize;
    }
}

