/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.structure.HugeEdge;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.steps.WeightedEdgeStep;
import org.apache.hugegraph.util.CollectionUtil;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class CustomizePathsTraverser
extends HugeTraverser {
    public CustomizePathsTraverser(HugeGraph graph) {
        super(graph);
    }

    public List<HugeTraverser.Path> customizedPaths(Iterator<Vertex> vertices, List<WeightedEdgeStep> steps, boolean sorted, long capacity, long limit) {
        E.checkArgument((boolean)vertices.hasNext(), (String)"The source vertices can't be empty", (Object[])new Object[0]);
        E.checkArgument((!steps.isEmpty() ? 1 : 0) != 0, (String)"The steps can't be empty", (Object[])new Object[0]);
        CustomizePathsTraverser.checkCapacity(capacity);
        CustomizePathsTraverser.checkLimit(limit);
        MultivaluedMap sources = CustomizePathsTraverser.newMultivalueMap();
        while (vertices.hasNext()) {
            HugeVertex vertex = (HugeVertex)vertices.next();
            HugeTraverser.Node node = sorted ? new WeightNode(vertex.id(), null, 0.0) : new HugeTraverser.Node(vertex.id(), null);
            sources.add((Object)vertex.id(), (Object)node);
        }
        int stepNum = steps.size();
        int pathCount = 0;
        long access = 0L;
        MultivaluedMap newVertices = null;
        block1: for (WeightedEdgeStep step : steps) {
            --stepNum;
            newVertices = CustomizePathsTraverser.newMultivalueMap();
            for (Map.Entry entry : sources.entrySet()) {
                List<HugeTraverser.Node> adjacency = CustomizePathsTraverser.newList();
                Iterator<Edge> edges = this.edgesOfVertex((Id)entry.getKey(), step.step());
                while (edges.hasNext()) {
                    HugeEdge edge = (HugeEdge)edges.next();
                    Id target = edge.id().otherVertexId();
                    for (HugeTraverser.Node n : (List)entry.getValue()) {
                        HugeTraverser.Node newNode;
                        if (n.contains(target)) continue;
                        if (sorted) {
                            double w = step.weightBy() != null ? ((Double)edge.value(step.weightBy().name())).doubleValue() : step.defaultWeight();
                            newNode = new WeightNode(target, n, w);
                        } else {
                            newNode = new HugeTraverser.Node(target, n);
                        }
                        adjacency.add(newNode);
                        CustomizePathsTraverser.checkCapacity(capacity, ++access, "customized paths");
                    }
                }
                if (step.sample() > 0L) {
                    adjacency = CustomizePathsTraverser.sample(adjacency, step.sample());
                }
                for (HugeTraverser.Node node : adjacency) {
                    newVertices.add((Object)node.id(), (Object)node);
                    if (stepNum != 0 || limit == -1L || sorted || (long)(++pathCount) < limit) continue;
                    break block1;
                }
            }
            sources = newVertices;
        }
        if (stepNum != 0) {
            return ImmutableList.of();
        }
        List<HugeTraverser.Path> paths = CustomizePathsTraverser.newList();
        for (List nodes : newVertices.values()) {
            for (HugeTraverser.Node n : nodes) {
                if (sorted) {
                    WeightNode wn = (WeightNode)n;
                    paths.add(new WeightPath(wn.path(), wn.weights()));
                    continue;
                }
                paths.add(new HugeTraverser.Path(n.path()));
            }
        }
        return paths;
    }

    public static List<HugeTraverser.Path> topNPath(List<HugeTraverser.Path> paths, boolean incr, long limit) {
        paths.sort((p1, p2) -> {
            WeightPath wp1 = (WeightPath)p1;
            WeightPath wp2 = (WeightPath)p2;
            int result = Double.compare(wp1.totalWeight(), wp2.totalWeight());
            return incr ? result : -result;
        });
        if (limit == -1L || (long)paths.size() <= limit) {
            return paths;
        }
        return paths.subList(0, (int)limit);
    }

    private static List<HugeTraverser.Node> sample(List<HugeTraverser.Node> nodes, long sample) {
        if ((long)nodes.size() <= sample) {
            return nodes;
        }
        List<HugeTraverser.Node> result = CustomizePathsTraverser.newList((int)sample);
        int size = nodes.size();
        Iterator iterator = CollectionUtil.randomSet((int)0, (int)size, (int)((int)sample)).iterator();
        while (iterator.hasNext()) {
            int random = (Integer)iterator.next();
            result.add(nodes.get(random));
        }
        return result;
    }

    public static class WeightPath
    extends HugeTraverser.Path {
        private List<Double> weights;
        private double totalWeight;

        public WeightPath(List<Id> vertices, List<Double> weights) {
            super(vertices);
            this.weights = weights;
            this.calcTotalWeight();
        }

        public WeightPath(Id crosspoint, List<Id> vertices, List<Double> weights) {
            super(crosspoint, vertices);
            this.weights = weights;
            this.calcTotalWeight();
        }

        public List<Double> weights() {
            return this.weights;
        }

        public double totalWeight() {
            return this.totalWeight;
        }

        @Override
        public void reverse() {
            super.reverse();
            Collections.reverse(this.weights);
        }

        @Override
        public Map<String, Object> toMap(boolean withCrossPoint) {
            if (withCrossPoint) {
                return ImmutableMap.of((Object)"crosspoint", (Object)this.crosspoint(), (Object)"objects", this.vertices(), (Object)"weights", this.weights());
            }
            return ImmutableMap.of((Object)"objects", this.vertices(), (Object)"weights", this.weights());
        }

        private void calcTotalWeight() {
            double sum = 0.0;
            for (double w : this.weights()) {
                sum += w;
            }
            this.totalWeight = sum;
        }
    }

    public static class WeightNode
    extends HugeTraverser.Node {
        private double weight;

        public WeightNode(Id id, HugeTraverser.Node parent, double weight) {
            super(id, parent);
            this.weight = weight;
        }

        public List<Double> weights() {
            List<Double> weights = HugeTraverser.newList();
            WeightNode current = this;
            while (current.parent() != null) {
                weights.add(current.weight);
                current = (WeightNode)current.parent();
            }
            Collections.reverse(weights);
            return weights;
        }
    }
}

