/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.query.Aggregate;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.query.QueryResults;
import org.apache.hugegraph.backend.tx.GraphTransaction;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.exception.NotFoundException;
import org.apache.hugegraph.iterator.ExtendableIterator;
import org.apache.hugegraph.iterator.FilterIterator;
import org.apache.hugegraph.iterator.LimitIterator;
import org.apache.hugegraph.iterator.MapperIterator;
import org.apache.hugegraph.perf.PerfUtil;
import org.apache.hugegraph.schema.SchemaLabel;
import org.apache.hugegraph.structure.HugeEdge;
import org.apache.hugegraph.traversal.algorithm.steps.EdgeStep;
import org.apache.hugegraph.traversal.optimize.TraversalUtil;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.CollectionType;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.util.CollectionUtil;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.apache.hugegraph.util.Log;
import org.apache.hugegraph.util.collection.CollectionFactory;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.slf4j.Logger;

public class HugeTraverser {
    protected static final Logger LOG = Log.logger(HugeTraverser.class);
    private HugeGraph graph;
    private static CollectionFactory collectionFactory;
    public static final String DEFAULT_CAPACITY = "10000000";
    public static final String DEFAULT_ELEMENTS_LIMIT = "10000000";
    public static final String DEFAULT_PATHS_LIMIT = "10";
    public static final String DEFAULT_LIMIT = "100";
    public static final String DEFAULT_MAX_DEGREE = "10000";
    public static final String DEFAULT_SKIP_DEGREE = "100000";
    public static final String DEFAULT_SAMPLE = "100";
    public static final String DEFAULT_WEIGHT = "0";
    public static final int DEFAULT_MAX_DEPTH = 5000;
    protected static final int MAX_VERTICES = 10;
    public static final String DEFAULT_PAGE_LIMIT = "100000";
    public static final long NO_LIMIT = -1L;

    public HugeTraverser(HugeGraph graph) {
        this.graph = graph;
        if (collectionFactory == null) {
            collectionFactory = new CollectionFactory(this.collectionType());
        }
    }

    public HugeGraph graph() {
        return this.graph;
    }

    protected int concurrentDepth() {
        return (Integer)this.graph.option(CoreOptions.OLTP_CONCURRENT_DEPTH);
    }

    private CollectionType collectionType() {
        return this.graph.option(CoreOptions.OLTP_COLLECTION_TYPE);
    }

    protected Set<Id> adjacentVertices(Id sourceV, Set<Id> vertices, Directions dir, Id label, Set<Id> excluded, long degree, long limit) {
        if (limit == 0L) {
            return ImmutableSet.of();
        }
        Set<Id> neighbors = HugeTraverser.newIdSet();
        for (Id source : vertices) {
            Iterator<Edge> edges = this.edgesOfVertex(source, dir, label, degree);
            while (edges.hasNext()) {
                HugeEdge e = (HugeEdge)edges.next();
                Id target = e.id().otherVertexId();
                boolean matchExcluded = excluded != null && excluded.contains(target);
                if (matchExcluded || neighbors.contains(target) || sourceV.equals(target)) continue;
                neighbors.add(target);
                if (limit == -1L || (long)neighbors.size() < limit) continue;
                return neighbors;
            }
        }
        return neighbors;
    }

    protected Iterator<Id> adjacentVertices(Id source, Directions dir, Id label, long limit) {
        Iterator<Edge> edges = this.edgesOfVertex(source, dir, label, limit);
        return new MapperIterator(edges, e -> {
            HugeEdge edge = (HugeEdge)e;
            return edge.id().otherVertexId();
        });
    }

    protected Set<Id> adjacentVertices(Id source, EdgeStep step) {
        Set<Id> neighbors = HugeTraverser.newSet();
        Iterator<Edge> edges = this.edgesOfVertex(source, step);
        while (edges.hasNext()) {
            neighbors.add(((HugeEdge)edges.next()).id().otherVertexId());
        }
        return neighbors;
    }

    @PerfUtil.Watched
    protected Iterator<Edge> edgesOfVertex(Id source, Directions dir, Id label, long limit) {
        Id[] labels = new Id[]{};
        if (label != null) {
            labels = new Id[]{label};
        }
        ConditionQuery query = GraphTransaction.constructEdgesQuery(source, dir, labels);
        if (limit != -1L) {
            query.limit(limit);
        }
        return this.graph.edges(query);
    }

    @PerfUtil.Watched
    protected Iterator<Edge> edgesOfVertex(Id source, Directions dir, Map<Id, String> labels, long limit) {
        if (labels == null || labels.isEmpty()) {
            return this.edgesOfVertex(source, dir, (Id)null, limit);
        }
        ExtendableIterator results = new ExtendableIterator();
        for (Id label : labels.keySet()) {
            E.checkNotNull((Object)label, (String)"edge label");
            results.extend(this.edgesOfVertex(source, dir, label, limit));
        }
        if (limit == -1L) {
            return results;
        }
        long[] count = new long[1];
        return new LimitIterator((Iterator)results, e -> {
            long l = count[0];
            count[0] = l + 1L;
            return l >= limit;
        });
    }

    protected Iterator<Edge> edgesOfVertex(Id source, EdgeStep edgeStep) {
        if (edgeStep.properties() == null || edgeStep.properties().isEmpty()) {
            Iterator<Edge> edges = this.edgesOfVertex(source, edgeStep.direction(), edgeStep.labels(), edgeStep.limit());
            return edgeStep.skipSuperNodeIfNeeded(edges);
        }
        return this.edgesOfVertex(source, edgeStep, false);
    }

    protected Iterator<Edge> edgesOfVertexWithSK(Id source, EdgeStep edgeStep) {
        assert (edgeStep.properties() != null && !edgeStep.properties().isEmpty());
        return this.edgesOfVertex(source, edgeStep, true);
    }

    private Iterator<Edge> edgesOfVertex(Id source, EdgeStep edgeStep, boolean mustAllSK) {
        Id[] edgeLabels = edgeStep.edgeLabels();
        ConditionQuery query = GraphTransaction.constructEdgesQuery(source, edgeStep.direction(), edgeLabels);
        ConditionQuery filter = null;
        if (mustAllSK) {
            this.fillFilterBySortKeys(query, edgeLabels, edgeStep.properties());
        } else {
            filter = (ConditionQuery)((Query)query).copy();
            this.fillFilterByProperties(filter, edgeStep.properties());
        }
        query.capacity(-1L);
        if (edgeStep.limit() != -1L) {
            query.limit(edgeStep.limit());
        }
        FilterIterator edges = this.graph().edges(query);
        if (filter != null) {
            ConditionQuery finalFilter = filter;
            edges = new FilterIterator(edges, e -> finalFilter.test((HugeEdge)e));
        }
        return edgeStep.skipSuperNodeIfNeeded((Iterator<Edge>)edges);
    }

    private void fillFilterBySortKeys(Query query, Id[] edgeLabels, Map<Id, Object> properties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        E.checkArgument((edgeLabels.length == 1 ? 1 : 0) != 0, (String)"The properties filter condition can be set only if just set one edge label", (Object[])new Object[0]);
        this.fillFilterByProperties(query, properties);
        ConditionQuery condQuery = (ConditionQuery)query;
        if (!GraphTransaction.matchFullEdgeSortKeys(condQuery, this.graph())) {
            Id label = (Id)condQuery.condition((Object)HugeKeys.LABEL);
            E.checkArgument((boolean)false, (String)"The properties %s does not match sort keys of edge label '%s'", (Object[])new Object[]{this.graph().mapPkId2Name(properties.keySet()), this.graph().edgeLabel(label).name()});
        }
    }

    private void fillFilterByProperties(Query query, Map<Id, Object> properties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        ConditionQuery condQuery = (ConditionQuery)query;
        TraversalUtil.fillConditionQuery(condQuery, properties, this.graph);
    }

    protected long edgesCount(Id source, EdgeStep edgeStep) {
        Id[] edgeLabels = edgeStep.edgeLabels();
        ConditionQuery query = GraphTransaction.constructEdgesQuery(source, edgeStep.direction(), edgeLabels);
        this.fillFilterBySortKeys(query, edgeLabels, edgeStep.properties());
        query.aggregate(Aggregate.AggregateFunc.COUNT, null);
        query.capacity(-1L);
        query.limit(Long.MAX_VALUE);
        long count = this.graph().queryNumber(query).longValue();
        if (edgeStep.degree() == -1L || count < edgeStep.degree()) {
            return count;
        }
        if (edgeStep.skipDegree() != 0L && count >= edgeStep.skipDegree()) {
            return 0L;
        }
        return edgeStep.degree();
    }

    protected Object getVertexLabelId(Object label) {
        if (label == null) {
            return null;
        }
        return SchemaLabel.getLabelId(this.graph, HugeType.VERTEX, label);
    }

    protected Id getEdgeLabelId(Object label) {
        if (label == null) {
            return null;
        }
        return SchemaLabel.getLabelId(this.graph, HugeType.EDGE, label);
    }

    protected void checkVertexExist(Id vertexId, String name) {
        try {
            this.graph.vertex(vertexId);
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException(String.format("The %s with id '%s' does not exist", name, vertexId), e);
        }
    }

    public static void checkDegree(long degree) {
        HugeTraverser.checkPositiveOrNoLimit(degree, "max degree");
    }

    public static void checkCapacity(long capacity) {
        HugeTraverser.checkPositiveOrNoLimit(capacity, "capacity");
    }

    public static void checkLimit(long limit) {
        HugeTraverser.checkPositiveOrNoLimit(limit, "limit");
    }

    public static void checkPositive(long value, String name) {
        E.checkArgument((value > 0L ? 1 : 0) != 0, (String)"The %s parameter must be > 0, but got %s", (Object[])new Object[]{name, value});
    }

    public static void checkPositiveOrNoLimit(long value, String name) {
        E.checkArgument((value > 0L || value == -1L ? 1 : 0) != 0, (String)"The %s parameter must be > 0 or == %s, but got: %s", (Object[])new Object[]{name, -1L, value});
    }

    public static void checkNonNegative(long value, String name) {
        E.checkArgument((value >= 0L ? 1 : 0) != 0, (String)"The %s parameter must be >= 0, but got: %s", (Object[])new Object[]{name, value});
    }

    public static void checkNonNegativeOrNoLimit(long value, String name) {
        E.checkArgument((value >= 0L || value == -1L ? 1 : 0) != 0, (String)"The %s parameter must be >= 0 or == %s, but got: %s", (Object[])new Object[]{name, -1L, value});
    }

    public static void checkCapacity(long capacity, long access, String traverse) {
        if (capacity != -1L && access > capacity) {
            throw new HugeException("Exceed capacity '%s' while finding %s", capacity, traverse);
        }
    }

    public static void checkSkipDegree(long skipDegree, long degree, long capacity) {
        E.checkArgument((skipDegree >= 0L && skipDegree <= 800000L ? 1 : 0) != 0, (String)"The skipped degree must be in [0, %s], but got '%s'", (Object[])new Object[]{800000L, skipDegree});
        if (capacity != -1L) {
            E.checkArgument((degree != -1L && degree < capacity ? 1 : 0) != 0, (String)"The max degree must be < capacity", (Object[])new Object[0]);
            E.checkArgument((skipDegree < capacity ? 1 : 0) != 0, (String)"The skipped degree must be < capacity", (Object[])new Object[0]);
        }
        if (skipDegree > 0L) {
            E.checkArgument((degree != -1L && skipDegree >= degree ? 1 : 0) != 0, (String)"The skipped degree must be >= max degree, but got skipped degree '%s' and max degree '%s'", (Object[])new Object[]{skipDegree, degree});
        }
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> topN(Map<K, V> map, boolean sorted, long limit) {
        if (sorted) {
            map = CollectionUtil.sortByValue(map, (boolean)false);
        }
        if (limit == -1L || (long)map.size() <= limit) {
            return map;
        }
        Map results = InsertionOrderUtil.newMap();
        long count = 0L;
        for (Map.Entry entry : map.entrySet()) {
            results.put(entry.getKey(), entry.getValue());
            if (++count < limit) continue;
            break;
        }
        return results;
    }

    public static Iterator<Edge> skipSuperNodeIfNeeded(Iterator<Edge> edges, long degree, long skipDegree) {
        if (skipDegree <= 0L) {
            return edges;
        }
        List edgeList = HugeTraverser.newList();
        int i = 1;
        while (edges.hasNext()) {
            Edge edge = edges.next();
            if ((long)i <= degree) {
                edgeList.add(edge);
            }
            if ((long)i >= skipDegree) {
                return QueryResults.emptyIterator();
            }
            ++i;
        }
        return edgeList.iterator();
    }

    protected static Set<Id> newIdSet() {
        return collectionFactory.newIdSet();
    }

    protected static <V> Set<V> newSet() {
        return HugeTraverser.newSet(false);
    }

    protected static <V> Set<V> newSet(boolean concurrent) {
        if (concurrent) {
            return ConcurrentHashMap.newKeySet();
        }
        return collectionFactory.newSet();
    }

    protected static <V> Set<V> newSet(int initialCapacity) {
        return collectionFactory.newSet(initialCapacity);
    }

    protected static <V> Set<V> newSet(Collection<V> collection) {
        return collectionFactory.newSet(collection);
    }

    protected static <V> List<V> newList() {
        return collectionFactory.newList();
    }

    protected static <V> List<V> newList(int initialCapacity) {
        return collectionFactory.newList(initialCapacity);
    }

    protected static <V> List<V> newList(Collection<V> collection) {
        return collectionFactory.newList(collection);
    }

    protected static <K, V> Map<K, V> newMap() {
        return collectionFactory.newMap();
    }

    protected static <K, V> Map<K, V> newMap(int initialCapacity) {
        return collectionFactory.newMap(initialCapacity);
    }

    protected static <K, V> MultivaluedMap<K, V> newMultivalueMap() {
        return new MultivaluedHashMap();
    }

    protected static List<Id> joinPath(Node prev, Node back, boolean ring) {
        List<Id> path = prev.path();
        List<Id> backPath = back.path();
        Collections.reverse(backPath);
        if (!ring && CollectionUtils.containsAny(path, backPath)) {
            return ImmutableList.of();
        }
        path.addAll(backPath);
        return path;
    }

    public static class PathSet
    implements Set<Path> {
        public static final PathSet EMPTY = new PathSet((Set<Path>)ImmutableSet.of());
        private final Set<Path> paths;

        public PathSet() {
            this(HugeTraverser.newSet());
        }

        private PathSet(Set<Path> paths) {
            this.paths = paths;
        }

        @Override
        public boolean add(Path path) {
            return this.paths.add(path);
        }

        @Override
        public boolean remove(Object o) {
            return this.paths.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.paths.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends Path> c) {
            return this.paths.addAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.paths.retainAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.paths.removeAll(c);
        }

        @Override
        public void clear() {
            this.paths.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.paths.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.paths.contains(o);
        }

        @Override
        public int size() {
            return this.paths.size();
        }

        @Override
        public Iterator<Path> iterator() {
            return this.paths.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.paths.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.paths.toArray(a);
        }

        public boolean addAll(PathSet paths) {
            return this.paths.addAll(paths.paths);
        }

        public Set<Id> vertices() {
            Set<Id> vertices = HugeTraverser.newIdSet();
            for (Path path : this.paths) {
                vertices.addAll(path.vertices());
            }
            return vertices;
        }

        public String toString() {
            return this.paths.toString();
        }

        public void append(Id current) {
            Iterator<Path> iter = this.paths.iterator();
            while (iter.hasNext()) {
                Path path = iter.next();
                if (path.vertices().contains(current)) {
                    iter.remove();
                    continue;
                }
                path.addToLast(current);
            }
        }
    }

    public static class Path {
        public static final Path EMPTY = new Path((List<Id>)ImmutableList.of());
        private final Id crosspoint;
        private final List<Id> vertices;

        public Path(List<Id> vertices) {
            this(null, vertices);
        }

        public Path(Id crosspoint, List<Id> vertices) {
            this.crosspoint = crosspoint;
            this.vertices = vertices;
        }

        public Id crosspoint() {
            return this.crosspoint;
        }

        public void addToLast(Id id) {
            this.vertices.add(id);
        }

        public List<Id> vertices() {
            return this.vertices;
        }

        public void reverse() {
            Collections.reverse(this.vertices);
        }

        public Map<String, Object> toMap(boolean withCrossPoint) {
            if (withCrossPoint) {
                return ImmutableMap.of((Object)"crosspoint", (Object)this.crosspoint, (Object)"objects", this.vertices);
            }
            return ImmutableMap.of((Object)"objects", this.vertices);
        }

        public boolean ownedBy(Id source) {
            E.checkNotNull((Object)source, (String)"source");
            Id min = null;
            for (Id id : this.vertices) {
                if (min != null && id.compareTo(min) >= 0) continue;
                min = id;
            }
            return source.equals(min);
        }

        public int hashCode() {
            return this.vertices.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof Path)) {
                return false;
            }
            return this.vertices.equals(((Path)other).vertices);
        }

        public String toString() {
            return this.vertices.toString();
        }
    }

    public static class Node {
        private final Id id;
        private final Node parent;

        public Node(Id id) {
            this(id, null);
        }

        public Node(Id id, Node parent) {
            E.checkArgumentNotNull((Object)id, (String)"Id of Node can't be null", (Object[])new Object[0]);
            this.id = id;
            this.parent = parent;
        }

        public Id id() {
            return this.id;
        }

        public Node parent() {
            return this.parent;
        }

        public List<Id> path() {
            List<Id> ids = HugeTraverser.newList();
            Node current = this;
            do {
                ids.add(current.id);
            } while ((current = current.parent) != null);
            Collections.reverse(ids);
            return ids;
        }

        public List<Id> joinPath(Node back) {
            return HugeTraverser.joinPath(this, back, false);
        }

        public boolean contains(Id id) {
            Node node = this;
            do {
                if (!node.id.equals(id)) continue;
                return true;
            } while ((node = node.parent) != null);
            return false;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Node)) {
                return false;
            }
            Node other = (Node)object;
            return Objects.equals(this.id, other.id) && Objects.equals(this.parent, other.parent);
        }

        public String toString() {
            return this.id.toString();
        }
    }
}

