/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util.collection;

import com.carrotsearch.hppc.BitSet;
import io.netty.util.internal.shaded.org.jctools.util.UnsafeAccess;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.hugegraph.util.E;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import sun.misc.Unsafe;

public interface IntSet {
    public static final int CPUS = Runtime.getRuntime().availableProcessors();
    public static final Unsafe UNSAFE = UnsafeAccess.UNSAFE;
    public static final long MOD64 = 63L;
    public static final int DIV64 = 6;

    public boolean add(int var1);

    public boolean remove(int var1);

    public boolean contains(int var1);

    public void clear();

    public int size();

    public boolean concurrent();

    public static int segmentSize(long capacity, int segments) {
        long eachSize = capacity / (long)segments;
        eachSize = IntSet.sizeToPowerOf2Size((int)eachSize);
        while (eachSize * (long)segments < capacity) {
            eachSize <<= 1;
        }
        return (int)eachSize;
    }

    public static int sizeToPowerOf2Size(int size) {
        if (size < 1) {
            size = 1;
        }
        int n = size - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        size = n + 1;
        return size;
    }

    public static int bits2words(long numBits) {
        return (int)(numBits - 1L >>> 6) + 1;
    }

    public static final class IntSetByFixedAddrByHppc
    implements IntSet {
        private final BitSet bits;

        public IntSetByFixedAddrByHppc(int numBits) {
            this.bits = new BitSet((long)numBits);
        }

        @Override
        public boolean add(int key) {
            this.bits.set((long)key);
            return true;
        }

        @Override
        public boolean remove(int key) {
            this.bits.clear((long)key);
            return true;
        }

        @Override
        public boolean contains(int key) {
            return this.bits.get(key);
        }

        @Override
        public void clear() {
            this.bits.clear();
        }

        @Override
        public int size() {
            return (int)this.bits.size();
        }

        @Override
        public boolean concurrent() {
            return false;
        }
    }

    public static final class IntSetByEcSegment
    implements IntSet {
        private final MutableIntCollection[] sets;
        private final int segmentMask;

        public IntSetByEcSegment(int segments) {
            segments = IntSet.sizeToPowerOf2Size(segments);
            this.segmentMask = segments - 1;
            this.sets = new MutableIntCollection[segments];
            for (int i = 0; i < segments; ++i) {
                this.sets[i] = new IntHashSet().asSynchronized();
            }
        }

        private MutableIntCollection set(int key) {
            int index = key & this.segmentMask;
            return this.sets[index];
        }

        @Override
        public boolean add(int key) {
            return this.set(key).add(key);
        }

        @Override
        public boolean contains(int key) {
            return this.set(key).contains(key);
        }

        @Override
        public boolean remove(int key) {
            return this.set(key).remove(key);
        }

        @Override
        public void clear() {
            for (MutableIntCollection set : this.sets) {
                set.clear();
            }
        }

        @Override
        public int size() {
            int size = 0;
            for (MutableIntCollection set : this.sets) {
                size += set.size();
            }
            return size;
        }

        @Override
        public boolean concurrent() {
            return false;
        }
    }

    public static final class IntSetByFixedAddr4Unsigned
    implements IntSet {
        private final long[] bits;
        private final int numBits;
        private final AtomicInteger size;
        private static final int BASE_OFFSET = Unsafe.ARRAY_LONG_BASE_OFFSET;
        private static final int MUL8 = 31 - Integer.numberOfLeadingZeros(Unsafe.ARRAY_LONG_INDEX_SCALE);

        public IntSetByFixedAddr4Unsigned(int numBits) {
            this.numBits = numBits;
            this.bits = new long[IntSet.bits2words(numBits)];
            this.size = new AtomicInteger();
        }

        @Override
        public boolean add(int key) {
            long newV;
            long oldV;
            long offset = this.offset(key);
            long bitmask = IntSetByFixedAddr4Unsigned.bitmaskOfKey(key);
            do {
                if ((newV = (oldV = UNSAFE.getLongVolatile(this.bits, offset)) | bitmask) != oldV) continue;
                return false;
            } while (!UNSAFE.compareAndSwapLong(this.bits, offset, oldV, newV));
            this.size.incrementAndGet();
            return true;
        }

        @Override
        public boolean contains(int key) {
            if (key >= this.numBits || key < 0) {
                return false;
            }
            long offset = this.offset(key);
            long bitmask = IntSetByFixedAddr4Unsigned.bitmaskOfKey(key);
            long value = UNSAFE.getLongVolatile(this.bits, offset);
            return (value & bitmask) != 0L;
        }

        @Override
        public boolean remove(int key) {
            long newV;
            long oldV;
            long offset = this.offset(key);
            long bitmask = IntSetByFixedAddr4Unsigned.bitmaskOfKey(key);
            do {
                if ((newV = (oldV = UNSAFE.getLongVolatile(this.bits, offset)) & (bitmask ^ 0xFFFFFFFFFFFFFFFFL)) != oldV) continue;
                return false;
            } while (!UNSAFE.compareAndSwapLong(this.bits, offset, oldV, newV));
            this.size.decrementAndGet();
            return true;
        }

        @Override
        public void clear() {
            Arrays.fill(this.bits, 0L);
            this.size.set(0);
        }

        @Override
        public int size() {
            return this.size.get();
        }

        @Override
        public boolean concurrent() {
            return true;
        }

        public int nextKey(int key) {
            long bitmask;
            int bit;
            if (key < 0) {
                key = 0;
            }
            if (key >= this.numBits) {
                return key;
            }
            long offset = this.offset(key);
            int startBit = key & 0x3F;
            int bitsEachLong = 64;
            int bytesEachLong = 8;
            key -= startBit;
            long value = UNSAFE.getLongVolatile(this.bits, offset);
            if (value != 0L) {
                for (bit = startBit; bit < bitsEachLong; ++bit) {
                    bitmask = 1L << bit;
                    if ((value & bitmask) == 0L) continue;
                    return key + bit;
                }
            }
            offset += (long)bytesEachLong;
            key += bitsEachLong;
            while (key < this.numBits) {
                value = UNSAFE.getLongVolatile(this.bits, offset);
                if (value != 0L) {
                    for (bit = 0; bit < bitsEachLong; ++bit) {
                        bitmask = 1L << bit;
                        if ((value & bitmask) == 0L) continue;
                        return key + bit;
                    }
                }
                offset += (long)bytesEachLong;
                key += bitsEachLong;
            }
            return key;
        }

        private long offset(int key) {
            if (key >= this.numBits || key < 0) {
                E.checkArgument((boolean)false, (String)"The key %s is out of bound %s", (Object[])new Object[]{key, this.numBits});
            }
            return IntSetByFixedAddr4Unsigned.bitOffsetToByteOffset(key);
        }

        private static long bitOffsetToByteOffset(long key) {
            long index = key >> 6;
            long offset = index << MUL8;
            return offset += (long)BASE_OFFSET;
        }

        private static long bitmaskOfKey(long key) {
            long bitIndex = key & 0x3FL;
            long bitmask = 1L << (int)bitIndex;
            return bitmask;
        }
    }

    public static final class IntSetByFixedAddr
    implements IntSet {
        private final long[] bits;
        private final long numBits;
        private final long numBitsUnsigned;
        private final AtomicInteger size;

        public IntSetByFixedAddr(int numBits) {
            this.numBitsUnsigned = numBits;
            this.numBits = (long)numBits * 2L;
            this.bits = new long[IntSet.bits2words(this.numBits)];
            this.size = new AtomicInteger();
        }

        @Override
        public boolean add(int key) {
            long newV;
            long oldV;
            long ukey = (long)key + this.numBitsUnsigned;
            long offset = this.offset(key);
            long bitmask = IntSetByFixedAddr4Unsigned.bitmaskOfKey(ukey);
            do {
                if ((newV = (oldV = UNSAFE.getLongVolatile(this.bits, offset)) | bitmask) != oldV) continue;
                return false;
            } while (!UNSAFE.compareAndSwapLong(this.bits, offset, oldV, newV));
            this.size.incrementAndGet();
            return true;
        }

        @Override
        public boolean contains(int key) {
            long ukey = (long)key + this.numBitsUnsigned;
            if (ukey >= this.numBits || ukey < 0L) {
                return false;
            }
            long offset = this.offset(key);
            long bitmask = IntSetByFixedAddr4Unsigned.bitmaskOfKey(ukey);
            long value = UNSAFE.getLongVolatile(this.bits, offset);
            return (value & bitmask) != 0L;
        }

        @Override
        public boolean remove(int key) {
            long newV;
            long oldV;
            long ukey = (long)key + this.numBitsUnsigned;
            long offset = this.offset(key);
            long bitmask = IntSetByFixedAddr4Unsigned.bitmaskOfKey(ukey);
            do {
                if ((newV = (oldV = UNSAFE.getLongVolatile(this.bits, offset)) & (bitmask ^ 0xFFFFFFFFFFFFFFFFL)) != oldV) continue;
                return false;
            } while (!UNSAFE.compareAndSwapLong(this.bits, offset, oldV, newV));
            this.size.decrementAndGet();
            return true;
        }

        @Override
        public void clear() {
            Arrays.fill(this.bits, 0L);
            this.size.set(0);
        }

        @Override
        public int size() {
            return this.size.get();
        }

        @Override
        public boolean concurrent() {
            return true;
        }

        private long offset(long key) {
            long ukey = key + this.numBitsUnsigned;
            if (ukey >= this.numBits || ukey < 0L) {
                E.checkArgument((boolean)false, (String)"The key %s is out of bound %s", (Object[])new Object[]{key, this.numBits});
            }
            return IntSetByFixedAddr4Unsigned.bitOffsetToByteOffset(ukey);
        }
    }

    public static final class IntSetBySegments
    implements IntSet {
        private final IntSet[] sets;
        private final long capacity;
        private final long unsignedSize;
        private final int segmentSize;
        private final int segmentShift;
        private final int segmentMask;
        private final Function<Integer, IntSet> creator;
        private static final int DEFAULT_SEGMENTS = CPUS * 100;
        private static final Function<Integer, IntSet> DEFAULT_CREATOR = size -> new IntSetByFixedAddr4Unsigned((int)size);
        private static final int BASE_OFFSET = Unsafe.ARRAY_OBJECT_BASE_OFFSET;
        private static final int SHIFT = 31 - Integer.numberOfLeadingZeros(Unsafe.ARRAY_OBJECT_INDEX_SCALE);

        public IntSetBySegments(int capacity) {
            this(capacity, DEFAULT_SEGMENTS, DEFAULT_CREATOR);
        }

        public IntSetBySegments(int capacity, int segments) {
            this(capacity, segments, DEFAULT_CREATOR);
        }

        public IntSetBySegments(int capacity, int segments, Function<Integer, IntSet> creator) {
            E.checkArgument((segments >= 1 ? 1 : 0) != 0, (String)"Invalid segments %s", (Object[])new Object[]{segments});
            E.checkArgument((capacity >= segments ? 1 : 0) != 0, (String)"Invalid capacity %s, expect >= segments %s", (Object[])new Object[]{capacity, segments});
            this.sets = new IntSet[segments];
            this.unsignedSize = capacity;
            this.capacity = this.unsignedSize * 2L;
            this.segmentSize = IntSet.segmentSize(this.capacity, segments);
            this.segmentShift = Integer.numberOfTrailingZeros(this.segmentSize);
            this.segmentMask = this.segmentShift == 0 ? 0 : -1 >>> 32 - this.segmentShift;
            this.creator = creator;
        }

        @Override
        public boolean add(int key) {
            int innerKey = (int)((long)key + this.unsignedSize & (long)this.segmentMask);
            return this.segment(key).add(innerKey);
        }

        @Override
        public boolean remove(int key) {
            int innerKey = (int)((long)key + this.unsignedSize & (long)this.segmentMask);
            return this.segment(key).remove(innerKey);
        }

        @Override
        public boolean contains(int key) {
            long ukey = (long)key + this.unsignedSize;
            if (ukey >= this.capacity || ukey < 0L) {
                return false;
            }
            int innerKey = (int)(ukey & (long)this.segmentMask);
            return this.segment(key).contains(innerKey);
        }

        @Override
        public void clear() {
            for (int i = 0; i < this.sets.length; ++i) {
                IntSet set = this.segmentAt(i);
                if (set == null) continue;
                set.clear();
            }
        }

        @Override
        public int size() {
            int size = 0;
            for (int i = 0; i < this.sets.length; ++i) {
                IntSet set = this.segmentAt(i);
                if (set == null) continue;
                size += set.size();
            }
            return size;
        }

        @Override
        public boolean concurrent() {
            return true;
        }

        private IntSet segment(int key) {
            long index;
            IntSet exist;
            long ukey = (long)key + this.unsignedSize;
            if (ukey >= this.capacity || ukey < 0L) {
                E.checkArgument((boolean)false, (String)"The key %s is out of bound %s", (Object[])new Object[]{key, this.capacity});
            }
            if ((exist = this.sets[(int)(index = ukey >>> this.segmentShift)]) != null) {
                return exist;
            }
            long offset = (index << SHIFT) + (long)BASE_OFFSET;
            Object old = UNSAFE.getObjectVolatile(this.sets, offset);
            if (old != null) {
                return (IntSet)old;
            }
            IntSet set = this.creator.apply(this.segmentSize);
            do {
                if (!UNSAFE.compareAndSwapObject(this.sets, offset, null, set)) continue;
                return set;
            } while ((old = UNSAFE.getObjectVolatile(this.sets, offset)) == null);
            return (IntSet)old;
        }

        private IntSet segmentAt(int index) {
            long offset = (index << SHIFT) + BASE_OFFSET;
            IntSet set = (IntSet)UNSAFE.getObjectVolatile(this.sets, offset);
            return set;
        }
    }
}

