/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util.collection;

import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.perf.PerfUtil;
import org.apache.hugegraph.util.collection.ObjectIntMapping;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;

public class ObjectIntMappingFactory {
    public static <V> ObjectIntMapping<V> newObjectIntMapping() {
        return ObjectIntMappingFactory.newObjectIntMapping(false);
    }

    public static <V> ObjectIntMapping<V> newObjectIntMapping(boolean concurrent) {
        return concurrent ? new ConcurrentObjectIntMapping() : new SingleThreadObjectIntMapping();
    }

    public static final class ConcurrentObjectIntMapping<V>
    implements ObjectIntMapping<V> {
        private final SingleThreadObjectIntMapping<V> objectIntMapping = new SingleThreadObjectIntMapping();

        @Override
        @PerfUtil.Watched
        public synchronized int object2Code(Object object) {
            return this.objectIntMapping.object2Code(object);
        }

        @Override
        @PerfUtil.Watched
        public synchronized V code2Object(int code) {
            return this.objectIntMapping.code2Object(code);
        }

        @Override
        public synchronized void clear() {
            this.objectIntMapping.clear();
        }

        public synchronized String toString() {
            return this.objectIntMapping.toString();
        }
    }

    public static final class SingleThreadObjectIntMapping<V>
    implements ObjectIntMapping<V> {
        private static final int MAGIC = 65536;
        private static final int MAX_OFFSET = 10;
        private final IntObjectHashMap<V> int2IdMap = new IntObjectHashMap();

        @Override
        @PerfUtil.Watched
        public int object2Code(Object object) {
            int code = object.hashCode();
            block0: for (int i = 1; i > 0; i <<= 1) {
                for (int j = 0; j < 10; ++j) {
                    if (code <= 0) {
                        code = code == 0 ? 1 : -code;
                    }
                    assert (code > 0);
                    Object existed = this.int2IdMap.get(code);
                    if (existed == null) {
                        this.int2IdMap.put(code, object);
                        return code;
                    }
                    if (existed.equals(object)) {
                        return code;
                    }
                    code = code + i + j;
                    if (i < 65536) continue block0;
                }
            }
            throw new HugeException("Failed to get code for object: %s", object);
        }

        @Override
        @PerfUtil.Watched
        public V code2Object(int code) {
            assert (code > 0);
            return (V)this.int2IdMap.get(code);
        }

        @Override
        public void clear() {
            this.int2IdMap.clear();
        }

        public String toString() {
            return this.int2IdMap.toString();
        }
    }
}

