/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.rocksdb;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.hugegraph.config.ConfigConvOption;
import org.apache.hugegraph.config.ConfigListConvOption;
import org.apache.hugegraph.config.ConfigListOption;
import org.apache.hugegraph.config.ConfigOption;
import org.apache.hugegraph.config.OptionChecker;
import org.apache.hugegraph.config.OptionHolder;
import org.rocksdb.CompactionStyle;
import org.rocksdb.CompressionType;
import org.rocksdb.DataBlockIndexType;
import org.rocksdb.IndexType;

public class RocksDBOptions
extends OptionHolder {
    private static volatile RocksDBOptions instance;
    public static final ConfigOption<String> DATA_PATH;
    public static final ConfigListOption<String> DATA_DISKS;
    public static final ConfigOption<String> WAL_PATH;
    public static final ConfigOption<String> SST_PATH;
    public static final ConfigOption<String> LOG_LEVEL;
    public static final ConfigOption<Integer> NUM_LEVELS;
    public static final ConfigConvOption<String, CompactionStyle> COMPACTION_STYLE;
    public static final ConfigOption<Boolean> OPTIMIZE_MODE;
    public static final ConfigOption<Boolean> BULKLOAD_MODE;
    public static final ConfigListConvOption<String, CompressionType> LEVELS_COMPRESSIONS;
    public static final ConfigConvOption<String, CompressionType> BOTTOMMOST_COMPRESSION;
    public static final ConfigConvOption<String, CompressionType> COMPRESSION;
    public static final ConfigOption<Integer> MAX_BG_JOBS;
    public static final ConfigOption<Integer> MAX_SUB_COMPACTIONS;
    public static final ConfigOption<Long> DELAYED_WRITE_RATE;
    public static final ConfigOption<Integer> MAX_OPEN_FILES;
    public static final ConfigOption<Long> MAX_MANIFEST_FILE_SIZE;
    public static final ConfigOption<Boolean> SKIP_STATS_UPDATE_ON_DB_OPEN;
    public static final ConfigOption<Boolean> SKIP_CHECK_SIZE_ON_DB_OPEN;
    public static final ConfigOption<Integer> MAX_FILE_OPENING_THREADS;
    public static final ConfigOption<Long> MAX_TOTAL_WAL_SIZE;
    public static final ConfigOption<Long> BYTES_PER_SYNC;
    public static final ConfigOption<Long> WAL_BYTES_PER_SYNC;
    public static final ConfigOption<Boolean> STRICT_BYTES_PER_SYNC;
    public static final ConfigOption<Long> DB_MEMTABLE_SIZE;
    public static final ConfigOption<Long> LOG_READAHEAD_SIZE;
    public static final ConfigOption<Long> COMPACTION_READAHEAD_SIZE;
    public static final ConfigOption<Long> ROW_CACHE_CAPACITY;
    public static final ConfigOption<Long> DELETE_OBSOLETE_FILE_PERIOD;
    public static final ConfigOption<Long> MEMTABLE_SIZE;
    public static final ConfigOption<Integer> MAX_MEMTABLES;
    public static final ConfigOption<Integer> MIN_MEMTABLES_TO_MERGE;
    public static final ConfigOption<Integer> MAX_MEMTABLES_TO_MAINTAIN;
    public static final ConfigOption<Double> MEMTABLE_BLOOM_SIZE_RATIO;
    public static final ConfigOption<Boolean> MEMTABLE_BLOOM_WHOLE_KEY_FILTERING;
    public static final ConfigOption<Long> MEMTABL_BLOOM_HUGE_PAGE_SIZE;
    public static final ConfigOption<Boolean> MEMTABLE_INPLACE_UPDATE_SUPPORT;
    public static final ConfigOption<Boolean> DYNAMIC_LEVEL_BYTES;
    public static final ConfigOption<Long> MAX_LEVEL1_BYTES;
    public static final ConfigOption<Double> MAX_LEVEL_BYTES_MULTIPLIER;
    public static final ConfigOption<Long> TARGET_FILE_SIZE_BASE;
    public static final ConfigOption<Integer> TARGET_FILE_SIZE_MULTIPLIER;
    public static final ConfigOption<Integer> LEVEL0_COMPACTION_TRIGGER;
    public static final ConfigOption<Integer> LEVEL0_SLOWDOWN_WRITES_TRIGGER;
    public static final ConfigOption<Integer> LEVEL0_STOP_WRITES_TRIGGER;
    public static final ConfigOption<Long> SOFT_PENDING_COMPACTION_LIMIT;
    public static final ConfigOption<Long> HARD_PENDING_COMPACTION_LIMIT;
    public static final ConfigOption<Boolean> ALLOW_MMAP_WRITES;
    public static final ConfigOption<Boolean> ALLOW_MMAP_READS;
    public static final ConfigOption<Boolean> USE_DIRECT_READS;
    public static final ConfigOption<Boolean> USE_DIRECT_READS_WRITES_FC;
    public static final ConfigOption<Boolean> USE_FSYNC;
    public static final ConfigOption<Boolean> ATOMIC_FLUSH;
    public static final ConfigOption<Integer> TABLE_FORMAT_VERSION;
    public static final ConfigConvOption<String, IndexType> INDEX_TYPE;
    public static final ConfigConvOption<String, DataBlockIndexType> DATA_BLOCK_SEARCH_TYPE;
    public static final ConfigOption<Double> DATA_BLOCK_HASH_TABLE_RATIO;
    public static final ConfigOption<Long> BLOCK_SIZE;
    public static final ConfigOption<Integer> BLOCK_SIZE_DEVIATION;
    public static final ConfigOption<Integer> BLOCK_RESTART_INTERVAL;
    public static final ConfigOption<Long> BLOCK_CACHE_CAPACITY;
    public static final ConfigOption<Boolean> CACHE_FILTER_AND_INDEX;
    public static final ConfigOption<Boolean> PIN_L0_INDEX_AND_FILTER;
    public static final ConfigOption<Integer> BLOOM_FILTER_BITS_PER_KEY;
    public static final ConfigOption<Boolean> BLOOM_FILTER_MODE;
    public static final ConfigOption<Boolean> BLOOM_FILTER_WHOLE_KEY;
    public static final ConfigOption<Boolean> BLOOM_FILTERS_SKIP_LAST_LEVEL;
    public static final ConfigOption<Boolean> PARTITION_FILTERS_INDEXES;
    public static final ConfigOption<Boolean> PIN_TOP_INDEX_AND_FILTER;
    public static final ConfigOption<Integer> PREFIX_EXTRACTOR_CAPPED;

    private RocksDBOptions() {
    }

    public static synchronized RocksDBOptions instance() {
        if (instance == null) {
            instance = new RocksDBOptions();
            instance.registerOptions();
        }
        return instance;
    }

    static {
        DATA_PATH = new ConfigOption("rocksdb.data_path", "The path for storing data of RocksDB.", OptionChecker.disallowEmpty(), (Object)"rocksdb-data");
        DATA_DISKS = new ConfigListOption("rocksdb.data_disks", false, "The optimized disks for storing data of RocksDB. The format of each element: `STORE/TABLE: /path/disk`.Allowed keys are [g/vertex, g/edge_out, g/edge_in, g/vertex_label_index, g/edge_label_index, g/range_int_index, g/range_float_index, g/range_long_index, g/range_double_index, g/secondary_index, g/search_index, g/shard_index, g/unique_index, g/olap]", null, String.class, (List)ImmutableList.of());
        WAL_PATH = new ConfigOption("rocksdb.wal_path", "The path for storing WAL of RocksDB.", OptionChecker.disallowEmpty(), (Object)"rocksdb-data");
        SST_PATH = new ConfigOption("rocksdb.sst_path", "The path for ingesting SST file into RocksDB.", null, (Object)"");
        LOG_LEVEL = new ConfigOption("rocksdb.log_level", "The info log level of RocksDB.", OptionChecker.allowValues((Object[])new String[]{"DEBUG", "INFO", "WARN", "ERROR", "FATAL", "HEADER"}), (Object)"INFO");
        NUM_LEVELS = new ConfigOption("rocksdb.num_levels", "Set the number of levels for this database.", OptionChecker.rangeInt((Number)1, (Number)Integer.MAX_VALUE), (Object)7);
        COMPACTION_STYLE = new ConfigConvOption("rocksdb.compaction_style", "Set compaction style for RocksDB: LEVEL/UNIVERSAL/FIFO.", OptionChecker.allowValues((Object[])new String[]{"LEVEL", "UNIVERSAL", "FIFO"}), CompactionStyle::valueOf, (Object)"LEVEL");
        OPTIMIZE_MODE = new ConfigOption("rocksdb.optimize_mode", "Optimize for heavy workloads and big datasets.", OptionChecker.disallowEmpty(), (Object)true);
        BULKLOAD_MODE = new ConfigOption("rocksdb.bulkload_mode", "Switch to the mode to bulk load data into RocksDB.", OptionChecker.disallowEmpty(), (Object)false);
        LEVELS_COMPRESSIONS = new ConfigListConvOption("rocksdb.compression_per_level", "The compression algorithms for different levels of RocksDB, allowed values are none/snappy/z/bzip2/lz4/lz4hc/xpress/zstd.", OptionChecker.inValues((Object[])new String[]{"none", "snappy", "z", "bzip2", "lz4", "lz4hc", "xpress", "zstd"}), CompressionType::getCompressionType, (Object[])new String[]{"none", "none", "snappy", "snappy", "snappy", "snappy", "snappy"});
        BOTTOMMOST_COMPRESSION = new ConfigConvOption("rocksdb.bottommost_compression", "The compression algorithm for the bottommost level of RocksDB, allowed values are none/snappy/z/bzip2/lz4/lz4hc/xpress/zstd.", OptionChecker.allowValues((Object[])new String[]{"none", "snappy", "z", "bzip2", "lz4", "lz4hc", "xpress", "zstd"}), CompressionType::getCompressionType, (Object)"none");
        COMPRESSION = new ConfigConvOption("rocksdb.compression", "The compression algorithm for compressing blocks of RocksDB, allowed values are none/snappy/z/bzip2/lz4/lz4hc/xpress/zstd.", OptionChecker.allowValues((Object[])new String[]{"none", "snappy", "z", "bzip2", "lz4", "lz4hc", "xpress", "zstd"}), CompressionType::getCompressionType, (Object)"snappy");
        MAX_BG_JOBS = new ConfigOption("rocksdb.max_background_jobs", "Maximum number of concurrent background jobs, including flushes and compactions.", OptionChecker.rangeInt((Number)1, (Number)Integer.MAX_VALUE), (Object)8);
        MAX_SUB_COMPACTIONS = new ConfigOption("rocksdb.max_subcompactions", "The value represents the maximum number of threads per compaction job.", OptionChecker.rangeInt((Number)1, (Number)Integer.MAX_VALUE), (Object)4);
        DELAYED_WRITE_RATE = new ConfigOption("rocksdb.delayed_write_rate", "The rate limit in bytes/s of user write requests when need to slow down if the compaction gets behind.", OptionChecker.rangeInt((Number)1L, (Number)Long.MAX_VALUE), (Object)0x1000000L);
        MAX_OPEN_FILES = new ConfigOption("rocksdb.max_open_files", "The maximum number of open files that can be cached by RocksDB, -1 means no limit.", OptionChecker.rangeInt((Number)-1, (Number)Integer.MAX_VALUE), (Object)-1);
        MAX_MANIFEST_FILE_SIZE = new ConfigOption("rocksdb.max_manifest_file_size", "The max size of manifest file in bytes.", OptionChecker.rangeInt((Number)1L, (Number)Long.MAX_VALUE), (Object)0x6400000L);
        SKIP_STATS_UPDATE_ON_DB_OPEN = new ConfigOption("rocksdb.skip_stats_update_on_db_open", "Whether to skip statistics update when opening the database, setting this flag true allows us to not update statistics.", OptionChecker.disallowEmpty(), (Object)false);
        SKIP_CHECK_SIZE_ON_DB_OPEN = new ConfigOption("rocksdb.skip_check_sst_size_on_db_open", "Whether to skip checking sizes of all sst files when opening the database.", OptionChecker.disallowEmpty(), (Object)false);
        MAX_FILE_OPENING_THREADS = new ConfigOption("rocksdb.max_file_opening_threads", "The max number of threads used to open files.", OptionChecker.rangeInt((Number)1, (Number)Integer.MAX_VALUE), (Object)16);
        MAX_TOTAL_WAL_SIZE = new ConfigOption("rocksdb.max_total_wal_size", "Total size of WAL files in bytes. Once WALs exceed this size, we will start forcing the flush of column families related, 0 means no limit.", OptionChecker.rangeInt((Number)0L, (Number)Long.MAX_VALUE), (Object)0L);
        BYTES_PER_SYNC = new ConfigOption("rocksdb.bytes_per_sync", "Allows OS to incrementally sync SST files to disk while they are being written, asynchronously in the background. Issue one request for every bytes_per_sync written. 0 turns it off.", OptionChecker.rangeInt((Number)0L, (Number)Long.MAX_VALUE), (Object)0L);
        WAL_BYTES_PER_SYNC = new ConfigOption("rocksdb.wal_bytes_per_sync", "Allows OS to incrementally sync WAL files to disk while they are being written, asynchronously in the background. Issue one request for every bytes_per_sync written. 0 turns it off.", OptionChecker.rangeInt((Number)0L, (Number)Long.MAX_VALUE), (Object)0L);
        STRICT_BYTES_PER_SYNC = new ConfigOption("rocksdb.strict_bytes_per_sync", "When true, guarantees SST/WAL files have at most bytes_per_sync/wal_bytes_per_sync bytes submitted for writeback at any given time. This can be used to handle cases where processing speed exceeds I/O speed.", OptionChecker.disallowEmpty(), (Object)false);
        DB_MEMTABLE_SIZE = new ConfigOption("rocksdb.db_write_buffer_size", "Total size of write buffers in bytes across all column families, 0 means no limit.", OptionChecker.rangeInt((Number)0L, (Number)Long.MAX_VALUE), (Object)0L);
        LOG_READAHEAD_SIZE = new ConfigOption("rocksdb.log_readahead_size", "The number of bytes to prefetch when reading the log. 0 means the prefetching is disabled.", OptionChecker.rangeInt((Number)0L, (Number)Long.MAX_VALUE), (Object)0L);
        COMPACTION_READAHEAD_SIZE = new ConfigOption("rocksdb.compaction_readahead_size", "The number of bytes to perform bigger reads when doing compaction. If running RocksDB on spinning disks, you should set this to at least 2MB. 0 means the prefetching is disabled.", OptionChecker.rangeInt((Number)0L, (Number)Long.MAX_VALUE), (Object)0L);
        ROW_CACHE_CAPACITY = new ConfigOption("rocksdb.row_cache_capacity", "The capacity in bytes of global cache for table-level rows. 0 means the row_cache is disabled.", OptionChecker.rangeInt((Number)0L, (Number)Long.MAX_VALUE), (Object)0L);
        DELETE_OBSOLETE_FILE_PERIOD = new ConfigOption("rocksdb.delete_obsolete_files_period", "The periodicity in seconds when obsolete files get deleted, 0 means always do full purge.", OptionChecker.rangeInt((Number)0L, (Number)Long.MAX_VALUE), (Object)21600L);
        MEMTABLE_SIZE = new ConfigOption("rocksdb.write_buffer_size", "Amount of data in bytes to build up in memory.", OptionChecker.rangeInt((Number)0x100000L, (Number)Long.MAX_VALUE), (Object)0x8000000L);
        MAX_MEMTABLES = new ConfigOption("rocksdb.max_write_buffer_number", "The maximum number of write buffers that are built up in memory.", OptionChecker.rangeInt((Number)1, (Number)Integer.MAX_VALUE), (Object)6);
        MIN_MEMTABLES_TO_MERGE = new ConfigOption("rocksdb.min_write_buffer_number_to_merge", "The minimum number of write buffers that will be merged together.", OptionChecker.rangeInt((Number)1, (Number)Integer.MAX_VALUE), (Object)2);
        MAX_MEMTABLES_TO_MAINTAIN = new ConfigOption("rocksdb.max_write_buffer_number_to_maintain", "The total maximum number of write buffers to maintain in memory for conflict checking when transactions are used.", OptionChecker.rangeInt((Number)0, (Number)Integer.MAX_VALUE), (Object)0);
        MEMTABLE_BLOOM_SIZE_RATIO = new ConfigOption("rocksdb.memtable_bloom_size_ratio", "If prefix-extractor is set and memtable_bloom_size_ratio is not 0, or if memtable_whole_key_filtering is set true, create bloom filter for memtable with the size of write_buffer_size * memtable_bloom_size_ratio. If it is larger than 0.25, it is santinized to 0.25.", OptionChecker.rangeDouble((Number)0.0, (Number)1.0), (Object)0.0);
        MEMTABLE_BLOOM_WHOLE_KEY_FILTERING = new ConfigOption("rocksdb.memtable_whole_key_filtering", "Enable whole key bloom filter in memtable, it can potentially reduce CPU usage for point-look-ups. Note this will only take effect if memtable_bloom_size_ratio > 0.", OptionChecker.disallowEmpty(), (Object)false);
        MEMTABL_BLOOM_HUGE_PAGE_SIZE = new ConfigOption("rocksdb.memtable_huge_page_size", "The page size for huge page TLB for bloom in memtable. If <= 0, not allocate from huge page TLB but from malloc.", OptionChecker.rangeInt((Number)0L, (Number)Long.MAX_VALUE), (Object)0L);
        MEMTABLE_INPLACE_UPDATE_SUPPORT = new ConfigOption("rocksdb.inplace_update_support", "Allows thread-safe inplace updates if a put key exists in current memtable and sizeof new value is smaller.", OptionChecker.disallowEmpty(), (Object)false);
        DYNAMIC_LEVEL_BYTES = new ConfigOption("rocksdb.level_compaction_dynamic_level_bytes", "Whether to enable level_compaction_dynamic_level_bytes, if it's enabled we give max_bytes_for_level_multiplier a priority against max_bytes_for_level_base, the bytes of base level is dynamic for a more predictable LSM tree, it is useful to limit worse case space amplification. Turning this feature on/off for an existing DB can cause unexpected LSM tree structure so it's not recommended.", OptionChecker.disallowEmpty(), (Object)false);
        MAX_LEVEL1_BYTES = new ConfigOption("rocksdb.max_bytes_for_level_base", "The upper-bound of the total size of level-1 files in bytes.", OptionChecker.rangeInt((Number)0x100000L, (Number)Long.MAX_VALUE), (Object)0x20000000L);
        MAX_LEVEL_BYTES_MULTIPLIER = new ConfigOption("rocksdb.max_bytes_for_level_multiplier", "The ratio between the total size of level (L+1) files and the total size of level L files for all L.", OptionChecker.rangeDouble((Number)1.0, (Number)Double.MAX_VALUE), (Object)10.0);
        TARGET_FILE_SIZE_BASE = new ConfigOption("rocksdb.target_file_size_base", "The target file size for compaction in bytes.", OptionChecker.rangeInt((Number)0x100000L, (Number)Long.MAX_VALUE), (Object)0x4000000L);
        TARGET_FILE_SIZE_MULTIPLIER = new ConfigOption("rocksdb.target_file_size_multiplier", "The size ratio between a level L file and a level (L+1) file.", OptionChecker.rangeInt((Number)1, (Number)Integer.MAX_VALUE), (Object)1);
        LEVEL0_COMPACTION_TRIGGER = new ConfigOption("rocksdb.level0_file_num_compaction_trigger", "Number of files to trigger level-0 compaction.", OptionChecker.rangeInt((Number)0, (Number)Integer.MAX_VALUE), (Object)2);
        LEVEL0_SLOWDOWN_WRITES_TRIGGER = new ConfigOption("rocksdb.level0_slowdown_writes_trigger", "Soft limit on number of level-0 files for slowing down writes.", OptionChecker.rangeInt((Number)-1, (Number)Integer.MAX_VALUE), (Object)20);
        LEVEL0_STOP_WRITES_TRIGGER = new ConfigOption("rocksdb.level0_stop_writes_trigger", "Hard limit on number of level-0 files for stopping writes.", OptionChecker.rangeInt((Number)-1, (Number)Integer.MAX_VALUE), (Object)36);
        SOFT_PENDING_COMPACTION_LIMIT = new ConfigOption("rocksdb.soft_pending_compaction_bytes_limit", "The soft limit to impose on pending compaction in bytes.", OptionChecker.rangeInt((Number)0x40000000L, (Number)Long.MAX_VALUE), (Object)0x1000000000L);
        HARD_PENDING_COMPACTION_LIMIT = new ConfigOption("rocksdb.hard_pending_compaction_bytes_limit", "The hard limit to impose on pending compaction in bytes.", OptionChecker.rangeInt((Number)0x40000000L, (Number)Long.MAX_VALUE), (Object)0x4000000000L);
        ALLOW_MMAP_WRITES = new ConfigOption("rocksdb.allow_mmap_writes", "Allow the OS to mmap file for writing.", OptionChecker.disallowEmpty(), (Object)false);
        ALLOW_MMAP_READS = new ConfigOption("rocksdb.allow_mmap_reads", "Allow the OS to mmap file for reading sst tables.", OptionChecker.disallowEmpty(), (Object)false);
        USE_DIRECT_READS = new ConfigOption("rocksdb.use_direct_reads", "Enable the OS to use direct I/O for reading sst tables.", OptionChecker.disallowEmpty(), (Object)false);
        USE_DIRECT_READS_WRITES_FC = new ConfigOption("rocksdb.use_direct_io_for_flush_and_compaction", "Enable the OS to use direct read/writes in flush and compaction.", OptionChecker.disallowEmpty(), (Object)false);
        USE_FSYNC = new ConfigOption("rocksdb.use_fsync", "If true, then every store to stable storage will issue a fsync.", OptionChecker.disallowEmpty(), (Object)false);
        ATOMIC_FLUSH = new ConfigOption("rocksdb.atomic_flush", "If true, flushing multiple column families and committing their results atomically to MANIFEST. Note that it's not necessary to set atomic_flush=true if WAL is always enabled.", OptionChecker.disallowEmpty(), (Object)false);
        TABLE_FORMAT_VERSION = new ConfigOption("rocksdb.format_version", "The format version of BlockBasedTable, allowed values are 0~5.", OptionChecker.rangeInt((Number)0, (Number)5), (Object)5);
        INDEX_TYPE = new ConfigConvOption("rocksdb.index_type", "The index type used to lookup between data blocks with the sst table, allowed values are [kBinarySearch,kHashSearch,kTwoLevelIndexSearch,kBinarySearchWithFirstKey].", OptionChecker.allowValues((Object[])new String[]{"kBinarySearch", "kHashSearch", "kTwoLevelIndexSearch", "kBinarySearchWithFirstKey"}), IndexType::valueOf, (Object)"kBinarySearch");
        DATA_BLOCK_SEARCH_TYPE = new ConfigConvOption("rocksdb.data_block_index_type", "The search type used to point lookup in data block with the sst table, allowed values are [kDataBlockBinarySearch,kDataBlockBinaryAndHash].", OptionChecker.allowValues((Object[])new String[]{"kDataBlockBinarySearch", "kDataBlockBinaryAndHash"}), DataBlockIndexType::valueOf, (Object)"kDataBlockBinarySearch");
        DATA_BLOCK_HASH_TABLE_RATIO = new ConfigOption("rocksdb.data_block_hash_table_util_ratio", "The hash table utilization ratio value of entries/buckets. It is valid only when data_block_index_type=kDataBlockBinaryAndHash.", OptionChecker.rangeDouble((Number)0.0, (Number)1.0), (Object)0.75);
        BLOCK_SIZE = new ConfigOption("rocksdb.block_size", "Approximate size of user data packed per block, Note that it corresponds to uncompressed data.", OptionChecker.rangeInt((Number)0L, (Number)Long.MAX_VALUE), (Object)4096L);
        BLOCK_SIZE_DEVIATION = new ConfigOption("rocksdb.block_size_deviation", "The percentage of free space used to close a block.", OptionChecker.rangeInt((Number)0, (Number)100), (Object)10);
        BLOCK_RESTART_INTERVAL = new ConfigOption("rocksdb.block_restart_interval", "The block restart interval for delta encoding in blocks.", OptionChecker.rangeInt((Number)0, (Number)Integer.MAX_VALUE), (Object)16);
        BLOCK_CACHE_CAPACITY = new ConfigOption("rocksdb.block_cache_capacity", "The amount of block cache in bytes that will be used by RocksDB, 0 means no block cache.", OptionChecker.rangeInt((Number)0L, (Number)Long.MAX_VALUE), (Object)0x800000L);
        CACHE_FILTER_AND_INDEX = new ConfigOption("rocksdb.cache_index_and_filter_blocks", "Set this option true if we'd put index/filter blocks to the block cache.", OptionChecker.disallowEmpty(), (Object)true);
        PIN_L0_INDEX_AND_FILTER = new ConfigOption("rocksdb.pin_l0_filter_and_index_blocks_in_cache", "Set this option true if we'd pin L0 index/filter blocks to the block cache.", OptionChecker.disallowEmpty(), (Object)true);
        BLOOM_FILTER_BITS_PER_KEY = new ConfigOption("rocksdb.bloom_filter_bits_per_key", "The bits per key in bloom filter, a good value is 10, which yields a filter with ~ 1% false positive rate. Set bloom_filter_bits_per_key > 0 to enable bloom filter, -1 means no bloom filter (0~0.5 round down to no filter).", OptionChecker.rangeInt((Number)-1, (Number)Integer.MAX_VALUE), (Object)-1);
        BLOOM_FILTER_MODE = new ConfigOption("rocksdb.bloom_filter_block_based_mode", "If bloom filter is enabled, set this option true to use block based filter rather than full filter.", OptionChecker.disallowEmpty(), (Object)false);
        BLOOM_FILTER_WHOLE_KEY = new ConfigOption("rocksdb.bloom_filter_whole_key_filtering", "If bloom filter is enabled, set this option true to place whole keys in the bloom filter, else place the prefix of keys when prefix-extractor is set.", OptionChecker.disallowEmpty(), (Object)true);
        BLOOM_FILTERS_SKIP_LAST_LEVEL = new ConfigOption("rocksdb.optimize_filters_for_hits", "If bloom filter is enabled, this flag allows us to not store filters for the last level. set this option true to optimize the filters mainly for cases where keys are found rather than also optimize for keys missed.", OptionChecker.disallowEmpty(), (Object)true);
        PARTITION_FILTERS_INDEXES = new ConfigOption("rocksdb.partition_filters_and_indexes", "If bloom filter is enabled, set this option true to use partitioned full filters and indexes for each sst file. This option is incompatible with block-based filters.", OptionChecker.disallowEmpty(), (Object)false);
        PIN_TOP_INDEX_AND_FILTER = new ConfigOption("rocksdb.pin_top_level_index_and_filter", "If partition_filters_and_indexes is set true, set this option true if we'd pin top-level index of partitioned filter and index blocks to the block cache.", OptionChecker.disallowEmpty(), (Object)true);
        PREFIX_EXTRACTOR_CAPPED = new ConfigOption("rocksdb.prefix_extractor_n_bytes", "The prefix-extractor uses the first N bytes of a key as its prefix, it will use the full key when a key is shorter than the N. 0 means unset prefix-extractor.", OptionChecker.rangeInt((Number)0, (Number)Integer.MAX_VALUE), (Object)0);
    }
}

