/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.rocksdb;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.serializer.MergeIterator;
import org.apache.hugegraph.backend.store.AbstractBackendStore;
import org.apache.hugegraph.backend.store.BackendAction;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.backend.store.BackendFeatures;
import org.apache.hugegraph.backend.store.BackendMutation;
import org.apache.hugegraph.backend.store.BackendSession;
import org.apache.hugegraph.backend.store.BackendSessionPool;
import org.apache.hugegraph.backend.store.BackendStoreProvider;
import org.apache.hugegraph.backend.store.BackendTable;
import org.apache.hugegraph.backend.store.rocksdb.RocksDBFeatures;
import org.apache.hugegraph.backend.store.rocksdb.RocksDBMetrics;
import org.apache.hugegraph.backend.store.rocksdb.RocksDBOptions;
import org.apache.hugegraph.backend.store.rocksdb.RocksDBSessions;
import org.apache.hugegraph.backend.store.rocksdb.RocksDBStdSessions;
import org.apache.hugegraph.backend.store.rocksdb.RocksDBTable;
import org.apache.hugegraph.backend.store.rocksdb.RocksDBTables;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.exception.ConnectionException;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.util.Consumers;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.ExecutorUtil;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.apache.hugegraph.util.Log;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;

public abstract class RocksDBStore
extends AbstractBackendStore<RocksDBSessions.Session> {
    private static final Logger LOG = Log.logger(RocksDBStore.class);
    private static final BackendFeatures FEATURES = new RocksDBFeatures();
    private final String store;
    private final String database;
    private final BackendStoreProvider provider;
    private final Map<HugeType, RocksDBTable> tables = new HashMap<HugeType, RocksDBTable>();
    private final Map<String, RocksDBTable> olapTables = new HashMap<String, RocksDBTable>();
    private String dataPath;
    private RocksDBSessions sessions;
    private final Map<HugeType, String> tableDiskMapping;
    private final ConcurrentMap<String, RocksDBSessions> dbs;
    private final ReadWriteLock storeLock;
    private static final String TABLE_GENERAL_KEY = "general";
    private static final String DB_OPEN = "db-open-%s";
    private static final long OPEN_TIMEOUT = 600L;
    private static final int OPEN_POOL_THREADS = 8;
    private boolean isGraphStore;

    public RocksDBStore(BackendStoreProvider provider, String database, String store) {
        this.provider = provider;
        this.database = database;
        this.store = store;
        this.sessions = null;
        this.tableDiskMapping = new HashMap<HugeType, String>();
        this.dbs = new ConcurrentHashMap<String, RocksDBSessions>();
        this.storeLock = new ReentrantReadWriteLock();
        this.registerMetaHandlers();
    }

    private void registerMetaHandlers() {
        Supplier<List> dbsGet = () -> {
            ArrayList<RocksDBSessions> dbs = new ArrayList<RocksDBSessions>();
            dbs.add(this.sessions);
            dbs.addAll(this.tableDBMapping().values());
            return dbs;
        };
        this.registerMetaHandler("metrics", (session, meta, args) -> {
            RocksDBMetrics metrics = new RocksDBMetrics((List)dbsGet.get(), (RocksDBSessions.Session)session);
            return metrics.metrics();
        });
        this.registerMetaHandler("compact", (session, meta, args) -> {
            RocksDBMetrics metrics = new RocksDBMetrics((List)dbsGet.get(), (RocksDBSessions.Session)session);
            return metrics.compact();
        });
    }

    protected void registerTableManager(HugeType type, RocksDBTable table) {
        this.tables.put(type, table);
    }

    protected void registerTableManager(String name, RocksDBTable table) {
        this.olapTables.put(name, table);
    }

    protected void unregisterTableManager(String name) {
        this.olapTables.remove(name);
    }

    protected final RocksDBTable table(HugeType type) {
        RocksDBTable table = this.tables.get(type);
        if (table == null) {
            throw new BackendException("Unsupported table: '%s'", new Object[]{type});
        }
        return table;
    }

    protected final RocksDBTable table(String name) {
        RocksDBTable table = this.olapTables.get(name);
        if (table == null) {
            throw new BackendException("Unsupported table: '%s'", new Object[]{name});
        }
        return table;
    }

    protected List<String> tableNames() {
        List<String> tables = this.tables.values().stream().map(BackendTable::table).collect(Collectors.toList());
        tables.addAll(this.olapTables());
        return tables;
    }

    protected List<String> olapTables() {
        return this.olapTables.values().stream().map(BackendTable::table).collect(Collectors.toList());
    }

    protected List<String> tableNames(HugeType type) {
        return type != HugeType.OLAP ? Collections.singletonList(this.table(type).table()) : this.olapTables();
    }

    public String store() {
        return this.store;
    }

    public String database() {
        return this.database;
    }

    public BackendStoreProvider provider() {
        return this.provider;
    }

    public BackendFeatures features() {
        return FEATURES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void open(HugeConfig config) {
        LOG.debug("Store open: {}", (Object)this.store);
        E.checkNotNull((Object)config, (String)"config");
        String graphStore = (String)config.get((TypedOption)CoreOptions.STORE_GRAPH);
        this.isGraphStore = this.store.equals(graphStore);
        this.dataPath = (String)config.get(RocksDBOptions.DATA_PATH);
        if (this.sessions != null && !this.sessions.closed()) {
            LOG.debug("Store {} has been opened before", (Object)this.store);
            this.useSessions();
            return;
        }
        ArrayList futures = new ArrayList();
        ExecutorService openPool = ExecutorUtil.newFixedThreadPool((int)8, (String)DB_OPEN);
        futures.add(openPool.submit(() -> {
            this.sessions = this.open(config, this.tableNames());
        }));
        Map disks = config.getMap(RocksDBOptions.DATA_DISKS);
        HashSet<String> openedDisks = new HashSet<String>();
        if (!disks.isEmpty()) {
            this.parseTableDiskMapping(disks, this.dataPath);
            for (Map.Entry<HugeType, String> e : this.tableDiskMapping.entrySet()) {
                String disk = e.getValue();
                if (openedDisks.contains(disk)) continue;
                openedDisks.add(disk);
                List<String> tables = this.tableNames(e.getKey());
                futures.add(openPool.submit(() -> this.open(config, disk, disk, tables)));
            }
        }
        try {
            this.waitOpenFinished(futures);
        }
        finally {
            this.shutdownOpenPool(openPool);
        }
    }

    private void waitOpenFinished(List<Future<?>> futures) {
        for (Future<?> future : futures) {
            try {
                future.get();
            }
            catch (Throwable e) {
                if (e.getCause() instanceof ConnectionException) {
                    throw new ConnectionException("Failed to open RocksDB store", e);
                }
                throw new BackendException("Failed to open RocksDB store", e);
            }
        }
    }

    private void shutdownOpenPool(ExecutorService openPool) {
        boolean terminated;
        if (openPool.isShutdown()) {
            return;
        }
        this.useSessions();
        try {
            Consumers.executeOncePerThread((ExecutorService)openPool, (int)8, this::closeSessions);
        }
        catch (InterruptedException e) {
            throw new BackendException("Failed to close session opened by open-pool");
        }
        openPool.shutdown();
        try {
            terminated = openPool.awaitTermination(600L, TimeUnit.SECONDS);
        }
        catch (Throwable e) {
            throw new BackendException("Failed to wait db-open thread pool shutdown", e);
        }
        if (!terminated) {
            LOG.warn("Timeout when waiting db-open thread pool shutdown");
        }
        openPool.shutdownNow();
    }

    protected RocksDBSessions open(HugeConfig config, List<String> tableNames) {
        String dataPath = this.wrapPath((String)config.get(RocksDBOptions.DATA_PATH));
        String walPath = this.wrapPath((String)config.get(RocksDBOptions.WAL_PATH));
        return this.open(config, dataPath, walPath, tableNames);
    }

    protected RocksDBSessions open(HugeConfig config, String dataPath, String walPath, List<String> tableNames) {
        RocksDBSessions sessions;
        block9: {
            LOG.info("Opening RocksDB with data path: {}", (Object)dataPath);
            sessions = null;
            try {
                sessions = this.openSessionPool(config, dataPath, walPath, tableNames);
            }
            catch (RocksDBException e) {
                RocksDBSessions origin = (RocksDBSessions)((Object)this.dbs.get(dataPath));
                if (origin != null && e.getMessage().contains("No locks available")) {
                    sessions = origin.copy(config, this.database, this.store);
                }
                if (e.getMessage().contains("Column family not found")) {
                    boolean existsOtherKeyspace;
                    if (this.isSchemaStore()) {
                        LOG.info("Failed to open RocksDB '{}' with database '{}', try to init CF later", (Object)dataPath, (Object)this.database);
                    }
                    Object none = (existsOtherKeyspace = RocksDBStore.existsOtherKeyspace(dataPath)) ? ImmutableList.of() : null;
                    try {
                        sessions = this.openSessionPool(config, dataPath, walPath, (List<String>)none);
                    }
                    catch (RocksDBException e1) {
                        e = e1;
                    }
                    if (sessions == null && !existsOtherKeyspace) {
                        LOG.error("Failed to open RocksDB with default CF, is there data for other programs: {}", (Object)dataPath);
                    }
                }
                if (sessions != null) break block9;
                LOG.error("Failed to open RocksDB '{}'", (Object)dataPath, (Object)e);
                throw new ConnectionException("Failed to open RocksDB '%s'", (Throwable)e, new Object[]{dataPath});
            }
        }
        if (sessions != null) {
            this.dbs.put(dataPath, sessions);
            sessions.session().open();
            LOG.debug("Store opened: {}", (Object)dataPath);
        }
        return sessions;
    }

    protected RocksDBSessions openSessionPool(HugeConfig config, String dataPath, String walPath, List<String> tableNames) throws RocksDBException {
        if (tableNames == null) {
            return new RocksDBStdSessions(config, this.database, this.store, dataPath, walPath);
        }
        return new RocksDBStdSessions(config, this.database, this.store, dataPath, walPath, tableNames);
    }

    protected String wrapPath(String path) {
        try {
            FileUtils.forceMkdir((File)FileUtils.getFile((String[])new String[]{path}));
        }
        catch (IOException e) {
            throw new BackendException(e.getMessage(), (Throwable)e);
        }
        return Paths.get(path, this.store).toString();
    }

    protected Map<String, RocksDBSessions> tableDBMapping() {
        Map tableDBMap = InsertionOrderUtil.newMap();
        for (Map.Entry<HugeType, String> e : this.tableDiskMapping.entrySet()) {
            HugeType type = e.getKey();
            RocksDBSessions db = this.db(e.getValue());
            String key = type != HugeType.OLAP ? this.table(type).table() : type.string();
            tableDBMap.put(key, db);
        }
        return tableDBMap;
    }

    protected ReadWriteLock storeLock() {
        return this.storeLock;
    }

    public void close() {
        LOG.debug("Store close: {}", (Object)this.store);
        this.checkOpened();
        this.closeSessions();
    }

    public boolean opened() {
        this.checkDbOpened();
        return this.sessions.session().opened();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mutate(BackendMutation mutation) {
        Lock readLock = this.storeLock.readLock();
        readLock.lock();
        try {
            this.checkOpened();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Store {} mutation: {}", (Object)this.store, (Object)mutation);
            }
            for (HugeType type : mutation.types()) {
                RocksDBSessions.Session session = this.session(type);
                Iterator it = mutation.mutation(type);
                while (it.hasNext()) {
                    this.mutate(session, (BackendAction)it.next());
                }
            }
        }
        finally {
            readLock.unlock();
        }
    }

    private void mutate(RocksDBSessions.Session session, BackendAction item) {
        RocksDBTable table;
        BackendEntry entry = item.entry();
        if (!entry.olap()) {
            table = this.table(entry.type());
        } else {
            table = entry.type().isIndex() ? this.table(this.olapTableName(entry.type())) : this.table(this.olapTableName(entry.subId()));
            session = this.session(HugeType.OLAP);
        }
        switch (item.action()) {
            case INSERT: {
                table.insert(session, entry);
                break;
            }
            case DELETE: {
                table.delete(session, entry);
                break;
            }
            case APPEND: {
                table.append(session, entry);
                break;
            }
            case ELIMINATE: {
                table.eliminate(session, entry);
                break;
            }
            case UPDATE_IF_PRESENT: {
                table.updateIfPresent((BackendSession)session, entry);
                break;
            }
            case UPDATE_IF_ABSENT: {
                table.updateIfAbsent((BackendSession)session, entry);
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unsupported mutate action: %s", item.action()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<BackendEntry> query(Query query) {
        Lock readLock = this.storeLock.readLock();
        readLock.lock();
        try {
            RocksDBSessions.Session session;
            RocksDBTable table;
            this.checkOpened();
            HugeType tableType = RocksDBTable.tableType((Query)query);
            if (query.olap()) {
                table = this.table(this.olapTableName(tableType));
                session = this.session(HugeType.OLAP);
            } else {
                table = this.table(tableType);
                session = this.session(tableType);
            }
            MergeIterator entries = table.query(session, query);
            Set olapPks = query.olapPks();
            if (this.isGraphStore && !olapPks.isEmpty()) {
                ArrayList<Iterator<BackendEntry>> iterators = new ArrayList<Iterator<BackendEntry>>();
                for (Id pk : olapPks) {
                    Query q = query.copy();
                    table = this.table(this.olapTableName(pk));
                    iterators.add(table.query(this.session(HugeType.OLAP), q));
                }
                entries = new MergeIterator(entries, iterators, BackendEntry::mergeable);
            }
            MergeIterator mergeIterator = entries;
            return mergeIterator;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Number queryNumber(Query query) {
        Lock readLock = this.storeLock.readLock();
        readLock.lock();
        try {
            this.checkOpened();
            HugeType tableType = RocksDBTable.tableType((Query)query);
            RocksDBTable table = this.table(tableType);
            Number number = table.queryNumber(this.session(tableType), query);
            return number;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init() {
        Lock writeLock = this.storeLock.writeLock();
        writeLock.lock();
        try {
            this.checkDbOpened();
            this.createTable(this.sessions, this.tableNames().toArray(new String[0]));
            Map<String, RocksDBSessions> tableDBMap = this.tableDBMapping();
            for (Map.Entry<String, RocksDBSessions> e : tableDBMap.entrySet()) {
                if (e.getKey().equals(HugeType.OLAP.string())) {
                    for (String olapTable : this.olapTables()) {
                        this.createTable(e.getValue(), olapTable);
                    }
                    continue;
                }
                this.createTable(e.getValue(), e.getKey());
            }
            LOG.debug("Store initialized: {}", (Object)this.store);
        }
        finally {
            writeLock.unlock();
        }
    }

    protected void createTable(RocksDBSessions db, String ... tables) {
        try {
            db.createTable(tables);
        }
        catch (RocksDBException e) {
            throw new BackendException("Failed to create tables %s for '%s'", (Throwable)e, new Object[]{Arrays.asList(tables), this.store});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear(boolean clearSpace) {
        Lock writeLock = this.storeLock.writeLock();
        writeLock.lock();
        try {
            this.checkDbOpened();
            this.dropTable(this.sessions, this.tableNames().toArray(new String[0]));
            Map<String, RocksDBSessions> tableDBMap = this.tableDBMapping();
            for (Map.Entry<String, RocksDBSessions> e : tableDBMap.entrySet()) {
                if (e.getKey().equals(HugeType.OLAP.string())) {
                    for (String olapTable : this.olapTables()) {
                        this.dropTable(e.getValue(), olapTable);
                    }
                    continue;
                }
                this.dropTable(e.getValue(), e.getKey());
            }
            LOG.debug("Store cleared: {}", (Object)this.store);
        }
        finally {
            writeLock.unlock();
        }
    }

    protected void dropTable(RocksDBSessions db, String ... tables) {
        try {
            db.dropTable(tables);
        }
        catch (BackendException e) {
            if (e.getMessage().contains("is not opened")) {
                return;
            }
            throw e;
        }
        catch (RocksDBException e) {
            throw new BackendException("Failed to drop tables %s for '%s'", (Throwable)e, new Object[]{Arrays.asList(tables), this.store});
        }
    }

    public boolean initialized() {
        this.checkDbOpened();
        if (!this.opened()) {
            return false;
        }
        for (String table : this.tableNames()) {
            if (this.sessions.existsTable(table)) continue;
            return false;
        }
        return true;
    }

    public synchronized void truncate() {
        Lock writeLock = this.storeLock.writeLock();
        writeLock.lock();
        try {
            this.checkOpened();
            this.clear(false);
            this.init();
            this.dbs.values().forEach(BackendSessionPool::forceResetSessions);
            LOG.debug("Store truncated: {}", (Object)this.store);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTx() {
        Lock readLock = this.storeLock.readLock();
        readLock.lock();
        try {
            this.checkOpened();
            for (RocksDBSessions.Session session : this.session()) {
                assert (!session.hasChanges());
            }
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTx() {
        Lock readLock = this.storeLock.readLock();
        readLock.lock();
        try {
            this.checkOpened();
            for (RocksDBSessions.Session session : this.session()) {
                Object count = session.commit();
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Store {} committed {} items", (Object)this.store, count);
            }
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTx() {
        Lock readLock = this.storeLock.readLock();
        readLock.lock();
        try {
            this.checkOpened();
            for (RocksDBSessions.Session session : this.session()) {
                session.rollback();
            }
        }
        finally {
            readLock.unlock();
        }
    }

    protected RocksDBSessions.Session session(HugeType tableType) {
        this.checkOpened();
        String disk = this.tableDiskMapping.get(tableType);
        if (disk != null) {
            return this.db(disk).session();
        }
        return this.sessions.session();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> createSnapshot(String snapshotPrefix) {
        Lock readLock = this.storeLock.readLock();
        readLock.lock();
        try {
            HashMap<String, String> uniqueSnapshotDirMaps = new HashMap<String, String>();
            for (Map.Entry entry : this.dbs.entrySet()) {
                Path originDataPath = Paths.get((String)entry.getKey(), new String[0]).toAbsolutePath();
                Path parentParentPath = originDataPath.getParent().getParent();
                Path pureDataPath = parentParentPath.relativize(originDataPath);
                Path snapshotPath = parentParentPath.resolve(snapshotPrefix + "_" + pureDataPath);
                LOG.debug("Create snapshot '{}' for origin data path '{}'", (Object)snapshotPath, (Object)originDataPath);
                RocksDBSessions sessions = (RocksDBSessions)((Object)entry.getValue());
                sessions.createSnapshot(snapshotPath.toString());
                String snapshotDir = snapshotPath.getParent().toString();
                String diskTableKey = this.findDiskTableKeyByPath((String)entry.getKey());
                uniqueSnapshotDirMaps.put(snapshotDir, diskTableKey);
            }
            LOG.info("The store '{}' create snapshot successfully", (Object)this);
            HashMap<String, String> hashMap = uniqueSnapshotDirMaps;
            return hashMap;
        }
        finally {
            readLock.unlock();
        }
    }

    public void resumeSnapshot(String snapshotPrefix, boolean deleteSnapshot) {
        Lock readLock = this.storeLock.readLock();
        readLock.lock();
        try {
            if (!this.opened()) {
                return;
            }
            HashMap<String, RocksDBSessions> snapshotPaths = new HashMap<String, RocksDBSessions>();
            for (Map.Entry entry : this.dbs.entrySet()) {
                RocksDBSessions sessions = (RocksDBSessions)((Object)entry.getValue());
                String snapshotPath = sessions.buildSnapshotPath(snapshotPrefix);
                LOG.debug("The origin data path: {}", entry.getKey());
                if (!deleteSnapshot) {
                    snapshotPath = sessions.hardLinkSnapshot(snapshotPath);
                }
                LOG.debug("The snapshot data path: {}", (Object)snapshotPath);
                snapshotPaths.put(snapshotPath, sessions);
            }
            for (Map.Entry entry : snapshotPaths.entrySet()) {
                Path parentPath;
                String snapshotPath = (String)entry.getKey();
                RocksDBSessions sessions = (RocksDBSessions)((Object)entry.getValue());
                sessions.resumeSnapshot(snapshotPath);
                if (!deleteSnapshot || Files.list(parentPath = Paths.get(snapshotPath, new String[0]).getParent()).count() != 0L) continue;
                FileUtils.deleteDirectory((File)parentPath.toFile());
            }
            LOG.info("The store '{}' resume snapshot successfully", (Object)this);
        }
        catch (IOException | RocksDBException e) {
            throw new BackendException("Failed to resume snapshot", e);
        }
        finally {
            readLock.unlock();
        }
    }

    private void useSessions() {
        for (RocksDBSessions sessions : this.sessions()) {
            sessions.useSession();
        }
    }

    private List<RocksDBSessions.Session> session() {
        this.checkOpened();
        if (this.tableDiskMapping.isEmpty()) {
            return Collections.singletonList(this.sessions.session());
        }
        ArrayList<RocksDBSessions.Session> list = new ArrayList<RocksDBSessions.Session>(this.tableDiskMapping.size() + 1);
        list.add(this.sessions.session());
        for (String disk : this.tableDiskMapping.values()) {
            list.add(this.db(disk).session());
        }
        return list;
    }

    private void closeSessions() {
        Iterator iter = this.dbs.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            RocksDBSessions sessions = (RocksDBSessions)((Object)entry.getValue());
            boolean closed = sessions.close();
            if (!closed) continue;
            iter.remove();
        }
    }

    private Collection<RocksDBSessions> sessions() {
        return this.dbs.values();
    }

    private void parseTableDiskMapping(Map<String, String> disks, String dataPath) {
        this.tableDiskMapping.clear();
        for (Map.Entry<String, String> disk : disks.entrySet()) {
            String name = disk.getKey();
            String path = disk.getValue();
            E.checkArgument((!dataPath.equals(path) ? 1 : 0) != 0, (String)"Invalid disk path(can't be the same as data_path): '%s'", (Object[])new Object[]{path});
            E.checkArgument((!name.isEmpty() && !path.isEmpty() ? 1 : 0) != 0, (String)"Invalid disk format: '%s', expect `NAME:PATH`", (Object[])new Object[]{disk});
            String[] pair = name.split("/", 2);
            E.checkArgument((pair.length == 2 ? 1 : 0) != 0, (String)"Invalid disk key format: '%s', expect `STORE/TABLE`", (Object[])new Object[]{name});
            String store = pair[0].trim();
            HugeType table = HugeType.valueOf((String)pair[1].trim().toUpperCase());
            if (!this.store.equals(store)) continue;
            path = this.wrapPath(path);
            this.tableDiskMapping.put(table, path);
        }
    }

    private Map<String, String> reportDiskMapping() {
        HashMap<String, String> diskMapping = new HashMap<String, String>();
        diskMapping.put(TABLE_GENERAL_KEY, this.dataPath);
        for (Map.Entry<HugeType, String> e : this.tableDiskMapping.entrySet()) {
            String key = this.store + "/" + e.getKey().name();
            String value = Paths.get(e.getValue(), new String[0]).getParent().toString();
            diskMapping.put(key, value);
        }
        return diskMapping;
    }

    private String findDiskTableKeyByPath(String diskPath) {
        String diskTableKey = TABLE_GENERAL_KEY;
        for (Map.Entry<HugeType, String> e : this.tableDiskMapping.entrySet()) {
            if (!diskPath.equals(e.getValue())) continue;
            diskTableKey = this.store + "/" + e.getKey().name();
            break;
        }
        return diskTableKey;
    }

    private void checkDbOpened() {
        E.checkState((this.sessions != null && !this.sessions.closed() ? 1 : 0) != 0, (String)"RocksDB has not been opened", (Object[])new Object[0]);
    }

    protected RocksDBSessions db(HugeType tableType) {
        this.checkOpened();
        String disk = this.tableDiskMapping.get(tableType);
        if (disk != null) {
            return this.db(disk);
        }
        return this.sessions;
    }

    private RocksDBSessions db(String disk) {
        RocksDBSessions db = (RocksDBSessions)((Object)this.dbs.get(disk));
        E.checkState((db != null && !db.closed() ? 1 : 0) != 0, (String)"RocksDB store has not been opened: %s", (Object[])new Object[]{disk});
        return db;
    }

    private static boolean existsOtherKeyspace(String dataPath) {
        Set<String> cfs;
        try {
            cfs = RocksDBStdSessions.listCFs(dataPath);
        }
        catch (RocksDBException e) {
            return false;
        }
        int matched = 0;
        for (String cf : cfs) {
            if (!cf.endsWith(RocksDBTables.PropertyKey.TABLE) && !cf.endsWith(RocksDBTables.VertexLabel.TABLE) && !cf.endsWith(RocksDBTables.EdgeLabel.TABLE) && !cf.endsWith(RocksDBTables.IndexLabel.TABLE) && !cf.endsWith(RocksDBTables.SecondaryIndex.TABLE) && !cf.endsWith(RocksDBTables.SearchIndex.TABLE) && !cf.endsWith(RocksDBTables.RangeIntIndex.TABLE) && !cf.endsWith(RocksDBTables.RangeFloatIndex.TABLE) && !cf.endsWith(RocksDBTables.RangeLongIndex.TABLE) && !cf.endsWith(RocksDBTables.RangeDoubleIndex.TABLE) || ++matched < 3) continue;
            return true;
        }
        return false;
    }

    public static class RocksDBSystemStore
    extends RocksDBGraphStore {
        private final RocksDBTables.Meta meta;

        public RocksDBSystemStore(BackendStoreProvider provider, String database, String store) {
            super(provider, database, store);
            this.meta = new RocksDBTables.Meta(database);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void init() {
            super.init();
            Lock writeLock = this.storeLock().writeLock();
            writeLock.lock();
            try {
                RocksDBSessions.Session session = super.session(HugeType.META);
                String driverVersion = this.provider().driverVersion();
                this.meta.writeVersion(session, driverVersion);
                LOG.info("Write down the backend version: {}", (Object)driverVersion);
            }
            finally {
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String storedVersion() {
            Lock readLock = this.storeLock().readLock();
            readLock.lock();
            try {
                super.checkOpened();
                RocksDBSessions.Session session = super.session(null);
                String string = this.meta.readVersion(session);
                return string;
            }
            finally {
                readLock.unlock();
            }
        }

        @Override
        protected List<String> tableNames() {
            List<String> tableNames = super.tableNames();
            tableNames.add(this.meta.table());
            return tableNames;
        }
    }

    public static class RocksDBGraphStore
    extends RocksDBStore {
        public RocksDBGraphStore(BackendStoreProvider provider, String database, String store) {
            super(provider, database, store);
            this.registerTableManager(HugeType.VERTEX, (RocksDBTable)new RocksDBTables.Vertex(database));
            this.registerTableManager(HugeType.EDGE_OUT, (RocksDBTable)RocksDBTables.Edge.out(database));
            this.registerTableManager(HugeType.EDGE_IN, (RocksDBTable)RocksDBTables.Edge.in(database));
            this.registerTableManager(HugeType.SECONDARY_INDEX, (RocksDBTable)new RocksDBTables.SecondaryIndex(database));
            this.registerTableManager(HugeType.VERTEX_LABEL_INDEX, (RocksDBTable)new RocksDBTables.VertexLabelIndex(database));
            this.registerTableManager(HugeType.EDGE_LABEL_INDEX, (RocksDBTable)new RocksDBTables.EdgeLabelIndex(database));
            this.registerTableManager(HugeType.RANGE_INT_INDEX, (RocksDBTable)new RocksDBTables.RangeIntIndex(database));
            this.registerTableManager(HugeType.RANGE_FLOAT_INDEX, (RocksDBTable)new RocksDBTables.RangeFloatIndex(database));
            this.registerTableManager(HugeType.RANGE_LONG_INDEX, (RocksDBTable)new RocksDBTables.RangeLongIndex(database));
            this.registerTableManager(HugeType.RANGE_DOUBLE_INDEX, (RocksDBTable)new RocksDBTables.RangeDoubleIndex(database));
            this.registerTableManager(HugeType.SEARCH_INDEX, (RocksDBTable)new RocksDBTables.SearchIndex(database));
            this.registerTableManager(HugeType.SHARD_INDEX, (RocksDBTable)new RocksDBTables.ShardIndex(database));
            this.registerTableManager(HugeType.UNIQUE_INDEX, (RocksDBTable)new RocksDBTables.UniqueIndex(database));
            this.registerTableManager(this.olapTableName(HugeType.SECONDARY_INDEX), (RocksDBTable)new RocksDBTables.OlapSecondaryIndex(store));
            this.registerTableManager(this.olapTableName(HugeType.RANGE_INT_INDEX), (RocksDBTable)new RocksDBTables.OlapRangeIntIndex(store));
            this.registerTableManager(this.olapTableName(HugeType.RANGE_LONG_INDEX), (RocksDBTable)new RocksDBTables.OlapRangeLongIndex(store));
            this.registerTableManager(this.olapTableName(HugeType.RANGE_FLOAT_INDEX), (RocksDBTable)new RocksDBTables.OlapRangeFloatIndex(store));
            this.registerTableManager(this.olapTableName(HugeType.RANGE_DOUBLE_INDEX), (RocksDBTable)new RocksDBTables.OlapRangeDoubleIndex(store));
        }

        public boolean isSchemaStore() {
            return false;
        }

        public Id nextId(HugeType type) {
            throw new UnsupportedOperationException("RocksDBGraphStore.nextId()");
        }

        public void increaseCounter(HugeType type, long num) {
            throw new UnsupportedOperationException("RocksDBGraphStore.increaseCounter()");
        }

        public long getCounter(HugeType type) {
            throw new UnsupportedOperationException("RocksDBGraphStore.getCounter()");
        }

        public void checkAndRegisterOlapTable(Id id) {
            RocksDBTables.OlapTable table = new RocksDBTables.OlapTable(this.store(), id);
            if (!((RocksDBStore)this).sessions.existsTable(table.table())) {
                throw new HugeException("Not exist table '%s''", new Object[]{table.table()});
            }
            this.registerTableManager(this.olapTableName(id), (RocksDBTable)table);
        }

        public void createOlapTable(Id id) {
            RocksDBTables.OlapTable table = new RocksDBTables.OlapTable(this.store(), id);
            this.createTable(this.db(HugeType.OLAP), table.table());
            this.registerTableManager(this.olapTableName(id), (RocksDBTable)table);
        }

        public void clearOlapTable(Id id) {
            String name = this.olapTableName(id);
            RocksDBTable table = this.table(name);
            RocksDBSessions db = this.db(HugeType.OLAP);
            if (!db.existsTable(table.table())) {
                throw new HugeException("Not exist table '%s''", new Object[]{name});
            }
            this.dropTable(db, table.table());
            this.createTable(db, table.table());
        }

        public void removeOlapTable(Id id) {
            String name = this.olapTableName(id);
            RocksDBTable table = this.table(name);
            RocksDBSessions db = this.db(HugeType.OLAP);
            if (!db.existsTable(table.table())) {
                throw new HugeException("Not exist table '%s''", new Object[]{name});
            }
            this.dropTable(db, table.table());
            this.unregisterTableManager(this.olapTableName(id));
        }
    }

    public static class RocksDBSchemaStore
    extends RocksDBStore {
        private final RocksDBTables.Counters counters;

        public RocksDBSchemaStore(BackendStoreProvider provider, String database, String store) {
            super(provider, database, store);
            this.counters = new RocksDBTables.Counters(database);
            this.registerTableManager(HugeType.VERTEX_LABEL, (RocksDBTable)new RocksDBTables.VertexLabel(database));
            this.registerTableManager(HugeType.EDGE_LABEL, (RocksDBTable)new RocksDBTables.EdgeLabel(database));
            this.registerTableManager(HugeType.PROPERTY_KEY, (RocksDBTable)new RocksDBTables.PropertyKey(database));
            this.registerTableManager(HugeType.INDEX_LABEL, (RocksDBTable)new RocksDBTables.IndexLabel(database));
            this.registerTableManager(HugeType.SECONDARY_INDEX, (RocksDBTable)new RocksDBTables.SecondaryIndex(database));
        }

        @Override
        protected List<String> tableNames() {
            List<String> tableNames = super.tableNames();
            tableNames.add(this.counters.table());
            return tableNames;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void increaseCounter(HugeType type, long increment) {
            Lock readLock = ((RocksDBStore)this).storeLock.readLock();
            readLock.lock();
            try {
                super.checkOpened();
                RocksDBSessions.Session session = ((RocksDBStore)this).sessions.session();
                this.counters.increaseCounter(session, type, increment);
            }
            finally {
                readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getCounter(HugeType type) {
            Lock readLock = ((RocksDBStore)this).storeLock.readLock();
            readLock.lock();
            try {
                super.checkOpened();
                RocksDBSessions.Session session = ((RocksDBStore)this).sessions.session();
                long l = this.counters.getCounter(session, type);
                return l;
            }
            finally {
                readLock.unlock();
            }
        }

        public boolean isSchemaStore() {
            return true;
        }
    }
}

