/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.auth;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.auth.UserAPI;
import org.apache.hugegraph.api.filter.StatusFilter;
import org.apache.hugegraph.auth.HugeTarget;
import org.apache.hugegraph.auth.SchemaDefine;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.define.Checkable;
import org.apache.hugegraph.exception.NotFoundException;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;

@Path(value="graphs/{graph}/auth/targets")
@Singleton
@Tag(name="TargetAPI")
public class TargetAPI
extends API {
    private static final Logger LOG = Log.logger(TargetAPI.class);

    @POST
    @Timed
    @StatusFilter.Status(value=201)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String create(@Context GraphManager manager, @PathParam(value="graph") String graph, JsonTarget jsonTarget) {
        LOG.debug("Graph [{}] create target: {}", (Object)graph, (Object)jsonTarget);
        TargetAPI.checkCreatingBody(jsonTarget);
        HugeGraph g = TargetAPI.graph(manager, graph);
        HugeTarget target = jsonTarget.build();
        target.id(manager.authManager().createTarget(target));
        return manager.serializer((Graph)g).writeAuthElement((SchemaDefine.AuthElement)target);
    }

    @PUT
    @Timed
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String update(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="id") String id, JsonTarget jsonTarget) {
        HugeTarget target;
        LOG.debug("Graph [{}] update target: {}", (Object)graph, (Object)jsonTarget);
        TargetAPI.checkUpdatingBody(jsonTarget);
        HugeGraph g = TargetAPI.graph(manager, graph);
        try {
            target = manager.authManager().getTarget(UserAPI.parseId(id));
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException("Invalid target id: " + id);
        }
        target = jsonTarget.build(target);
        manager.authManager().updateTarget(target);
        return manager.serializer((Graph)g).writeAuthElement((SchemaDefine.AuthElement)target);
    }

    @GET
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    public String list(@Context GraphManager manager, @PathParam(value="graph") String graph, @QueryParam(value="limit") @DefaultValue(value="100") long limit) {
        LOG.debug("Graph [{}] list targets", (Object)graph);
        HugeGraph g = TargetAPI.graph(manager, graph);
        List targets = manager.authManager().listAllTargets(limit);
        return manager.serializer((Graph)g).writeAuthElements("targets", targets);
    }

    @GET
    @Timed
    @Path(value="{id}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String get(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="id") String id) {
        LOG.debug("Graph [{}] get target: {}", (Object)graph, (Object)id);
        HugeGraph g = TargetAPI.graph(manager, graph);
        HugeTarget target = manager.authManager().getTarget(UserAPI.parseId(id));
        return manager.serializer((Graph)g).writeAuthElement((SchemaDefine.AuthElement)target);
    }

    @DELETE
    @Timed
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    public void delete(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="id") String id) {
        LOG.debug("Graph [{}] delete target: {}", (Object)graph, (Object)id);
        HugeGraph g = TargetAPI.graph(manager, graph);
        try {
            manager.authManager().deleteTarget(UserAPI.parseId(id));
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException("Invalid target id: " + id);
        }
    }

    @JsonIgnoreProperties(value={"id", "target_creator", "target_create", "target_update"})
    private static class JsonTarget
    implements Checkable {
        @JsonProperty(value="target_name")
        private String name;
        @JsonProperty(value="target_graph")
        private String graph;
        @JsonProperty(value="target_url")
        private String url;
        @JsonProperty(value="target_resources")
        private List<Map<String, Object>> resources;

        private JsonTarget() {
        }

        public HugeTarget build(HugeTarget target) {
            E.checkArgument((this.name == null || target.name().equals(this.name) ? 1 : 0) != 0, (String)"The name of target can't be updated", (Object[])new Object[0]);
            E.checkArgument((this.graph == null || target.graph().equals(this.graph) ? 1 : 0) != 0, (String)"The graph of target can't be updated", (Object[])new Object[0]);
            if (this.url != null) {
                target.url(this.url);
            }
            if (this.resources != null) {
                target.resources(JsonUtil.toJson(this.resources));
            }
            return target;
        }

        public HugeTarget build() {
            HugeTarget target = new HugeTarget(this.name, this.graph, this.url);
            if (this.resources != null) {
                target.resources(JsonUtil.toJson(this.resources));
            }
            return target;
        }

        @Override
        public void checkCreate(boolean isBatch) {
            E.checkArgumentNotNull((Object)this.name, (String)"The name of target can't be null", (Object[])new Object[0]);
            E.checkArgumentNotNull((Object)this.graph, (String)"The graph of target can't be null", (Object[])new Object[0]);
            E.checkArgumentNotNull((Object)this.url, (String)"The url of target can't be null", (Object[])new Object[0]);
        }

        @Override
        public void checkUpdate() {
            E.checkArgument((this.url != null || this.resources != null ? 1 : 0) != 0, (String)"Expect one of target url/resources", (Object[])new Object[0]);
        }
    }
}

