/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.metrics;

import com.codahale.metrics.annotation.Timed;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Singleton;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.metrics.MetricsModule;
import org.apache.hugegraph.metrics.ServerReporter;
import org.apache.hugegraph.metrics.SystemMetrics;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.shaded.jackson.databind.Module;
import org.slf4j.Logger;

@Singleton
@Path(value="metrics")
@Tag(name="MetricsAPI")
public class MetricsAPI
extends API {
    private static final Logger LOG = Log.logger(MetricsAPI.class);
    private SystemMetrics systemMetrics = new SystemMetrics();

    @GET
    @Timed
    @Path(value="system")
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner= $action=metrics_read"})
    public String system() {
        return JsonUtil.toJson(this.systemMetrics.metrics());
    }

    @GET
    @Timed
    @Path(value="backend")
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner= $action=metrics_read"})
    public String backend(@Context GraphManager manager) {
        Map results = InsertionOrderUtil.newMap();
        for (String graph : manager.graphs()) {
            HugeGraph g = manager.graph(graph);
            Map metrics = InsertionOrderUtil.newMap();
            metrics.put("backend", g.backend());
            try {
                metrics.putAll((Map)g.metadata(null, "metrics", new Object[0]));
            }
            catch (Throwable e) {
                metrics.put("exception", e.toString());
                LOG.debug("Failed to get backend metrics", e);
            }
            results.put(graph, metrics);
        }
        return JsonUtil.toJson((Object)results);
    }

    @GET
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner= $action=metrics_read"})
    public String all() {
        ServerReporter reporter = ServerReporter.instance();
        LinkedHashMap<String, Map<String, Object>> result = new LinkedHashMap<String, Map<String, Object>>();
        result.put("gauges", reporter.gauges());
        result.put("counters", reporter.counters());
        result.put("histograms", reporter.histograms());
        result.put("meters", reporter.meters());
        result.put("timers", reporter.timers());
        return JsonUtil.toJson(result);
    }

    @GET
    @Timed
    @Path(value="gauges")
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner= $action=metrics_read"})
    public String gauges() {
        ServerReporter reporter = ServerReporter.instance();
        return JsonUtil.toJson(reporter.gauges());
    }

    @GET
    @Timed
    @Path(value="counters")
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner= $action=metrics_read"})
    public String counters() {
        ServerReporter reporter = ServerReporter.instance();
        return JsonUtil.toJson(reporter.counters());
    }

    @GET
    @Timed
    @Path(value="histograms")
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner= $action=metrics_read"})
    public String histograms() {
        ServerReporter reporter = ServerReporter.instance();
        return JsonUtil.toJson(reporter.histograms());
    }

    @GET
    @Timed
    @Path(value="meters")
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner= $action=metrics_read"})
    public String meters() {
        ServerReporter reporter = ServerReporter.instance();
        return JsonUtil.toJson(reporter.meters());
    }

    @GET
    @Timed
    @Path(value="timers")
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner= $action=metrics_read"})
    public String timers() {
        ServerReporter reporter = ServerReporter.instance();
        return JsonUtil.toJson(reporter.timers());
    }

    static {
        JsonUtil.registerModule((Module)new MetricsModule(TimeUnit.SECONDS, TimeUnit.MILLISECONDS, false));
    }
}

