/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.schema;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.filter.StatusFilter;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.define.Checkable;
import org.apache.hugegraph.schema.IndexLabel;
import org.apache.hugegraph.schema.SchemaElement;
import org.apache.hugegraph.schema.Userdata;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.GraphMode;
import org.apache.hugegraph.type.define.IndexType;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;

@Path(value="graphs/{graph}/schema/indexlabels")
@Singleton
@Tag(name="IndexLabelAPI")
public class IndexLabelAPI
extends API {
    private static final Logger LOG = Log.logger(IndexLabelAPI.class);

    @POST
    @Timed
    @StatusFilter.Status(value=202)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$graph $action=index_label_write"})
    public String create(@Context GraphManager manager, @PathParam(value="graph") String graph, JsonIndexLabel jsonIndexLabel) {
        LOG.debug("Graph [{}] create index label: {}", (Object)graph, (Object)jsonIndexLabel);
        IndexLabelAPI.checkCreatingBody(jsonIndexLabel);
        HugeGraph g = IndexLabelAPI.graph(manager, graph);
        IndexLabel.Builder builder = jsonIndexLabel.convert2Builder(g);
        SchemaElement.TaskWithSchema il = builder.createWithTask();
        il.indexLabel(IndexLabelAPI.mapIndexLabel(il.indexLabel()));
        return manager.serializer((Graph)g).writeTaskWithSchema(il);
    }

    @PUT
    @Timed
    @Path(value="{name}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String update(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="name") String name, @QueryParam(value="action") String action, JsonIndexLabel jsonIndexLabel) {
        LOG.debug("Graph [{}] {} index label: {}", new Object[]{graph, action, jsonIndexLabel});
        IndexLabelAPI.checkUpdatingBody(jsonIndexLabel);
        E.checkArgument((boolean)name.equals(jsonIndexLabel.name), (String)"The name in url(%s) and body(%s) are different", (Object[])new Object[]{name, jsonIndexLabel.name});
        boolean append = IndexLabelAPI.checkAndParseAction(action);
        HugeGraph g = IndexLabelAPI.graph(manager, graph);
        IndexLabel.Builder builder = jsonIndexLabel.convert2Builder(g);
        IndexLabel indexLabel = append ? (IndexLabel)builder.append() : (IndexLabel)builder.eliminate();
        return manager.serializer((Graph)g).writeIndexlabel(IndexLabelAPI.mapIndexLabel(indexLabel));
    }

    @GET
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$graph $action=index_label_read"})
    public String list(@Context GraphManager manager, @PathParam(value="graph") String graph, @QueryParam(value="names") List<String> names) {
        ArrayList<IndexLabel> labels;
        boolean listAll = CollectionUtils.isEmpty(names);
        if (listAll) {
            LOG.debug("Graph [{}] list index labels", (Object)graph);
        } else {
            LOG.debug("Graph [{}] get index labels by names {}", (Object)graph, names);
        }
        HugeGraph g = IndexLabelAPI.graph(manager, graph);
        if (listAll) {
            labels = g.schema().getIndexLabels();
        } else {
            labels = new ArrayList<IndexLabel>(names.size());
            for (String name : names) {
                labels.add(g.schema().getIndexLabel(name));
            }
        }
        return manager.serializer((Graph)g).writeIndexlabels(IndexLabelAPI.mapIndexLabels(labels));
    }

    @GET
    @Timed
    @Path(value="{name}")
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$graph $action=index_label_read"})
    public String get(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="name") String name) {
        LOG.debug("Graph [{}] get index label by name '{}'", (Object)graph, (Object)name);
        HugeGraph g = IndexLabelAPI.graph(manager, graph);
        IndexLabel indexLabel = g.schema().getIndexLabel(name);
        return manager.serializer((Graph)g).writeIndexlabel(IndexLabelAPI.mapIndexLabel(indexLabel));
    }

    @DELETE
    @Timed
    @Path(value="{name}")
    @StatusFilter.Status(value=202)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin", "$owner=$graph $action=index_label_delete"})
    public Map<String, Id> delete(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="name") String name) {
        LOG.debug("Graph [{}] remove index label by name '{}'", (Object)graph, (Object)name);
        HugeGraph g = IndexLabelAPI.graph(manager, graph);
        g.schema().getIndexLabel(name);
        return ImmutableMap.of((Object)"task_id", (Object)g.schema().indexLabel(name).remove());
    }

    private static List<IndexLabel> mapIndexLabels(List<IndexLabel> labels) {
        ArrayList<IndexLabel> results = new ArrayList<IndexLabel>(labels.size());
        for (IndexLabel il : labels) {
            results.add(IndexLabelAPI.mapIndexLabel(il));
        }
        return results;
    }

    private static IndexLabel mapIndexLabel(IndexLabel label) {
        if (label.indexType().isRange()) {
            label = (IndexLabel)label.copy();
            label.indexType(IndexType.RANGE);
        }
        return label;
    }

    @JsonIgnoreProperties(value={"status"})
    private static class JsonIndexLabel
    implements Checkable {
        @JsonProperty(value="id")
        public long id;
        @JsonProperty(value="name")
        public String name;
        @JsonProperty(value="base_type")
        public HugeType baseType;
        @JsonProperty(value="base_value")
        public String baseValue;
        @JsonProperty(value="index_type")
        public IndexType indexType;
        @JsonProperty(value="fields")
        public String[] fields;
        @JsonProperty(value="user_data")
        public Userdata userdata;
        @JsonProperty(value="check_exist")
        public Boolean checkExist;
        @JsonProperty(value="rebuild")
        public Boolean rebuild;

        private JsonIndexLabel() {
        }

        @Override
        public void checkCreate(boolean isBatch) {
            E.checkArgumentNotNull((Object)this.name, (String)"The name of index label can't be null", (Object[])new Object[0]);
            E.checkArgumentNotNull((Object)this.baseType, (String)"The base type of index label '%s' can't be null", (Object[])new Object[]{this.name});
            E.checkArgument((this.baseType == HugeType.VERTEX_LABEL || this.baseType == HugeType.EDGE_LABEL ? 1 : 0) != 0, (String)"The base type of index label '%s' can only be either VERTEX_LABEL or EDGE_LABEL", (Object[])new Object[]{this.name});
            E.checkArgumentNotNull((Object)this.baseValue, (String)"The base value of index label '%s' can't be null", (Object[])new Object[]{this.name});
            E.checkArgumentNotNull((Object)this.indexType, (String)"The index type of index label '%s' can't be null", (Object[])new Object[]{this.name});
        }

        @Override
        public void checkUpdate() {
            E.checkArgumentNotNull((Object)this.name, (String)"The name of index label can't be null", (Object[])new Object[0]);
            E.checkArgument((this.baseType == null ? 1 : 0) != 0, (String)"The base type of index label '%s' must be null", (Object[])new Object[]{this.name});
            E.checkArgument((this.baseValue == null ? 1 : 0) != 0, (String)"The base value of index label '%s' must be null", (Object[])new Object[]{this.name});
            E.checkArgument((this.indexType == null ? 1 : 0) != 0, (String)"The index type of index label '%s' must be null", (Object[])new Object[]{this.name});
        }

        private IndexLabel.Builder convert2Builder(HugeGraph g) {
            IndexLabel.Builder builder = g.schema().indexLabel(this.name);
            if (this.id != 0L) {
                E.checkArgument((this.id > 0L ? 1 : 0) != 0, (String)"Only positive number can be assign as index label id", (Object[])new Object[0]);
                E.checkArgument((g.mode() == GraphMode.RESTORING ? 1 : 0) != 0, (String)"Only accept index label id when graph in RESTORING mode, but '%s' is in mode '%s'", (Object[])new Object[]{g, g.mode()});
                builder.id(this.id);
            }
            if (this.baseType != null) {
                assert (this.baseValue != null);
                builder.on(this.baseType, this.baseValue);
            }
            if (this.indexType != null) {
                builder.indexType(this.indexType);
            }
            if (this.fields != null && this.fields.length > 0) {
                builder.by(this.fields);
            }
            if (this.userdata != null) {
                builder.userdata((Map)this.userdata);
            }
            if (this.checkExist != null) {
                builder.checkExist(this.checkExist.booleanValue());
            }
            if (this.rebuild != null) {
                builder.rebuild(this.rebuild.booleanValue());
            }
            return builder;
        }

        public String toString() {
            return String.format("JsonIndexLabel{name=%s, baseType=%s,baseValue=%s, indexType=%s, fields=%s}", this.name, this.baseType, this.baseValue, this.indexType, this.fields);
        }
    }
}

