/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traversers;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.traversers.Vertices;
import org.apache.hugegraph.backend.query.QueryResults;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.traversal.algorithm.CustomizePathsTraverser;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.steps.WeightedEdgeStep;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;

@Path(value="graphs/{graph}/traversers/customizedpaths")
@Singleton
@Tag(name="CustomizedPathsAPI")
public class CustomizedPathsAPI
extends API {
    private static final Logger LOG = Log.logger(CustomizedPathsAPI.class);

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String post(@Context GraphManager manager, @PathParam(value="graph") String graph, PathRequest request) {
        E.checkArgumentNotNull((Object)request, (String)"The path request body can't be null", (Object[])new Object[0]);
        E.checkArgumentNotNull((Object)request.sources, (String)"The sources of path request can't be null", (Object[])new Object[0]);
        E.checkArgument((request.steps != null && !request.steps.isEmpty() ? 1 : 0) != 0, (String)"The steps of path request can't be empty", (Object[])new Object[0]);
        if (request.sortBy == null) {
            request.sortBy = SortBy.NONE;
        }
        LOG.debug("Graph [{}] get customized paths from source vertex '{}', with steps '{}', sort by '{}', capacity '{}', limit '{}' and with_vertex '{}'", new Object[]{graph, request.sources, request.steps, request.sortBy, request.capacity, request.limit, request.withVertex});
        HugeGraph g = CustomizedPathsAPI.graph(manager, graph);
        Iterator<Vertex> sources = request.sources.vertices(g);
        List<WeightedEdgeStep> steps = CustomizedPathsAPI.step(g, request);
        boolean sorted = request.sortBy != SortBy.NONE;
        CustomizePathsTraverser traverser = new CustomizePathsTraverser(g);
        List paths = traverser.customizedPaths(sources, steps, sorted, request.capacity, (long)request.limit);
        if (sorted) {
            boolean incr = request.sortBy == SortBy.INCR;
            paths = CustomizePathsTraverser.topNPath((List)paths, (boolean)incr, (long)request.limit);
        }
        if (!request.withVertex) {
            return manager.serializer((Graph)g).writePaths("paths", paths, false);
        }
        HashSet ids = new HashSet();
        for (HugeTraverser.Path p : paths) {
            ids.addAll(p.vertices());
        }
        Iterator iter = QueryResults.emptyIterator();
        if (!ids.isEmpty()) {
            iter = g.vertices(ids.toArray());
        }
        return manager.serializer((Graph)g).writePaths("paths", paths, false, iter);
    }

    private static List<WeightedEdgeStep> step(HugeGraph graph, PathRequest req) {
        int stepSize = req.steps.size();
        ArrayList<WeightedEdgeStep> steps = new ArrayList<WeightedEdgeStep>(stepSize);
        for (Step step : req.steps) {
            steps.add(step.jsonToStep(graph));
        }
        return steps;
    }

    private static enum SortBy {
        INCR,
        DECR,
        NONE;

    }

    private static class Step {
        @JsonProperty(value="direction")
        public Directions direction;
        @JsonProperty(value="labels")
        public List<String> labels;
        @JsonProperty(value="properties")
        public Map<String, Object> properties;
        @JsonAlias(value={"degree"})
        @JsonProperty(value="max_degree")
        public long maxDegree = Long.parseLong("10000");
        @JsonProperty(value="skip_degree")
        public long skipDegree = 0L;
        @JsonProperty(value="weight_by")
        public String weightBy;
        @JsonProperty(value="default_weight")
        public double defaultWeight = Double.parseDouble("0");
        @JsonProperty(value="sample")
        public long sample = Long.parseLong("100");

        private Step() {
        }

        public String toString() {
            return String.format("Step{direction=%s,labels=%s,properties=%s,maxDegree=%s,skipDegree=%s,weightBy=%s,defaultWeight=%s,sample=%s}", this.direction, this.labels, this.properties, this.maxDegree, this.skipDegree, this.weightBy, this.defaultWeight, this.sample);
        }

        private WeightedEdgeStep jsonToStep(HugeGraph g) {
            return new WeightedEdgeStep(g, this.direction, this.labels, this.properties, this.maxDegree, this.skipDegree, this.weightBy, this.defaultWeight, this.sample);
        }
    }

    private static class PathRequest {
        @JsonProperty(value="sources")
        public Vertices sources;
        @JsonProperty(value="steps")
        public List<Step> steps;
        @JsonProperty(value="sort_by")
        public SortBy sortBy;
        @JsonProperty(value="capacity")
        public long capacity = Long.parseLong("10000000");
        @JsonProperty(value="limit")
        public int limit = Integer.parseInt("10");
        @JsonProperty(value="with_vertex")
        public boolean withVertex = false;

        private PathRequest() {
        }

        public String toString() {
            return String.format("PathRequest{sourceVertex=%s,steps=%s,sortBy=%s,capacity=%s,limit=%s,withVertex=%s}", new Object[]{this.sources, this.steps, this.sortBy, this.capacity, this.limit, this.withVertex});
        }
    }
}

