/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traversers;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import java.util.ArrayList;
import java.util.List;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.traversal.algorithm.NeighborRankTraverser;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;

@Path(value="graphs/{graph}/traversers/neighborrank")
@Singleton
@Tag(name="NeighborRankAPI")
public class NeighborRankAPI
extends API {
    private static final Logger LOG = Log.logger(NeighborRankAPI.class);

    @POST
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    public String neighborRank(@Context GraphManager manager, @PathParam(value="graph") String graph, RankRequest request) {
        E.checkArgumentNotNull((Object)request, (String)"The rank request body can't be null", (Object[])new Object[0]);
        E.checkArgumentNotNull((Object)request.source, (String)"The source of rank request can't be null", (Object[])new Object[0]);
        E.checkArgument((request.steps != null && !request.steps.isEmpty() ? 1 : 0) != 0, (String)"The steps of rank request can't be empty", (Object[])new Object[0]);
        E.checkArgument((request.steps.size() <= 5000 ? 1 : 0) != 0, (String)"The steps length of rank request can't exceed %s", (Object[])new Object[]{5000});
        E.checkArgument((request.alpha > 0.0 && request.alpha <= 1.0 ? 1 : 0) != 0, (String)"The alpha of rank request must be in range (0, 1], but got '%s'", (Object[])new Object[]{request.alpha});
        LOG.debug("Graph [{}] get neighbor rank from '{}' with steps '{}', alpha '{}' and capacity '{}'", new Object[]{graph, request.source, request.steps, request.alpha, request.capacity});
        Id sourceId = HugeVertex.getIdValue((Object)request.source);
        HugeGraph g = NeighborRankAPI.graph(manager, graph);
        List<NeighborRankTraverser.Step> steps = NeighborRankAPI.steps(g, request);
        NeighborRankTraverser traverser = new NeighborRankTraverser(g, request.alpha, request.capacity);
        List ranks = traverser.neighborRank(sourceId, steps);
        return manager.serializer((Graph)g).writeList("ranks", ranks);
    }

    private static List<NeighborRankTraverser.Step> steps(HugeGraph graph, RankRequest req) {
        ArrayList<NeighborRankTraverser.Step> steps = new ArrayList<NeighborRankTraverser.Step>();
        for (Step step : req.steps) {
            steps.add(step.jsonToStep(graph));
        }
        return steps;
    }

    private static class Step {
        @JsonProperty(value="direction")
        public Directions direction;
        @JsonProperty(value="labels")
        public List<String> labels;
        @JsonAlias(value={"degree"})
        @JsonProperty(value="max_degree")
        public long maxDegree = Long.parseLong("10000");
        @JsonProperty(value="skip_degree")
        public long skipDegree = 0L;
        @JsonProperty(value="top")
        public int top = Integer.parseInt("10");
        public static final int DEFAULT_CAPACITY_PER_LAYER = 100000;

        private Step() {
        }

        public String toString() {
            return String.format("Step{direction=%s,labels=%s,maxDegree=%s,top=%s}", this.direction, this.labels, this.maxDegree, this.top);
        }

        private NeighborRankTraverser.Step jsonToStep(HugeGraph g) {
            return new NeighborRankTraverser.Step(g, this.direction, this.labels, this.maxDegree, this.skipDegree, this.top, 100000);
        }
    }

    private static class RankRequest {
        @JsonProperty(value="source")
        private Object source;
        @JsonProperty(value="steps")
        private List<Step> steps;
        @JsonProperty(value="alpha")
        private double alpha;
        @JsonProperty(value="capacity")
        public long capacity = Long.parseLong("10000000");

        private RankRequest() {
        }

        public String toString() {
            return String.format("RankRequest{source=%s,steps=%s,alpha=%s,capacity=%s}", this.source, this.steps, this.alpha, this.capacity);
        }
    }
}

