/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traversers;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.graph.EdgeAPI;
import org.apache.hugegraph.api.graph.VertexAPI;
import org.apache.hugegraph.api.traversers.TraverserAPI;
import org.apache.hugegraph.api.traversers.Vertices;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.query.QueryResults;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.traversal.algorithm.CollectionPathsTraverser;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.PathsTraverser;
import org.apache.hugegraph.traversal.algorithm.steps.EdgeStep;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;

@Path(value="graphs/{graph}/traversers/paths")
@Singleton
@Tag(name="PathsAPI")
public class PathsAPI
extends TraverserAPI {
    private static final Logger LOG = Log.logger(PathsAPI.class);

    @GET
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    public String get(@Context GraphManager manager, @PathParam(value="graph") String graph, @QueryParam(value="source") String source, @QueryParam(value="target") String target, @QueryParam(value="direction") String direction, @QueryParam(value="label") String edgeLabel, @QueryParam(value="max_depth") int depth, @QueryParam(value="max_degree") @DefaultValue(value="10000") long maxDegree, @QueryParam(value="capacity") @DefaultValue(value="10000000") long capacity, @QueryParam(value="limit") @DefaultValue(value="10") int limit) {
        LOG.debug("Graph [{}] get paths from '{}', to '{}' with direction {}, edge label {}, max depth '{}', max degree '{}', capacity '{}' and limit '{}'", new Object[]{graph, source, target, direction, edgeLabel, depth, maxDegree, capacity, limit});
        Id sourceId = VertexAPI.checkAndParseVertexId(source);
        Id targetId = VertexAPI.checkAndParseVertexId(target);
        Directions dir = Directions.convert((Direction)EdgeAPI.parseDirection(direction));
        HugeGraph g = PathsAPI.graph(manager, graph);
        PathsTraverser traverser = new PathsTraverser(g);
        HugeTraverser.PathSet paths = traverser.paths(sourceId, dir, targetId, dir.opposite(), edgeLabel, depth, maxDegree, capacity, (long)limit);
        return manager.serializer((Graph)g).writePaths("paths", (Collection<HugeTraverser.Path>)paths, false);
    }

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String post(@Context GraphManager manager, @PathParam(value="graph") String graph, Request request) {
        E.checkArgumentNotNull((Object)request, (String)"The request body can't be null", (Object[])new Object[0]);
        E.checkArgumentNotNull((Object)request.sources, (String)"The sources of request can't be null", (Object[])new Object[0]);
        E.checkArgumentNotNull((Object)request.targets, (String)"The targets of request can't be null", (Object[])new Object[0]);
        E.checkArgumentNotNull((Object)request.step, (String)"The step of request can't be null", (Object[])new Object[0]);
        E.checkArgument((request.depth > 0 && request.depth <= 5000 ? 1 : 0) != 0, (String)"The depth of request must be in (0, %s], but got: %s", (Object[])new Object[]{5000, request.depth});
        LOG.debug("Graph [{}] get paths from source vertices '{}', target vertices '{}', with step '{}', max depth '{}', capacity '{}', limit '{}' and with_vertex '{}'", new Object[]{graph, request.sources, request.targets, request.step, request.depth, request.capacity, request.limit, request.withVertex});
        HugeGraph g = PathsAPI.graph(manager, graph);
        Iterator<Vertex> sources = request.sources.vertices(g);
        Iterator<Vertex> targets = request.targets.vertices(g);
        EdgeStep step = PathsAPI.step(g, request.step);
        CollectionPathsTraverser traverser = new CollectionPathsTraverser(g);
        Collection paths = traverser.paths(sources, targets, step, request.depth, request.nearest, request.capacity, (long)request.limit);
        if (!request.withVertex) {
            return manager.serializer((Graph)g).writePaths("paths", paths, false);
        }
        HashSet ids = new HashSet();
        for (HugeTraverser.Path p : paths) {
            ids.addAll(p.vertices());
        }
        Iterator iter = QueryResults.emptyIterator();
        if (!ids.isEmpty()) {
            iter = g.vertices(ids.toArray());
        }
        return manager.serializer((Graph)g).writePaths("paths", paths, false, iter);
    }

    private static class Request {
        @JsonProperty(value="sources")
        public Vertices sources;
        @JsonProperty(value="targets")
        public Vertices targets;
        @JsonProperty(value="step")
        public TraverserAPI.Step step;
        @JsonProperty(value="max_depth")
        public int depth;
        @JsonProperty(value="nearest")
        public boolean nearest = false;
        @JsonProperty(value="capacity")
        public long capacity = Long.parseLong("10000000");
        @JsonProperty(value="limit")
        public int limit = Integer.parseInt("10");
        @JsonProperty(value="with_vertex")
        public boolean withVertex = false;

        private Request() {
        }

        public String toString() {
            return String.format("PathRequest{sources=%s,targets=%s,step=%s,maxDepth=%s,nearest=%s,capacity=%s,limit=%s,withVertex=%s}", this.sources, this.targets, this.step, this.depth, this.nearest, this.capacity, this.limit, this.withVertex);
        }
    }
}

