/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.auth;

import com.codahale.metrics.ScheduledReporter;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration2.Configuration;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeFactory;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.StandardHugeGraph;
import org.apache.hugegraph.auth.ConfigAuthenticator;
import org.apache.hugegraph.auth.EntityManager;
import org.apache.hugegraph.auth.HugeAuthenticator;
import org.apache.hugegraph.auth.HugeGraphAuthProxy;
import org.apache.hugegraph.auth.RelationshipManager;
import org.apache.hugegraph.auth.SchemaDefine;
import org.apache.hugegraph.auth.StandardAuthManager;
import org.apache.hugegraph.auth.StandardAuthenticator;
import org.apache.hugegraph.backend.cache.CacheManager;
import org.apache.hugegraph.backend.tx.AbstractTransaction;
import org.apache.hugegraph.backend.tx.GraphTransaction;
import org.apache.hugegraph.backend.tx.IndexableTransaction;
import org.apache.hugegraph.concurrent.LockManager;
import org.apache.hugegraph.metrics.ServerReporter;
import org.apache.hugegraph.schema.SchemaElement;
import org.apache.hugegraph.schema.SchemaManager;
import org.apache.hugegraph.schema.builder.AbstractBuilder;
import org.apache.hugegraph.schema.builder.EdgeLabelBuilder;
import org.apache.hugegraph.schema.builder.IndexLabelBuilder;
import org.apache.hugegraph.schema.builder.PropertyKeyBuilder;
import org.apache.hugegraph.schema.builder.VertexLabelBuilder;
import org.apache.hugegraph.serializer.JsonSerializer;
import org.apache.hugegraph.structure.HugeEdge;
import org.apache.hugegraph.structure.HugeElement;
import org.apache.hugegraph.structure.HugeProperty;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.task.HugeTask;
import org.apache.hugegraph.task.StandardTaskScheduler;
import org.apache.hugegraph.task.TaskCallable;
import org.apache.hugegraph.task.TaskManager;
import org.apache.hugegraph.traversal.optimize.HugeCountStepStrategy;
import org.apache.hugegraph.traversal.optimize.HugeGraphStepStrategy;
import org.apache.hugegraph.traversal.optimize.HugeVertexStepStrategy;
import org.apache.hugegraph.util.Reflection;
import org.apache.hugegraph.variables.HugeVariables;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticatedUser;
import org.apache.tinkerpop.gremlin.structure.util.AbstractThreadLocalTransaction;

public final class HugeFactoryAuthProxy {
    public static final String GRAPH_FACTORY = "gremlin.graph=org.apache.hugegraph.auth.HugeFactoryAuthProxy";
    private static final Set<String> PROTECT_METHODS = ImmutableSet.of((Object)"instance");
    private static final Map<HugeGraph, HugeGraph> GRAPHS = new HashMap<HugeGraph, HugeGraph>();

    public static synchronized HugeGraph open(Configuration config) {
        HugeGraph graph = HugeFactory.open((Configuration)config);
        HugeGraph proxy = GRAPHS.get(graph);
        if (proxy == null) {
            proxy = new HugeGraphAuthProxy(graph);
            GRAPHS.put(graph, proxy);
        }
        return proxy;
    }

    private static void registerPrivateActions() {
        Reflection.registerFieldsToFilter(Thread.class, (String[])new String[]{"name", "priority", "threadQ", "eetop", "single_step", "daemon", "stillborn", "target", "group", "contextClassLoader", "inheritedAccessControlContext", "threadInitNumber", "threadLocals", "inheritableThreadLocals", "stackSize", "nativeParkEventPointer", "tid", "threadSeqNumber", "threadStatus", "parkBlocker", "blocker", "blockerLock", "EMPTY_STACK_TRACE", "SUBCLASS_IMPLEMENTATION_PERMISSION", "uncaughtExceptionHandler", "defaultUncaughtExceptionHandler", "threadLocalRandomSeed", "threadLocalRandomSecondarySeed"});
        Reflection.registerMethodsToFilter(Thread.class, (String[])new String[]{"exit", "dispatchUncaughtException", "clone", "isInterrupted", "registerNatives", "init", "init", "nextThreadNum", "nextThreadID", "blockedOn", "start0", "isCCLOverridden", "auditSubclass", "dumpThreads", "getThreads", "processQueue", "setPriority0", "stop0", "suspend0", "resume0", "interrupt0", "setNativeName"});
        Reflection.registerFieldsToFilter(ThreadLocal.class, (String[])new String[]{"threadLocalHashCode", "nextHashCode", "HASH_INCREMENT"});
        Reflection.registerMethodsToFilter(ThreadLocal.class, (String[])new String[]{"access$400", "createInheritedMap", "nextHashCode", "initialValue", "setInitialValue", "getMap", "createMap", "childValue"});
        Reflection.registerMethodsToFilter(InheritableThreadLocal.class, (String[])new String[]{"getMap", "createMap", "childValue"});
        Reflection.registerFieldsToFilter(StandardAuthenticator.class, (String[])new String[]{"graph"});
        Reflection.registerMethodsToFilter(StandardAuthenticator.class, (String[])new String[]{"initAdminUser", "inputPassword", "graph"});
        Reflection.registerFieldsToFilter(ConfigAuthenticator.class, (String[])new String[]{"tokens"});
        Reflection.registerFieldsToFilter(HugeFactoryAuthProxy.class, (String[])new String[]{"PROTECT_METHODS"});
        Reflection.registerMethodsToFilter(HugeFactoryAuthProxy.class, (String[])new String[]{"genRegisterPrivateActions", "registerClass", "registerPrivateActions", "registerPrivateActions", "c"});
        Reflection.registerFieldsToFilter(HugeAuthenticator.User.class, (String[])new String[]{"role", "client"});
        Reflection.registerFieldsToFilter(AuthenticatedUser.class, (String[])new String[]{"name"});
        Reflection.registerFieldsToFilter(HugeGraphAuthProxy.class, (String[])new String[]{"LOG", "hugegraph", "taskScheduler", "authManager", "contexts", "$assertionsDisabled"});
        Reflection.registerMethodsToFilter(HugeGraphAuthProxy.class, (String[])new String[]{"lambda$0", "access$3", "access$4", "access$2", "access$5", "resetContext", "logUser", "verifyAdminPermission", "verifyStatusPermission", "verifyPermission", "verifySchemaPermission", "verifySchemaPermission", "verifySchemaPermission", "verifySchemaPermission", "verifyNamePermission", "verifyNameExistsPermission", "verifyElemPermission", "verifyElemPermission", "verifyElemPermission", "verifyElemPermission", "verifyResPermission", "verifyResPermission", "verifyUserPermission", "verifyUserPermission", "verifyUserPermission", "getContextString", "access$6", "access$7", "lambda$1", "lambda$2", "lambda$3", "lambda$4", "lambda$5", "lambda$6", "lambda$7", "lambda$8", "lambda$9", "lambda$10", "lambda$11", "lambda$12", "lambda$13", "lambda$14", "lambda$15", "lambda$16", "lambda$17", "lambda$18", "lambda$19", "lambda$20", "lambda$21", "lambda$22", "lambda$23", "lambda$24", "access$8", "access$9", "access$10", "setContext", "getContext"});
        Reflection.registerFieldsToFilter(HugeGraphAuthProxy.AuthManagerProxy.class, (String[])new String[]{"authManager", "this$0"});
        Reflection.registerMethodsToFilter(HugeGraphAuthProxy.AuthManagerProxy.class, (String[])new String[]{"currentUsername", "updateCreator"});
        Reflection.registerFieldsToFilter(HugeGraphAuthProxy.TaskSchedulerProxy.class, (String[])new String[]{"taskScheduler", "this$0"});
        Reflection.registerMethodsToFilter(HugeGraphAuthProxy.TaskSchedulerProxy.class, (String[])new String[]{"lambda$0", "lambda$1", "lambda$2", "verifyTaskPermission", "verifyTaskPermission", "verifyTaskPermission", "verifyTaskPermission", "hasTaskPermission"});
        Reflection.registerFieldsToFilter(HugeGraphAuthProxy.GraphTraversalSourceProxy.class, (String[])new String[]{"this$0"});
        Reflection.registerFieldsToFilter(GraphTraversalSource.class, (String[])new String[]{"connection", "graph", "strategies", "bytecode"});
        Reflection.registerFieldsToFilter(HugeGraphAuthProxy.TraversalStrategiesProxy.class, (String[])new String[]{"REST_WOEKER", "serialVersionUID", "strategies", "this$0"});
        Reflection.registerMethodsToFilter(HugeGraphAuthProxy.TraversalStrategiesProxy.class, (String[])new String[]{"translate"});
        Reflection.registerFieldsToFilter(HugeGraphAuthProxy.VariablesProxy.class, (String[])new String[]{"variables", "this$0"});
        Reflection.registerFieldsToFilter(HugeGraphAuthProxy.Context.class, (String[])new String[]{"ADMIN", "user"});
        Reflection.registerFieldsToFilter(HugeGraphAuthProxy.ContextTask.class, (String[])new String[]{"runner", "context"});
        Reflection.registerFieldsToFilter(StandardHugeGraph.class, (String[])new String[]{"LOG", "started", "closed", "mode", "variables", "name", "params", "configuration", "schemaEventHub", "graphEventHub", "indexEventHub", "writeRateLimiter", "readRateLimiter", "taskManager", "authManager", "features", "storeProvider", "tx", "ramtable", "$assertionsDisabled"});
        Reflection.registerMethodsToFilter(StandardHugeGraph.class, (String[])new String[]{"lambda$0", "access$3", "access$4", "access$2", "access$5", "access$6", "access$7", "waitUntilAllTasksCompleted", "access$8", "loadStoreProvider", "graphTransaction", "schemaTransaction", "openSchemaTransaction", "checkGraphNotClosed", "openSystemTransaction", "openGraphTransaction", "systemTransaction", "access$9", "access$10", "access$11", "access$12", "access$13", "access$14", "access$15", "access$16", "access$17", "access$18", "serializer", "loadSchemaStore", "loadSystemStore", "loadGraphStore", "closeTx", "analyzer", "serverInfoManager", "reloadRamtable", "reloadRamtable", "access$19", "access$20", "access$21"});
        Reflection.registerFieldsToFilter(HugeFactoryAuthProxy.loadClass("org.apache.hugegraph.StandardHugeGraph$StandardHugeGraphParams"), (String[])new String[]{"graph", "this$0"});
        Reflection.registerMethodsToFilter(HugeFactoryAuthProxy.loadClass("org.apache.hugegraph.StandardHugeGraph$StandardHugeGraphParams"), (String[])new String[]{"access$1", "graph"});
        Reflection.registerFieldsToFilter(HugeFactoryAuthProxy.loadClass("org.apache.hugegraph.StandardHugeGraph$TinkerPopTransaction"), (String[])new String[]{"refs", "opened", "transactions", "this$0", "$assertionsDisabled"});
        Reflection.registerMethodsToFilter(HugeFactoryAuthProxy.loadClass("org.apache.hugegraph.StandardHugeGraph$TinkerPopTransaction"), (String[])new String[]{"lambda$0", "access$3", "access$2", "lambda$1", "graphTransaction", "schemaTransaction", "systemTransaction", "access$1", "setOpened", "doCommit", "verifyOpened", "doRollback", "doClose", "destroyTransaction", "doOpen", "setClosed", "getOrNewTransaction", "access$0", "resetState"});
        Reflection.registerFieldsToFilter(AbstractThreadLocalTransaction.class, (String[])new String[]{"readWriteConsumerInternal", "closeConsumerInternal", "transactionListeners"});
        Reflection.registerMethodsToFilter(AbstractThreadLocalTransaction.class, (String[])new String[]{"doClose", "fireOnCommit", "fireOnRollback", "doReadWrite", "lambda$fireOnRollback$1", "lambda$fireOnCommit$0"});
        Reflection.registerFieldsToFilter(org.apache.tinkerpop.gremlin.structure.util.AbstractTransaction.class, (String[])new String[]{"g"});
        Reflection.registerMethodsToFilter(org.apache.tinkerpop.gremlin.structure.util.AbstractTransaction.class, (String[])new String[]{"doCommit", "doRollback", "doClose", "doOpen", "fireOnCommit", "fireOnRollback", "doReadWrite"});
        Reflection.registerFieldsToFilter(HugeFactoryAuthProxy.loadClass("org.apache.hugegraph.StandardHugeGraph$Txs"), (String[])new String[]{"schemaTx", "systemTx", "graphTx", "openedTime", "$assertionsDisabled"});
        Reflection.registerMethodsToFilter(HugeFactoryAuthProxy.loadClass("org.apache.hugegraph.StandardHugeGraph$Txs"), (String[])new String[]{"access$2", "access$1", "access$0"});
        Reflection.registerFieldsToFilter(GraphTransaction.class, (String[])new String[]{"indexTx", "addedVertices", "removedVertices", "addedEdges", "removedEdges", "addedProps", "removedProps", "updatedVertices", "updatedEdges", "updatedOldestProps", "locksTable", "checkCustomVertexExist", "checkAdjacentVertexExist", "lazyLoadAdjacentVertex", "ignoreInvalidEntry", "commitPartOfAdjacentEdges", "batchSize", "pageSize", "verticesCapacity", "edgesCapacity", "$assertionsDisabled", "$SWITCH_TABLE$com$baidu$hugegraph$type$define$IdStrategy"});
        Reflection.registerMethodsToFilter(GraphTransaction.class, (String[])new String[]{"lambda$0", "lambda$1", "lambda$2", "lambda$3", "lambda$4", "lambda$5", "lambda$6", "lambda$7", "lambda$8", "lambda$9", "lambda$10", "lambda$11", "lambda$12", "lambda$13", "lambda$14", "lambda$15", "lambda$16", "lambda$17", "lambda$18", "lambda$19", "access$1", "$SWITCH_TABLE$com$baidu$hugegraph$type$define$IdStrategy", "indexTransaction", "indexTransaction", "beforeWrite", "prepareCommit", "verticesInTxSize", "edgesInTxSize", "checkTxVerticesCapacity", "checkTxEdgesCapacity", "verticesInTxUpdated", "verticesInTxRemoved", "removingEdgeOwner", "prepareDeletions", "prepareDeletions", "prepareUpdates", "prepareAdditions", "checkVertexExistIfCustomizedId", "checkAggregateProperty", "checkAggregateProperty", "checkNonnullProperty", "queryEdgesFromBackend", "commitPartOfEdgeDeletions", "optimizeQueries", "checkVertexLabel", "checkId", "queryVerticesFromBackend", "joinTxVertices", "joinTxEdges", "lockForUpdateProperty", "optimizeQuery", "verifyVerticesConditionQuery", "verifyEdgesConditionQuery", "indexQuery", "joinTxRecords", "propertyUpdated", "parseEntry", "traverseByLabel", "reset", "queryVerticesByIds", "filterUnmatchedRecords", "skipOffsetOrStopLimit", "filterExpiredResultFromFromBackend", "queryEdgesByIds", "matchEdgeSortKeys", "rightResultFromIndexQuery"});
        Reflection.registerFieldsToFilter(IndexableTransaction.class, (String[])new String[]{"$assertionsDisabled"});
        Reflection.registerMethodsToFilter(IndexableTransaction.class, (String[])new String[]{"indexTransaction", "commit2Backend", "reset"});
        Reflection.registerFieldsToFilter(AbstractTransaction.class, (String[])new String[]{"LOG", "ownerThread", "autoCommit", "closed", "committing", "committing2Backend", "graph", "store", "mutation", "serializer", "$assertionsDisabled"});
        Reflection.registerMethodsToFilter(AbstractTransaction.class, (String[])new String[]{"beforeWrite", "prepareCommit", "params", "mutation", "commit2Backend", "autoCommit", "beforeRead", "afterWrite", "afterRead", "commitMutation2Backend", "checkOwnerThread", "doAction", "store", "reset"});
        Reflection.registerFieldsToFilter(HugeFactory.class, (String[])new String[]{"LOG", "NAME_REGEX", "graphs"});
        Reflection.registerMethodsToFilter(HugeFactory.class, (String[])new String[]{"lambda$0"});
        Reflection.registerFieldsToFilter(SchemaElement.class, (String[])new String[]{"graph", "id", "name", "userdata", "status"});
        Reflection.registerFieldsToFilter(HugeVertex.class, (String[])new String[]{"EMPTY_SET", "id", "label", "edges", "$assertionsDisabled", "$SWITCH_TABLE$com$baidu$hugegraph$type$define$IdStrategy", "$SWITCH_TABLE$com$baidu$hugegraph$type$define$HugeKeys"});
        Reflection.registerMethodsToFilter(HugeVertex.class, (String[])new String[]{"$SWITCH_TABLE$com$baidu$hugegraph$type$define$IdStrategy", "newProperty", "newProperty", "tx", "$SWITCH_TABLE$com$baidu$hugegraph$type$define$HugeKeys", "checkIdLength", "onUpdateProperty", "ensureFilledProperties", "clone", "clone"});
        Reflection.registerFieldsToFilter(HugeElement.class, (String[])new String[]{"EMPTY_MAP", "MAX_PROPERTIES", "graph", "properties", "expiredTime", "removed", "fresh", "propLoaded", "defaultValueUpdated", "$assertionsDisabled", "$SWITCH_TABLE$com$baidu$hugegraph$type$define$Cardinality"});
        Reflection.registerMethodsToFilter(HugeElement.class, (String[])new String[]{"removed", "addProperty", "newProperty", "tx", "onUpdateProperty", "ensureFilledProperties", "propLoaded", "$SWITCH_TABLE$com$baidu$hugegraph$type$define$Cardinality", "getIdValue", "fresh", "updateToDefaultValueIfNone", "copyProperties"});
        Reflection.registerFieldsToFilter(HugeEdge.class, (String[])new String[]{"id", "label", "name", "sourceVertex", "targetVertex", "isOutEdge", "$assertionsDisabled", "$SWITCH_TABLE$com$baidu$hugegraph$type$define$HugeKeys", "$SWITCH_TABLE$org$apache$tinkerpop$gremlin$structure$Direction"});
        Reflection.registerMethodsToFilter(HugeEdge.class, (String[])new String[]{"checkAdjacentVertexExist", "newProperty", "newProperty", "tx", "$SWITCH_TABLE$com$baidu$hugegraph$type$define$HugeKeys", "onUpdateProperty", "ensureFilledProperties", "$SWITCH_TABLE$org$apache$tinkerpop$gremlin$structure$Direction", "clone", "clone"});
        Reflection.registerFieldsToFilter(HugeProperty.class, (String[])new String[]{"owner", "pkey", "value"});
        Reflection.registerFieldsToFilter(HugeVariables.class, (String[])new String[]{"LOG", "VARIABLES", "VARIABLE_KEY", "VARIABLE_TYPE", "BYTE_VALUE", "BOOLEAN_VALUE", "INTEGER_VALUE", "LONG_VALUE", "FLOAT_VALUE", "DOUBLE_VALUE", "STRING_VALUE", "LIST", "SET", "TYPES", "params", "graph"});
        Reflection.registerMethodsToFilter(HugeVariables.class, (String[])new String[]{"createPropertyKey", "queryAllVariableVertices", "queryVariableVertex", "createVariableVertex", "removeVariableVertex", "extractSingleObject", "setProperty"});
        Reflection.registerFieldsToFilter(SchemaManager.class, (String[])new String[]{"transaction", "graph"});
        Reflection.registerMethodsToFilter(SchemaManager.class, (String[])new String[]{"lambda$0", "lambda$1", "lambda$2", "lambda$3", "checkExists"});
        Reflection.registerFieldsToFilter(PropertyKeyBuilder.class, (String[])new String[]{"id", "name", "dataType", "cardinality", "aggregateType", "checkExist", "userdata", "$assertionsDisabled"});
        Reflection.registerMethodsToFilter(PropertyKeyBuilder.class, (String[])new String[]{"lambda$0", "checkStableVars", "checkAggregateType", "hasSameProperties"});
        Reflection.registerFieldsToFilter(AbstractBuilder.class, (String[])new String[]{"transaction", "graph"});
        Reflection.registerMethodsToFilter(AbstractBuilder.class, (String[])new String[]{"rebuildIndex", "graph", "checkSchemaName", "validOrGenerateId", "lockCheckAndCreateSchema", "propertyKeyOrNull", "checkSchemaIdIfRestoringMode", "vertexLabelOrNull", "edgeLabelOrNull", "indexLabelOrNull", "updateSchemaStatus"});
        Reflection.registerFieldsToFilter(VertexLabelBuilder.class, (String[])new String[]{"id", "name", "idStrategy", "properties", "primaryKeys", "nullableKeys", "ttl", "ttlStartTime", "enableLabelIndex", "userdata", "checkExist", "$assertionsDisabled", "$SWITCH_TABLE$com$baidu$hugegraph$type$define$Action", "$SWITCH_TABLE$com$baidu$hugegraph$type$define$IdStrategy"});
        Reflection.registerMethodsToFilter(VertexLabelBuilder.class, (String[])new String[]{"lambda$0", "$SWITCH_TABLE$com$baidu$hugegraph$type$define$IdStrategy", "checkStableVars", "$SWITCH_TABLE$com$baidu$hugegraph$type$define$Action", "checkProperties", "checkNullableKeys", "checkIdStrategy", "checkPrimaryKeys", "hasSameProperties", "checkTtl", "checkUserdata", "mapPkId2Name", "mapPkId2Name"});
        Reflection.registerFieldsToFilter(EdgeLabelBuilder.class, (String[])new String[]{"id", "name", "sourceLabel", "targetLabel", "frequency", "properties", "sortKeys", "nullableKeys", "ttl", "ttlStartTime", "enableLabelIndex", "userdata", "checkExist", "$assertionsDisabled", "$SWITCH_TABLE$com$baidu$hugegraph$type$define$Action"});
        Reflection.registerMethodsToFilter(EdgeLabelBuilder.class, (String[])new String[]{"lambda$0", "checkStableVars", "$SWITCH_TABLE$com$baidu$hugegraph$type$define$Action", "checkProperties", "checkNullableKeys", "checkSortKeys", "checkRelation", "hasSameProperties", "checkTtl", "checkUserdata", "mapPkId2Name", "mapPkId2Name"});
        Reflection.registerFieldsToFilter(IndexLabelBuilder.class, (String[])new String[]{"id", "name", "baseType", "baseValue", "indexType", "indexFields", "userdata", "checkExist", "rebuild", "$assertionsDisabled", "$SWITCH_TABLE$com$baidu$hugegraph$type$define$DataType", "$SWITCH_TABLE$com$baidu$hugegraph$type$define$IndexType"});
        Reflection.registerMethodsToFilter(IndexLabelBuilder.class, (String[])new String[]{"lambda$0", "checkStableVars", "$SWITCH_TABLE$com$baidu$hugegraph$type$define$DataType", "$SWITCH_TABLE$com$baidu$hugegraph$type$define$IndexType", "checkBaseType", "checkIndexType", "checkFields4Range", "loadElement", "checkFields", "checkRepeatIndex", "checkRepeatIndex", "checkRepeatIndex", "checkPrimaryKeyIndex", "checkRepeatRangeIndex", "checkRepeatSearchIndex", "checkRepeatSecondaryIndex", "checkRepeatShardIndex", "checkRepeatUniqueIndex", "removeSubIndex", "hasSubIndex", "allStringIndex", "oneNumericField", "hasSameProperties"});
        Reflection.registerFieldsToFilter(TaskManager.class, (String[])new String[]{"LOG", "SCHEDULE_PERIOD", "THREADS", "MANAGER", "schedulers", "taskExecutor", "taskDbExecutor", "serverInfoDbExecutor", "schedulerExecutor", "contexts", "$assertionsDisabled"});
        Reflection.registerMethodsToFilter(TaskManager.class, (String[])new String[]{"lambda$0", "resetContext", "closeTaskTx", "setContext", "instance", "closeSchedulerTx", "notifyNewTask", "scheduleOrExecuteJob", "scheduleOrExecuteJobForGraph"});
        Reflection.registerFieldsToFilter(StandardTaskScheduler.class, (String[])new String[]{"LOG", "graph", "serverManager", "taskExecutor", "taskDbExecutor", "eventListener", "tasks", "taskTx", "NO_LIMIT", "PAGE_SIZE", "QUERY_INTERVAL", "MAX_PENDING_TASKS", "$assertionsDisabled"});
        Reflection.registerMethodsToFilter(StandardTaskScheduler.class, (String[])new String[]{"lambda$0", "lambda$1", "lambda$2", "lambda$3", "lambda$4", "lambda$5", "lambda$6", "lambda$7", "tx", "listenChanges", "unlistenChanges", "submitTask", "queryTask", "queryTask", "queryTask", "call", "call", "remove", "sleep", "taskDone", "serverManager", "supportsPaging", "restore", "checkOnMasterNode", "waitUntilTaskCompleted", "scheduleTasks", "executeTasksOnWorker", "cancelTasksOnWorker"});
        Reflection.registerFieldsToFilter(HugeTask.class, (String[])new String[]{"LOG", "DECOMPRESS_RATIO", "scheduler", "callable", "type", "name", "id", "parent", "dependencies", "description", "context", "create", "server", "load", "status", "progress", "update", "retries", "input", "result", "$assertionsDisabled"});
        Reflection.registerMethodsToFilter(HugeTask.class, (String[])new String[]{"property", "scheduler", "scheduler", "asArray", "checkPropertySize", "checkPropertySize", "checkDependenciesSuccess", "toOrderSet", "done", "callable", "setException", "set", "result", "status"});
        Reflection.registerFieldsToFilter(TaskCallable.class, (String[])new String[]{"LOG", "ERROR_COMMIT", "ERROR_MESSAGES", "task", "graph", "lastSaveTime", "saveInterval"});
        Reflection.registerMethodsToFilter(TaskCallable.class, (String[])new String[]{"graph", "closeTx", "cancelled", "done", "task", "save", "needSaveWithEx"});
        Reflection.registerFieldsToFilter(TaskCallable.SysTaskCallable.class, (String[])new String[]{"params"});
        Reflection.registerMethodsToFilter(TaskCallable.SysTaskCallable.class, (String[])new String[]{"params", "params"});
        Reflection.registerFieldsToFilter(StandardAuthManager.class, (String[])new String[]{"CACHE_EXPIRE", "graph", "eventListener", "usersCache", "users", "groups", "targets", "belong", "access", "$assertionsDisabled"});
        Reflection.registerMethodsToFilter(StandardAuthManager.class, (String[])new String[]{"lambda$0", "listenChanges", "unlistenChanges", "invalidCache", "initSchemaIfNeeded", "rolePermission", "rolePermission", "rolePermission", "cache"});
        Reflection.registerFieldsToFilter(SchemaDefine.class, (String[])new String[]{"graph", "label"});
        Reflection.registerMethodsToFilter(SchemaDefine.class, (String[])new String[]{"schema", "createPropertyKey", "createPropertyKey", "createPropertyKey", "existEdgeLabel", "createRangeIndex", "unhideField", "hideField", "existVertexLabel", "initProperties"});
        Reflection.registerFieldsToFilter(EntityManager.class, (String[])new String[]{"graph", "label", "deser", "NO_LIMIT", "$assertionsDisabled"});
        Reflection.registerMethodsToFilter(EntityManager.class, (String[])new String[]{"toList", "graph", "tx", "commitOrRollback", "unhideLabel", "queryById", "queryEntity", "constructVertex", "save", "query"});
        Reflection.registerFieldsToFilter(RelationshipManager.class, (String[])new String[]{"graph", "label", "deser", "NO_LIMIT", "$assertionsDisabled"});
        Reflection.registerMethodsToFilter(RelationshipManager.class, (String[])new String[]{"lambda$0", "toList", "graph", "tx", "commitOrRollback", "unhideLabel", "queryById", "queryRelationship", "newVertex", "save"});
        Reflection.registerFieldsToFilter(CacheManager.class, (String[])new String[]{"LOG", "INSTANCE", "TIMER_TICK_PERIOD", "LOG_TICK_COST_TIME", "caches", "timer"});
        Reflection.registerMethodsToFilter(CacheManager.class, (String[])new String[]{"access$0", "scheduleTimer", "instance"});
        Reflection.registerFieldsToFilter(LockManager.class, (String[])new String[]{"INSTANCE", "lockGroupMap"});
        Reflection.registerMethodsToFilter(LockManager.class, (String[])new String[]{"instance"});
        Reflection.registerFieldsToFilter(ServerReporter.class, (String[])new String[]{"instance", "gauges", "counters", "histograms", "meters", "timers"});
        Reflection.registerMethodsToFilter(ServerReporter.class, (String[])new String[]{"instance", "instance"});
        Reflection.registerFieldsToFilter(ScheduledReporter.class, (String[])new String[]{"LOG", "FACTORY_ID", "registry", "executor", "shutdownExecutorOnStop", "disabledMetricAttributes", "scheduledFuture", "filter", "durationFactor", "durationUnit", "rateFactor", "rateUnit"});
        Reflection.registerMethodsToFilter(ScheduledReporter.class, (String[])new String[]{"convertDuration", "convertRate", "getRateUnit", "getDurationUnit", "isShutdownExecutorOnStop", "getDisabledMetricAttributes", "calculateRateUnit", "createDefaultExecutor", "lambda$start$0", "start"});
        Reflection.registerFieldsToFilter(JsonSerializer.class, (String[])new String[]{"LBUF_SIZE", "INSTANCE"});
        Reflection.registerMethodsToFilter(JsonSerializer.class, (String[])new String[]{"writeIterator", "instance"});
        Reflection.registerFieldsToFilter(HugeVertexStepStrategy.class, (String[])new String[]{"serialVersionUID", "INSTANCE"});
        Reflection.registerMethodsToFilter(HugeVertexStepStrategy.class, (String[])new String[]{"instance"});
        Reflection.registerFieldsToFilter(HugeGraphStepStrategy.class, (String[])new String[]{"serialVersionUID", "INSTANCE"});
        Reflection.registerMethodsToFilter(HugeGraphStepStrategy.class, (String[])new String[]{"instance"});
        Reflection.registerFieldsToFilter(HugeCountStepStrategy.class, (String[])new String[]{"serialVersionUID", "INSTANCE"});
        Reflection.registerMethodsToFilter(HugeCountStepStrategy.class, (String[])new String[]{"lambda$0", "instance"});
    }

    private static void genRegisterPrivateActions() {
        HugeFactoryAuthProxy.registerPrivateActions(Thread.class);
        HugeFactoryAuthProxy.registerPrivateActions(ThreadLocal.class);
        HugeFactoryAuthProxy.registerPrivateActions(InheritableThreadLocal.class);
        HugeFactoryAuthProxy.registerPrivateActions(StandardAuthenticator.class);
        HugeFactoryAuthProxy.registerPrivateActions(ConfigAuthenticator.class);
        HugeFactoryAuthProxy.registerPrivateActions(HugeFactoryAuthProxy.class);
        HugeFactoryAuthProxy.registerPrivateActions(HugeAuthenticator.User.class);
        HugeFactoryAuthProxy.registerPrivateActions(HugeGraphAuthProxy.class);
        HugeFactoryAuthProxy.registerPrivateActions(HugeGraphAuthProxy.AuthManagerProxy.class);
        HugeFactoryAuthProxy.registerPrivateActions(HugeGraphAuthProxy.TaskSchedulerProxy.class);
        HugeFactoryAuthProxy.registerPrivateActions(HugeGraphAuthProxy.GraphTraversalSourceProxy.class);
        HugeFactoryAuthProxy.registerPrivateActions(HugeGraphAuthProxy.TraversalStrategiesProxy.class);
        HugeFactoryAuthProxy.registerPrivateActions(HugeGraphAuthProxy.VariablesProxy.class);
        HugeFactoryAuthProxy.registerPrivateActions(HugeGraphAuthProxy.Context.class);
        HugeFactoryAuthProxy.registerPrivateActions(HugeGraphAuthProxy.ContextThreadPoolExecutor.class);
        HugeFactoryAuthProxy.registerPrivateActions(HugeGraphAuthProxy.ContextTask.class);
        for (Class clazz : StandardHugeGraph.PROTECT_CLASSES) {
            HugeFactoryAuthProxy.registerPrivateActions(clazz);
        }
        HugeFactoryAuthProxy.registerPrivateActions(HugeFactory.class);
        HugeFactoryAuthProxy.registerPrivateActions(AbstractTransaction.class);
        HugeFactoryAuthProxy.registerPrivateActions(SchemaElement.class);
        HugeFactoryAuthProxy.registerPrivateActions(HugeVertex.class);
        HugeFactoryAuthProxy.registerPrivateActions(HugeEdge.class);
        HugeFactoryAuthProxy.registerPrivateActions(HugeProperty.class);
        HugeFactoryAuthProxy.registerPrivateActions(HugeVariables.class);
        HugeFactoryAuthProxy.registerPrivateActions(SchemaManager.class);
        HugeFactoryAuthProxy.registerPrivateActions(PropertyKeyBuilder.class);
        HugeFactoryAuthProxy.registerPrivateActions(VertexLabelBuilder.class);
        HugeFactoryAuthProxy.registerPrivateActions(EdgeLabelBuilder.class);
        HugeFactoryAuthProxy.registerPrivateActions(IndexLabelBuilder.class);
        HugeFactoryAuthProxy.registerPrivateActions(TaskManager.class);
        HugeFactoryAuthProxy.registerPrivateActions(StandardTaskScheduler.class);
        HugeFactoryAuthProxy.registerPrivateActions(HugeTask.class);
        HugeFactoryAuthProxy.registerPrivateActions(TaskCallable.class);
        HugeFactoryAuthProxy.registerPrivateActions(TaskCallable.SysTaskCallable.class);
        HugeFactoryAuthProxy.registerPrivateActions(StandardAuthManager.class);
        HugeFactoryAuthProxy.registerPrivateActions(SchemaDefine.class);
        HugeFactoryAuthProxy.registerPrivateActions(EntityManager.class);
        HugeFactoryAuthProxy.registerPrivateActions(RelationshipManager.class);
        HugeFactoryAuthProxy.registerPrivateActions(CacheManager.class);
        HugeFactoryAuthProxy.registerPrivateActions(LockManager.class);
        HugeFactoryAuthProxy.registerPrivateActions(ServerReporter.class);
        HugeFactoryAuthProxy.registerPrivateActions(JsonSerializer.class);
        HugeFactoryAuthProxy.registerPrivateActions(HugeVertexStepStrategy.class);
        HugeFactoryAuthProxy.registerPrivateActions(HugeGraphStepStrategy.class);
        HugeFactoryAuthProxy.registerPrivateActions(HugeCountStepStrategy.class);
    }

    private static void registerPrivateActions(Class<?> clazz) {
        while (clazz != Object.class) {
            ArrayList<String> fields = new ArrayList<String>();
            for (Field field : clazz.getDeclaredFields()) {
                if (Modifier.isPublic(field.getModifiers())) continue;
                fields.add(field.getName());
            }
            ArrayList<String> methods = new ArrayList<String>();
            for (Method method : clazz.getDeclaredMethods()) {
                if (Modifier.isPublic(method.getModifiers()) && !PROTECT_METHODS.contains(method.getName())) continue;
                methods.add(method.getName());
            }
            HugeFactoryAuthProxy.registerClass(clazz, fields, methods);
            clazz = clazz.getSuperclass();
        }
    }

    private static boolean registerClass(Class<?> clazz, List<String> fields, List<String> methods) {
        if (clazz.getName().startsWith("java") || fields.isEmpty() && methods.isEmpty()) {
            return false;
        }
        String[] array = new String[fields.size()];
        try {
            Reflection.registerFieldsToFilter(clazz, (String[])fields.toArray(array));
            Reflection.registerMethodsToFilter(clazz, (String[])methods.toArray(array));
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().contains("Filter already registered: class")) {
                return false;
            }
            throw e;
        }
        String code = String.format("Reflection.registerFieldsToFilter(%s.class, \"%s\");", clazz.getCanonicalName(), String.join((CharSequence)"\", \"", fields));
        if (!fields.isEmpty()) {
            System.out.println(code);
        }
        code = String.format("Reflection.registerMethodsToFilter(%s.class, \"%s\");", clazz.getCanonicalName(), String.join((CharSequence)"\", \"", methods));
        if (!methods.isEmpty()) {
            System.out.println(code);
        }
        return true;
    }

    private static Class<?> loadClass(String clazz) {
        try {
            return Class.forName(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new HugeException(e.getMessage(), (Throwable)e);
        }
    }

    static {
        HugeGraphAuthProxy.setContext(HugeGraphAuthProxy.Context.admin());
        HugeFactoryAuthProxy.registerPrivateActions();
    }
}

