/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.define;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.NumericUtil;

public enum UpdateStrategy {
    SUM{

        @Override
        Object updatePropertyValue(Object oldProperty, Object newProperty) {
            BigDecimal oldNumber = new BigDecimal(oldProperty.toString());
            BigDecimal newNumber = new BigDecimal(newProperty.toString());
            return oldNumber.add(newNumber);
        }

        @Override
        void checkPropertyType(Object oldProperty, Object newProperty) {
            E.checkArgument((oldProperty instanceof Number && newProperty instanceof Number ? 1 : 0) != 0, (String)this.formatError(oldProperty, newProperty, "Number"), (Object[])new Object[0]);
        }
    }
    ,
    BIGGER{

        @Override
        Object updatePropertyValue(Object oldProperty, Object newProperty) {
            return 2.compareNumber(oldProperty, newProperty, BIGGER);
        }

        @Override
        void checkPropertyType(Object oldProperty, Object newProperty) {
            E.checkArgument((!(!(oldProperty instanceof Date) && !(oldProperty instanceof Number) || !(newProperty instanceof Date) && !(newProperty instanceof Number)) ? 1 : 0) != 0, (String)this.formatError(oldProperty, newProperty, "Date or Number"), (Object[])new Object[0]);
        }
    }
    ,
    SMALLER{

        @Override
        Object updatePropertyValue(Object oldProperty, Object newProperty) {
            return 3.compareNumber(oldProperty, newProperty, SMALLER);
        }

        @Override
        void checkPropertyType(Object oldProperty, Object newProperty) {
            E.checkArgument((!(!(oldProperty instanceof Date) && !(oldProperty instanceof Number) || !(newProperty instanceof Date) && !(newProperty instanceof Number)) ? 1 : 0) != 0, (String)this.formatError(oldProperty, newProperty, "Date or Number"), (Object[])new Object[0]);
        }
    }
    ,
    UNION{

        @Override
        Object updatePropertyValue(Object oldProperty, Object newProperty) {
            return 4.combineSet(oldProperty, newProperty, UNION);
        }

        @Override
        void checkPropertyType(Object oldProperty, Object newProperty) {
            this.checkCollectionType(oldProperty, newProperty);
        }
    }
    ,
    INTERSECTION{

        @Override
        Object updatePropertyValue(Object oldProperty, Object newProperty) {
            return 5.combineSet(oldProperty, newProperty, INTERSECTION);
        }

        @Override
        void checkPropertyType(Object oldProperty, Object newProperty) {
            this.checkCollectionType(oldProperty, newProperty);
        }
    }
    ,
    APPEND{

        @Override
        Object updatePropertyValue(Object oldProperty, Object newProperty) {
            ((Collection)oldProperty).addAll((Collection)newProperty);
            return oldProperty;
        }

        @Override
        void checkPropertyType(Object oldProperty, Object newProperty) {
            this.checkCollectionType(oldProperty, newProperty);
        }
    }
    ,
    ELIMINATE{

        @Override
        Object updatePropertyValue(Object oldProperty, Object newProperty) {
            ((Collection)oldProperty).removeAll((Collection)newProperty);
            return oldProperty;
        }

        @Override
        void checkPropertyType(Object oldProperty, Object newProperty) {
            this.checkCollectionType(oldProperty, newProperty);
        }
    }
    ,
    OVERRIDE{

        @Override
        Object updatePropertyValue(Object oldProperty, Object newProperty) {
            return newProperty;
        }

        @Override
        void checkPropertyType(Object oldProperty, Object newProperty) {
        }
    };


    abstract Object updatePropertyValue(Object var1, Object var2);

    abstract void checkPropertyType(Object var1, Object var2);

    public Object checkAndUpdateProperty(Object oldProperty, Object newProperty) {
        this.checkPropertyType(oldProperty, newProperty);
        return this.updatePropertyValue(oldProperty, newProperty);
    }

    protected String formatError(Object oldProperty, Object newProperty, String className) {
        return String.format("Property type must be %s for strategy %s, but got type %s, %s", new Object[]{className, this, oldProperty.getClass().getSimpleName(), newProperty.getClass().getSimpleName()});
    }

    protected void checkCollectionType(Object oldProperty, Object newProperty) {
        E.checkArgument((!(!(oldProperty instanceof Set) && !(oldProperty instanceof List) || !(newProperty instanceof Set) && !(newProperty instanceof List)) ? 1 : 0) != 0, (String)this.formatError(oldProperty, newProperty, "Set or List"), (Object[])new Object[0]);
    }

    protected static Object compareNumber(Object oldProperty, Object newProperty, UpdateStrategy strategy) {
        Number oldNum = NumericUtil.convertToNumber((Object)oldProperty);
        Number newNum = NumericUtil.convertToNumber((Object)newProperty);
        int result = NumericUtil.compareNumber((Object)oldNum, (Number)newNum);
        return strategy == BIGGER ? (result > 0 ? oldProperty : newProperty) : (result < 0 ? oldProperty : newProperty);
    }

    protected static Set<?> combineSet(Object oldProperty, Object newProperty, UpdateStrategy strategy) {
        Set oldSet = oldProperty instanceof Set ? (Set)oldProperty : new HashSet((List)oldProperty);
        Set newSet = newProperty instanceof Set ? (Set)newProperty : new HashSet((List)newProperty);
        return strategy == UNION ? Sets.union((Set)oldSet, (Set)newSet) : Sets.intersection((Set)oldSet, (Set)newSet);
    }
}

