/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.metrics;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SystemMetrics {
    private static final long MB = 0x100000L;

    public Map<String, Map<String, Object>> metrics() {
        LinkedHashMap<String, Map<String, Object>> metrics = new LinkedHashMap<String, Map<String, Object>>();
        metrics.put("basic", this.getBasicMetrics());
        metrics.put("heap", this.getHeapMetrics());
        metrics.put("nonheap", this.getNonHeapMetrics());
        metrics.put("thread", this.getThreadMetrics());
        metrics.put("class_loading", this.getClassLoadingMetrics());
        metrics.put("garbage_collector", this.getGarbageCollectionMetrics());
        return metrics;
    }

    private Map<String, Object> getBasicMetrics() {
        LinkedHashMap<String, Object> metrics = new LinkedHashMap<String, Object>();
        Runtime runtime = Runtime.getRuntime();
        long total = runtime.totalMemory();
        long free = runtime.freeMemory();
        long used = total - free;
        metrics.put("mem", (total + SystemMetrics.totalNonHeapMemory()) / 0x100000L);
        metrics.put("mem_total", total / 0x100000L);
        metrics.put("mem_used", used / 0x100000L);
        metrics.put("mem_free", free / 0x100000L);
        metrics.put("mem_unit", "MB");
        metrics.put("processors", runtime.availableProcessors());
        metrics.put("uptime", ManagementFactory.getRuntimeMXBean().getUptime());
        metrics.put("systemload_average", ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage());
        return metrics;
    }

    private static long totalNonHeapMemory() {
        try {
            return ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage().getCommitted();
        }
        catch (Throwable ignored) {
            return 0L;
        }
    }

    private Map<String, Object> getHeapMetrics() {
        LinkedHashMap<String, Object> metrics = new LinkedHashMap<String, Object>();
        MemoryUsage memoryUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        metrics.put("committed", memoryUsage.getCommitted() / 0x100000L);
        metrics.put("init", memoryUsage.getInit() / 0x100000L);
        metrics.put("used", memoryUsage.getUsed() / 0x100000L);
        metrics.put("max", memoryUsage.getMax() / 0x100000L);
        return metrics;
    }

    private Map<String, Object> getNonHeapMetrics() {
        LinkedHashMap<String, Object> metrics = new LinkedHashMap<String, Object>();
        MemoryUsage memoryUsage = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
        metrics.put("committed", memoryUsage.getCommitted() / 0x100000L);
        metrics.put("init", memoryUsage.getInit() / 0x100000L);
        metrics.put("used", memoryUsage.getUsed() / 0x100000L);
        metrics.put("max", memoryUsage.getMax() / 0x100000L);
        return metrics;
    }

    private Map<String, Object> getThreadMetrics() {
        LinkedHashMap<String, Object> metrics = new LinkedHashMap<String, Object>();
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        metrics.put("peak", threadMxBean.getPeakThreadCount());
        metrics.put("daemon", threadMxBean.getDaemonThreadCount());
        metrics.put("total_started", threadMxBean.getTotalStartedThreadCount());
        metrics.put("count", threadMxBean.getThreadCount());
        return metrics;
    }

    private Map<String, Object> getClassLoadingMetrics() {
        LinkedHashMap<String, Object> metrics = new LinkedHashMap<String, Object>();
        ClassLoadingMXBean classLoadingMxBean = ManagementFactory.getClassLoadingMXBean();
        metrics.put("count", classLoadingMxBean.getLoadedClassCount());
        metrics.put("loaded", classLoadingMxBean.getTotalLoadedClassCount());
        metrics.put("unloaded", classLoadingMxBean.getUnloadedClassCount());
        return metrics;
    }

    private Map<String, Object> getGarbageCollectionMetrics() {
        LinkedHashMap<String, Object> metrics = new LinkedHashMap<String, Object>();
        List<GarbageCollectorMXBean> gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcMxBean : gcMxBeans) {
            String name = SystemMetrics.formatName(gcMxBean.getName());
            metrics.put(name + "_count", gcMxBean.getCollectionCount());
            metrics.put(name + "_time", gcMxBean.getCollectionTime());
        }
        metrics.put("time_unit", "ms");
        return metrics;
    }

    private static String formatName(String name) {
        return StringUtils.replace((String)name, (String)" ", (String)"_").toLowerCase();
    }
}

