/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.cmd;

import java.util.Iterator;
import org.apache.hugegraph.HugeFactory;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.backend.store.BackendStore;
import org.apache.hugegraph.dist.RegisterUtil;
import org.apache.hugegraph.testutil.Whitebox;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;
import org.slf4j.Logger;

public class StoreDumper {
    private final HugeGraph graph;
    private static final Logger LOG = Log.logger(StoreDumper.class);

    public StoreDumper(String conf) {
        this.graph = HugeFactory.open((String)conf);
    }

    public void dump(HugeType table, long offset, long limit) {
        long i;
        BackendStore store = this.backendStore(table);
        Query query = new Query(table);
        Iterator rs = store.query(query);
        for (i = 0L; i < offset && rs.hasNext(); ++i) {
            rs.next();
        }
        LOG.info("Dump table {} (offset {} limit {}):", new Object[]{table, offset, limit});
        for (i = 0L; i < limit && rs.hasNext(); ++i) {
            BackendEntry entry = (BackendEntry)rs.next();
            LOG.info("{}", (Object)entry);
        }
        CloseableIterator.closeIterator((Iterator)rs);
    }

    private BackendStore backendStore(HugeType table) {
        String m = table.isSchema() ? "schemaTransaction" : "graphTransaction";
        Object tx = Whitebox.invoke((Object)this, (String)"graph", (String)m, (Object[])new Object[0]);
        return (BackendStore)Whitebox.invoke(tx.getClass(), (String)"store", (Object)tx, (Object[])new Object[0]);
    }

    public void close() throws Exception {
        this.graph.close();
    }

    public static void main(String[] args) throws Exception {
        E.checkArgument((args.length >= 1 ? 1 : 0) != 0, (String)"StoreDumper need a config file.", (Object[])new Object[0]);
        String conf = args[0];
        RegisterUtil.registerBackends();
        HugeType table = HugeType.valueOf((String)StoreDumper.arg(args, 1, "VERTEX").toUpperCase());
        long offset = Long.parseLong(StoreDumper.arg(args, 2, "0"));
        long limit = Long.parseLong(StoreDumper.arg(args, 3, "20"));
        StoreDumper dumper = new StoreDumper(conf);
        dumper.dump(table, offset, limit);
        dumper.close();
        HugeFactory.shutdown((long)30L, (boolean)true);
    }

    private static String arg(String[] args, int index, String deflt) {
        if (index < args.length) {
            return args[index];
        }
        return deflt;
    }
}

