/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc.impl.cli;

import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.rpc.CliRequests;
import com.alipay.sofa.jraft.rpc.RpcRequestClosure;
import com.alipay.sofa.jraft.rpc.impl.cli.BaseCliRequestProcessor;
import com.alipay.sofa.jraft.util.RpcFactoryHelper;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;

public class ResetLearnersRequestProcessor
extends BaseCliRequestProcessor<CliRequests.ResetLearnersRequest> {
    public ResetLearnersRequestProcessor(Executor executor) {
        super(executor, (Message)CliRequests.LearnersOpResponse.getDefaultInstance());
    }

    @Override
    protected String getPeerId(CliRequests.ResetLearnersRequest request) {
        return request.getLeaderId();
    }

    @Override
    protected String getGroupId(CliRequests.ResetLearnersRequest request) {
        return request.getGroupId();
    }

    @Override
    protected Message processRequest0(BaseCliRequestProcessor.CliRequestContext ctx, CliRequests.ResetLearnersRequest request, RpcRequestClosure done) {
        List<PeerId> oldLearners = ctx.node.listLearners();
        ArrayList<PeerId> newLearners = new ArrayList<PeerId>(request.getLearnersCount());
        Iterator iterator = request.getLearnersList().iterator();
        while (iterator.hasNext()) {
            PeerId peer = new PeerId();
            String peerStr = (String)iterator.next();
            if (!peer.parse(peerStr)) {
                return RpcFactoryHelper.responseFactory().newResponse(this.defaultResp(), RaftError.EINVAL, "Fail to parse peer id %s", peerStr);
            }
            newLearners.add(peer);
        }
        LOG.info("Receive ResetLearnersRequest to {} from {}, resetting into {}.", new Object[]{ctx.node.getNodeId(), done.getRpcCtx().getRemoteAddress(), newLearners});
        ctx.node.resetLearners(newLearners, status -> {
            if (!status.isOk()) {
                done.run(status);
            } else {
                CliRequests.LearnersOpResponse.Builder rb = CliRequests.LearnersOpResponse.newBuilder();
                for (PeerId peer : oldLearners) {
                    rb.addOldLearners(peer.toString());
                }
                for (PeerId peer : newLearners) {
                    rb.addNewLearners(peer.toString());
                }
                done.sendResponse((Message)rb.build());
            }
        });
        return null;
    }

    @Override
    public String interest() {
        return CliRequests.ResetLearnersRequest.class.getName();
    }
}

