/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step;

import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.ColumnTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.FunctionTraverser;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.IdentityTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.TokenTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.ValueTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.Barrier;
import org.apache.tinkerpop.gremlin.process.traversal.step.LocalBarrier;
import org.apache.tinkerpop.gremlin.process.traversal.step.ProfilingAware;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.LambdaMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ProfileStep;

public interface Grouping<S, K, V> {
    public Traversal.Admin<S, K> getKeyTraversal();

    public Traversal.Admin<S, V> getValueTraversal();

    default public Barrier determineBarrierStep(Traversal.Admin<S, V> traversal) {
        List<Step> steps = traversal.getSteps();
        for (int ix = 0; ix < steps.size(); ++ix) {
            Step step = steps.get(ix);
            if (!(step instanceof Barrier) || step instanceof LocalBarrier) continue;
            Barrier b = (Barrier)((Object)step);
            if (ix < steps.size() - 1 && steps.get(ix + 1) instanceof ProfileStep) {
                return new ProfilingAware.ProfiledBarrier(b, (ProfileStep)steps.get(ix + 1));
            }
            return b;
        }
        return null;
    }

    default public Traversal.Admin<S, V> convertValueTraversal(Traversal.Admin<S, V> valueTraversal) {
        if (valueTraversal instanceof ValueTraversal || valueTraversal instanceof TokenTraversal || valueTraversal instanceof IdentityTraversal || valueTraversal instanceof ColumnTraversal || valueTraversal.getStartStep() instanceof LambdaMapStep && ((LambdaMapStep)valueTraversal.getStartStep()).getMapFunction() instanceof FunctionTraverser) {
            return (Traversal.Admin)((Object)__.map(valueTraversal).fold());
        }
        return valueTraversal;
    }

    default public Map<K, V> doFinalReduction(Map<K, Object> map, Traversal.Admin<S, V> valueTraversal) {
        Barrier barrierStep = this.determineBarrierStep(valueTraversal);
        if (barrierStep != null) {
            for (K key : map.keySet()) {
                valueTraversal.reset();
                barrierStep.addBarrier(map.get(key));
                if (!valueTraversal.hasNext()) continue;
                map.put(key, valueTraversal.next());
            }
        }
        return map;
    }
}

