/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.gremlin.extension;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public enum CypherBindingType {
    ANY(Object.class),
    BOOLEAN(Boolean.class),
    STRING(String.class),
    NUMBER(Number.class),
    FLOAT(Float.class),
    INTEGER(Integer.class),
    MAP(Map.class),
    LIST(List.class),
    NODE(Map.class),
    RELATIONSHIP(Map.class);

    private final Class<?> javaClass;

    private CypherBindingType(Class<?> javaClass) {
        this.javaClass = javaClass;
    }

    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    public boolean isAssignableFrom(CypherBindingType type) {
        return this.getJavaClass().isAssignableFrom(type.getJavaClass());
    }

    public static CypherBindingType fromSignature(String type) {
        return Stream.of(CypherBindingType.values()).filter(v -> (v.name() + "?").equals(type)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unparsable procedure type: " + type));
    }
}

